/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.index;

import VASSAL.counters.GamePiece;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PiecePropertyIndex {
    private final Map<String, Set<GamePiece>> pieces = new HashMap<String, Set<GamePiece>>();
    private final Map<String, String> values = new HashMap<String, String>();
    private final String propertyName;

    public PiecePropertyIndex(String propertyName) {
        this.propertyName = propertyName;
    }

    public void addOrUpdatePiece(GamePiece piece) {
        Set<GamePiece> piecesWithValue;
        String newValue = (String)piece.getProperty(this.propertyName);
        if (this.values.containsKey(piece.getId())) {
            String oldValue = this.values.get(piece.getId());
            if (Objects.equals(newValue, oldValue)) {
                return;
            }
            this.removePiece(piece);
        }
        if ((piecesWithValue = this.pieces.get(newValue)) == null) {
            piecesWithValue = new HashSet<GamePiece>();
        }
        piecesWithValue.add(piece);
        this.pieces.put(newValue, piecesWithValue);
        this.values.put(piece.getId(), newValue);
    }

    public int getCount() {
        return this.values.size();
    }

    public void removePiece(GamePiece piece) {
        if (this.values.containsKey(piece.getId())) {
            String oldValue = this.values.get(piece.getId());
            Set<GamePiece> piecesWithValue = this.pieces.get(oldValue);
            if (piecesWithValue != null) {
                piecesWithValue.remove(piece);
                this.pieces.put(oldValue, piecesWithValue);
            }
            this.values.remove(piece.getId());
        }
    }

    public Set<GamePiece> getPieces(String propertyValue) {
        HashSet results = this.pieces.get(propertyValue);
        return results == null ? new HashSet() : results;
    }
}

