/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.TranslatableString;
import VASSAL.build.module.properties.TranslatableStringContainer;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.i18n.Resources;
import VASSAL.tools.FormattedString;
import VASSAL.tools.TemporaryToolBar;
import VASSAL.tools.ToolBarComponent;
import java.util.List;
import javax.swing.JToolBar;

public class GlobalTranslatableMessage
extends AbstractConfigurable
implements ToolBarComponent,
GameComponent,
PropertySource,
TranslatableString {
    public static final String NAME = "name";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String DESCRIPTION = "description";
    protected static final String COMMAND_PREFIX = "GlobalTranslatable\t";
    protected TemporaryToolBar tempToolbar = new TemporaryToolBar();
    protected String description = "";
    protected String initialValue = "";
    protected FormattedString format = new FormattedString();
    protected PropertySource propertySource;
    protected TranslatableString.Impl property = new TranslatableString.Impl("", this);
    protected TranslatableStringContainer parentContainer;

    public GlobalTranslatableMessage() {
    }

    public GlobalTranslatableMessage(GlobalTranslatableMessage p) {
        this();
        this.setConfigureName(p.getConfigureName());
        this.description = p.description;
        this.initialValue = p.initialValue;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.GlobalTranslatableMessage.message"), Resources.getString("Editor.description_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, INITIAL_VALUE, DESCRIPTION};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            this.property.setPropertyName(this.getConfigureName());
        } else if (INITIAL_VALUE.equals(key)) {
            this.initialValue = (String)value;
            if (this.initialValue == null) {
                this.initialValue = "";
            }
            this.property.setPropertyValue(this.initialValue);
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (INITIAL_VALUE.equals(key)) {
            return this.initialValue;
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.property.removeFromContainer();
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalTranslatableMessages.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        this.parentContainer = (TranslatableStringContainer)((Object)parent);
        this.property.addTo(this.parentContainer);
        this.tempToolbar.setDelegate((ToolBarComponent)((Object)parent));
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.propertySource = (PropertySource)((Object)parent);
        this.setAllAttributesUntranslatable();
        this.setAttributeTranslatable(INITIAL_VALUE, true);
    }

    @Override
    public JToolBar getToolBar() {
        return this.tempToolbar.getToolBar();
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.property.setPropertyValue(this.initialValue);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new NullCommand();
    }

    protected String getPropertyId() {
        return this.getConfigureName();
    }

    protected String getContainerId() {
        return this.parentContainer == null ? "" : this.parentContainer.getTranslatableStringContainerId();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertySource == null ? null : this.propertySource.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.propertySource == null ? null : this.propertySource.getLocalizedProperty(key);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalTranslatableMessage.component_type");
    }

    public void setPropertyName(String name) {
        this.property.setPropertyName(name);
    }

    @Override
    public void setPropertyValue(String newValue) {
        this.property.setPropertyValue(newValue);
    }

    @Override
    public String getPropertyValue() {
        return this.property.getPropertyValue();
    }

    @Override
    public TranslatableStringContainer getParent() {
        return this.parentContainer;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.initialValue);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.property.getName());
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.description);
    }
}

