/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.peer2peer.TextClient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class ClientTest
extends P2PClient
implements Runnable,
PropertyChangeListener {
    private static Random rng = new Random();
    private final int changeRoom;
    private final int numRooms;
    private final FileWriter log;

    public ClientTest(PeerPool pool, WelcomeMessageServer welcomer, int changeRoom, int numRooms, FileWriter log) {
        super(new TextClient.Encoder(), welcomer, pool);
        this.changeRoom = changeRoom;
        this.numRooms = numRooms;
        this.log = log;
        this.addPropertyChangeListener("AvailableRooms", this);
        this.setConnected(true);
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.changeRoom * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String newRoom = "Room" + (int)((float)this.numRooms * rng.nextFloat());
            this.setRoom(new SimpleRoom(newRoom));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            this.log.write("----------" + String.valueOf(new Date()) + "---------\n");
            this.log.write(ClientTest.report((Room[])evt.getNewValue()));
            this.log.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String report(Room[] r) {
        StringBuilder buffer = new StringBuilder();
        for (Room room : r) {
            buffer.append(room.getName()).append(": ");
            List<Player> l = room.getPlayerList();
            for (int j = 0; j < l.size(); ++j) {
                buffer.append(l.get(j));
                if (j >= l.size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

