/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ui.RoomTreeRenderer;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class LockableRoomTreeRenderer
extends RoomTreeRenderer {
    private static final long serialVersionUID = 1L;
    private final Icon lockedIcon;
    private Font nonOwnerFont = null;
    private Font ownerFont = null;

    public LockableRoomTreeRenderer() {
        URL image = this.getClass().getResource("/images/lockedRoom.gif");
        this.lockedIcon = image != null ? new ImageIcon(image) : null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode roomNode;
        Object room;
        JLabel l = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object item = ((DefaultMutableTreeNode)value).getUserObject();
        if (item instanceof LockableRoom) {
            if (this.lockedIcon != null && ((LockableRoom)item).isLocked()) {
                l.setIcon(this.lockedIcon);
            }
        } else if (item instanceof Player && (room = (roomNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent()).getUserObject()) instanceof LockableRoom && !"Main Room".equals(((Room)room).getName()) && ((LockableRoom)room).isOwner(((Player)item).getId())) {
            if (this.ownerFont == null) {
                this.nonOwnerFont = this.getFont();
                this.ownerFont = new Font(this.nonOwnerFont.getFontName(), this.nonOwnerFont.getStyle() + 1, this.nonOwnerFont.getSize());
            }
            this.setFont(this.ownerFont);
            return l;
        }
        this.setFont(this.nonOwnerFont);
        return l;
    }
}

