/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public abstract class ListConfigurer
extends Configurer
implements PropertyChangeListener {
    protected JPanel controls;
    protected JPanel configControls;
    protected JPanel panel;
    protected Dimension fixedSize;
    protected List<Configurer> configurers = new ArrayList<Configurer>();

    public ListConfigurer(String key, String name) {
        super(key, name, new ArrayList());
    }

    public ListConfigurer(String key, String name, List<?> val) {
        super(key, name, val);
    }

    @Override
    public String getValueString() {
        if (this.getListValue().isEmpty()) {
            return "";
        }
        Configurer c = this.buildChildConfigurer();
        SequenceEncoder se = new SequenceEncoder(',');
        for (Object value : this.getListValue()) {
            c.setFrozen(true);
            c.setValue(value);
            c.setFrozen(false);
            se.append(c.getValueString());
        }
        return se.getValue();
    }

    @Override
    public void setValue(String s) {
        this.getListValue().clear();
        if (s.length() > 0) {
            Configurer c = this.buildChildConfigurer();
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
            while (sd.hasMoreTokens()) {
                c.setValue(sd.nextToken());
                this.getListValue().add(c.getValue());
            }
        }
        this.updateControls();
    }

    protected void updateValue() {
        this.noUpdate = true;
        ArrayList<Object> newArray = new ArrayList<Object>();
        for (Configurer c : this.configurers) {
            newArray.add(c.getValue());
        }
        this.setValue(newArray);
        this.noUpdate = false;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = new ArrayList();
        }
        super.setValue(o);
        if (!this.noUpdate) {
            this.updateControls();
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill]", "[]"));
            this.panel.setBorder(BorderFactory.createEtchedBorder());
            this.controls = new JPanel((LayoutManager)new MigLayout("ins 2", "[grow,fill]"));
            this.configControls = new JPanel((LayoutManager)new MigLayout("ins 0,gapy 4", "[grow]"));
            JButton addButton = new JButton(Resources.getString("Editor.ListConfigurer.new"));
            addButton.addActionListener(e -> {
                Configurer c = this.buildChildConfigurer();
                this.getListValue().add(c.getValue());
                this.updateControls();
            });
            JPanel addPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]push"));
            addPanel.add(addButton);
            this.controls.add((Component)addPanel, "grow,wrap");
            this.controls.add((Component)this.configControls, "grow");
            this.panel.add((Component)this.controls, "grow");
            this.updateControls();
        }
        return this.panel;
    }

    public List<Object> getListValue() {
        return (List)this.getValue();
    }

    protected abstract Configurer buildChildConfigurer();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateValue();
    }

    protected void updateControls() {
        if (this.controls != null) {
            for (Configurer c : this.configurers) {
                c.removePropertyChangeListener(this);
            }
            this.configurers.clear();
            this.configControls.removeAll();
            for (Object value : this.getListValue()) {
                Configurer c = this.buildChildConfigurer();
                c.setValue(value);
                c.addPropertyChangeListener(this);
                this.configurers.add(c);
                JPanel b = new JPanel((LayoutManager)new MigLayout("ins 0,gapy 4", "[fill,grow][]"));
                JButton delButton = new JButton(Resources.getString("Editor.ListConfigurer.remove"));
                delButton.addActionListener(e -> {
                    this.getListValue().remove(c.getValue());
                    this.updateControls();
                    this.repack();
                });
                b.add(c.getControls(), "grow");
                b.add((Component)delButton, "aligny center");
                this.configControls.add((Component)b, "grow,wrap");
            }
            this.resize();
        }
    }

    public void resize() {
        if (this.controls != null) {
            Dimension s = this.controls.getPreferredSize();
            int t = (Integer)UIManager.get("ScrollBar.width");
            this.panel.setPreferredSize(new Dimension(s.width + t + 2, Math.min(this.controls.getPreferredSize().height + 5, (int)this.getScreenSize().getHeight() - 300)));
            this.repack();
        }
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    public int hashCode() {
        String valueString = this.getValueString();
        int prime = 31;
        int result = 1;
        result = 31 * result + (valueString == null ? 0 : valueString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListConfigurer other = (ListConfigurer)obj;
        String valueString = this.getValueString();
        String otherValueString = other.getValueString();
        if (valueString == null) {
            return otherValueString == null;
        }
        return valueString.equals(otherValueString);
    }
}

