/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.Resources;
import java.util.HashSet;

public class UniquelyNamedChildren
implements ValidityChecker {
    private final AbstractConfigurable target;
    private final Class<?> childClass;

    public UniquelyNamedChildren(AbstractConfigurable target, Class<?> childClass) {
        this.childClass = childClass;
        this.target = target;
    }

    @Override
    public void validate(Buildable b, ValidationReport report) {
        if (b == this.target) {
            HashSet<String> children = new HashSet<String>();
            HashSet<String> duplicates = new HashSet<String>();
            for (Object child : this.target.getAllDescendantComponentsOf(this.childClass)) {
                if (!(child instanceof Configurable)) continue;
                String name = ((Configurable)child).getConfigureName();
                if (children.contains(name)) {
                    duplicates.add(name);
                    continue;
                }
                children.add(name);
            }
            if (!duplicates.isEmpty()) {
                for (String name : duplicates) {
                    report.addWarning(Resources.getString("Editor.ValidityChecker.duplicate_warning", ConfigureTree.getConfigureName(this.childClass), name, ConfigureTree.getConfigureName(this.target), ConfigureTree.getConfigureName(this.target.getClass())));
                }
            }
        }
    }
}

