/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.command.SetPersistentPropertyCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ImageSelector;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeySpecifier;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.counters.StateMergeable;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Localization;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.property.PersistentPropertyContainer;
import VASSAL.search.AbstractImageFinder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class BasicPiece
extends AbstractImageFinder
implements TranslatablePiece,
StateMergeable,
PropertyNameSource,
PersistentPropertyContainer,
PropertyExporter {
    public static final String ID = "piece;";
    private static Highlighter highlighter;
    public static final String LOCATION_NAME = "LocationName";
    public static final String CURRENT_MAP = "CurrentMap";
    public static final String CURRENT_BOARD = "CurrentBoard";
    public static final String CURRENT_ZONE = "CurrentZone";
    public static final String CURRENT_X = "CurrentX";
    public static final String CURRENT_Y = "CurrentY";
    public static final String OLD_LOCATION_NAME = "OldLocationName";
    public static final String OLD_MAP = "OldMap";
    public static final String OLD_BOARD = "OldBoard";
    public static final String OLD_ZONE = "OldZone";
    public static final String OLD_X = "OldX";
    public static final String OLD_Y = "OldY";
    public static final String OLD_MAT = "OldMat";
    public static final String OLD_MAT_ID = "OldMatID";
    public static final String OLD_MAT_PIECE_NAME = "OldMatPieceName";
    public static final String OLD_MAT_BASIC_NAME = "OldMatBasicName";
    public static final String OLD_MAT_OFFSET_X = "OldMatOffsetX";
    public static final String OLD_MAT_OFFSET_Y = "OldMatOffsetY";
    public static final String BASIC_NAME = "BasicName";
    public static final String PIECE_NAME = "PieceName";
    public static final String LOCALIZED_BASIC_NAME = "LocalizedBasicName";
    public static final String LOCALIZED_PIECE_NAME = "LocalizedPieceName";
    public static final String DECK_NAME = "DeckName";
    public static final String OLD_DECK_NAME = "OldDeckName";
    public static final String DECK_POSITION = "DeckPosition";
    public static final String CLICKED_X = "ClickedX";
    public static final String CLICKED_Y = "ClickedY";
    public static final String PIECE_UID = "PieceUID";
    public static final String STACK_POS = "StackPos";
    public static final String STACK_SIZE = "StackSize";
    public static final String UNIQUE_ID = "UniqueID";
    @Deprecated(since="2022-08-08", forRemoval=true)
    public static Font POPUP_MENU_FONT;
    protected JPopupMenu popup;
    protected Rectangle imageBounds;
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();
    private Map map;
    private KeyCommand[] commands;
    private Stack parent;
    private Point pos = new Point(0, 0);
    private String id;
    private java.util.Map<Object, Object> props;
    private java.util.Map<Object, Object> persistentProps;
    @Deprecated(since="2021-12-01", forRemoval=true)
    private char cloneKey;
    @Deprecated(since="2021-12-01", forRemoval=true)
    private char deleteKey;
    @Deprecated(since="2021-12-01", forRemoval=true)
    protected Image image;
    protected String imageName;
    private String commonName;

    public BasicPiece() {
        this("piece;;;;;");
    }

    public BasicPiece(String type) {
        this.mySetType(type);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.cloneKey = st.nextChar('\u0000');
        this.deleteKey = st.nextChar('\u0000');
        this.imageName = st.nextToken();
        this.commonName = st.nextToken();
        this.imagePainter.setImageName(this.imageName);
        this.imageBounds = null;
        this.commands = null;
    }

    @Override
    public String getType() {
        SequenceEncoder se = new SequenceEncoder(this.cloneKey > '\u0000' ? String.valueOf(this.cloneKey) : "", ';');
        return ID + se.append(this.deleteKey > '\u0000' ? String.valueOf(this.deleteKey) : "").append(this.imageName).append(this.commonName).getValue();
    }

    @Override
    public void setMap(Map map) {
        if (map != this.map) {
            this.commands = null;
            this.map = map;
        }
    }

    @Override
    public Map getMap() {
        return this.getParent() == null ? this.map : this.getParent().getMap();
    }

    @Override
    public Object getProperty(Object key) {
        if (BASIC_NAME.equals(key)) {
            return this.getRealName();
        }
        if (LOCALIZED_BASIC_NAME.equals(key)) {
            return this.getRealLocalizedName();
        }
        return this.getPublicProperty(key);
    }

    public Object getPublicProperty(Object key) {
        Object prop;
        if ("KeyCommands".equals(key)) {
            return this.getKeyCommands();
        }
        if (LOCATION_NAME.equals(key)) {
            return this.getMap() == null ? "" : this.getMap().locationName(this.getPosition());
        }
        if (PIECE_NAME.equals(key)) {
            return Decorator.getOutermost(this).getName();
        }
        if (LOCALIZED_PIECE_NAME.equals(key)) {
            return Decorator.getOutermost(this).getLocalizedName();
        }
        if (CURRENT_MAP.equals(key)) {
            return this.getMap() == null ? "" : this.getMap().getConfigureName();
        }
        if (DECK_NAME.equals(key)) {
            return this.getParent() instanceof Deck ? ((Deck)this.getParent()).getDeckName() : "";
        }
        if (DECK_POSITION.equals(key)) {
            if (this.getParent() instanceof Deck) {
                Deck deck = (Deck)this.getParent();
                int size = deck.getPieceCount();
                int pos = deck.indexOf(Decorator.getOutermost(this));
                return String.valueOf(size - pos);
            }
            return "0";
        }
        if (CURRENT_BOARD.equals(key)) {
            Board b;
            if (this.getMap() != null && (b = this.getMap().findBoard(this.getPosition())) != null) {
                return b.getName();
            }
            return "";
        }
        if (CURRENT_ZONE.equals(key)) {
            Zone z;
            if (this.getMap() != null && (z = this.getMap().findZone(this.getPosition())) != null) {
                return z.getName();
            }
            return "";
        }
        if (CURRENT_X.equals(key)) {
            return String.valueOf(this.getPosition().x);
        }
        if (CURRENT_Y.equals(key)) {
            return String.valueOf(this.getPosition().y);
        }
        if (PIECE_UID.equals(key)) {
            return this.getId();
        }
        if (UNIQUE_ID.equals(key)) {
            return (String)this.getPersistentProps().get(UNIQUE_ID);
        }
        if (STACK_POS.equals(key)) {
            Stack parent = this.getParent();
            if (parent == null) {
                return "1";
            }
            GamePiece outer = Decorator.getOutermost(this);
            int i = parent.indexOf(outer);
            if (i != -1) {
                return String.valueOf(parent.getPieceCount() - i);
            }
            return "1";
        }
        if (STACK_SIZE.equals(key)) {
            Stack parent = this.getParent();
            return parent == null ? "1" : String.valueOf(parent.getPieceCount());
        }
        if ("visibleState".equals(key)) {
            return "";
        }
        Object object = prop = this.props == null ? null : this.props.get(key);
        if (prop == null) {
            prop = this.getPersistentProps().get(key);
        }
        if (prop == null) {
            Zone zone;
            Map map = this.getMap();
            Zone zone2 = zone = map == null ? null : map.findZone(this.getPosition());
            prop = zone != null ? zone.getProperty(key) : (map != null ? map.getProperty(key) : GameModule.getGameModule().getProperty(key));
        }
        return prop;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (BASIC_NAME.equals(key)) {
            return this.getRealLocalizedName();
        }
        return this.getLocalizedPublicProperty(key);
    }

    public Object getLocalizedPublicProperty(Object key) {
        Object prop;
        if (List.of("KeyCommands", DECK_NAME, CURRENT_X, CURRENT_Y, PIECE_UID, STACK_POS, STACK_SIZE, "visibleState").contains(key)) {
            return this.getProperty(key);
        }
        if (LOCATION_NAME.equals(key)) {
            return this.getMap() == null ? "" : this.getMap().localizedLocationName(this.getPosition());
        }
        if (PIECE_NAME.equals(key)) {
            return Decorator.getOutermost(this).getName();
        }
        if (BASIC_NAME.equals(key)) {
            return this.getRealLocalizedName();
        }
        if (CURRENT_MAP.equals(key)) {
            return this.getMap() == null ? "" : this.getMap().getLocalizedConfigureName();
        }
        if (DECK_POSITION.equals(key)) {
            if (this.getParent() instanceof Deck) {
                Deck deck = (Deck)this.getParent();
                int size = deck.getPieceCount();
                int pos = deck.indexOf(Decorator.getOutermost(this));
                return String.valueOf(size - pos);
            }
            return "0";
        }
        if (CURRENT_BOARD.equals(key)) {
            Board b;
            if (this.getMap() != null && (b = this.getMap().findBoard(this.getPosition())) != null) {
                return b.getLocalizedName();
            }
            return "";
        }
        if (CURRENT_ZONE.equals(key)) {
            Zone z;
            if (this.getMap() != null && (z = this.getMap().findZone(this.getPosition())) != null) {
                return z.getLocalizedName();
            }
            return "";
        }
        Object object = prop = this.props == null ? null : this.props.get(key);
        if (prop == null) {
            prop = this.getPersistentProps().get(key);
        }
        if (prop == null) {
            Zone zone;
            Map map = this.getMap();
            Zone zone2 = zone = map == null ? null : map.findZone(this.getPosition());
            prop = zone != null ? zone.getLocalizedProperty(key) : (map != null ? map.getLocalizedProperty(key) : GameModule.getGameModule().getLocalizedProperty(key));
        }
        return prop;
    }

    @Override
    public void setProperty(Object key, Object val) {
        if (this.props == null) {
            this.props = new HashMap<Object, Object>();
        }
        if (val == null) {
            this.props.remove(key);
        } else {
            this.props.put(key, val);
        }
    }

    @Override
    public Command setPersistentProperty(Object key, Object newValue) {
        Object oldValue = newValue == null ? this.getPersistentProps().remove(key) : this.getPersistentProps().put(key, newValue);
        return Objects.equals(oldValue, newValue) ? null : new SetPersistentPropertyCommand(this.getId(), key, oldValue, newValue);
    }

    @Override
    public Object getPersistentProperty(Object key) {
        return this.getPersistentProps().get(key);
    }

    private java.util.Map<Object, Object> getPersistentProps() {
        if (this.persistentProps == null) {
            this.persistentProps = new HashMap<Object, Object>();
        }
        return this.persistentProps;
    }

    protected Object prefsValue(String s) {
        return GameModule.getGameModule().getPrefs().getValue(s);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        if (this.imageBounds == null) {
            this.imageBounds = this.boundingBox();
        }
        this.imagePainter.draw(g, x + (int)(zoom * (double)this.imageBounds.x), y + (int)(zoom * (double)this.imageBounds.y), zoom, obs);
    }

    protected KeyCommand[] getKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            GamePiece target = Decorator.getOutermost(this);
            if (this.cloneKey > '\u0000') {
                l.add(new KeyCommand(Resources.getString("Editor.Clone.clone"), KeyStroke.getKeyStroke((int)this.cloneKey, 128), target));
            }
            if (this.deleteKey > '\u0000') {
                l.add(new KeyCommand(Resources.getString("Editor.Delete.delete"), KeyStroke.getKeyStroke((int)this.deleteKey, 128), target));
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        GamePiece outer = Decorator.getOutermost(this);
        this.enableCommand(Resources.getString("Editor.Clone.clone"), outer.getMap() != null);
        this.enableCommand(Resources.getString("Editor.Delete.delete"), outer.getMap() != null);
        return this.commands;
    }

    private void enableCommand(String name, boolean enable) {
        for (KeyCommand command : this.commands) {
            if (!name.equals(command.getName())) continue;
            command.setEnabled(enable);
        }
    }

    private boolean isEnabled(KeyStroke stroke) {
        if (stroke == null) {
            return false;
        }
        for (KeyCommand command : this.commands) {
            if (!stroke.equals(command.getKeyStroke())) continue;
            return command.isEnabled();
        }
        return true;
    }

    @Override
    public Point getPosition() {
        return this.getParent() == null ? new Point(this.pos) : this.getParent().getPosition();
    }

    @Override
    public void setPosition(Point p) {
        if (this.getMap() != null && this.getParent() == null) {
            this.getMap().repaint(this.getMap().boundingBoxOf(Decorator.getOutermost(this)));
        }
        this.pos = p;
        if (this.getMap() != null && this.getParent() == null) {
            this.getMap().repaint(this.getMap().boundingBoxOf(Decorator.getOutermost(this)));
        }
    }

    @Override
    public Stack getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Stack s) {
        this.parent = s;
        if (this.parent != null) {
            this.setMap(this.parent.getMap());
        }
    }

    @Override
    public Rectangle boundingBox() {
        if (this.imageBounds == null) {
            this.imageBounds = ImageUtils.getBounds(this.imagePainter.getImageSize());
        }
        return new Rectangle(this.imageBounds);
    }

    @Override
    public Shape getShape() {
        return this.boundingBox();
    }

    public boolean equals(GamePiece c) {
        return c == this;
    }

    public String getRealName() {
        return this.commonName;
    }

    @Override
    public String getName() {
        return (String)Decorator.getOutermost(this).getProperty(BASIC_NAME);
    }

    public String getRealLocalizedName() {
        String key = "Piece." + this.getName();
        return Localization.getInstance().translate(key, this.getName());
    }

    @Override
    public String getLocalizedName() {
        return (String)Decorator.getOutermost(this).getLocalizedProperty(BASIC_NAME);
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        this.getKeyCommands();
        if (!this.isEnabled(stroke)) {
            return null;
        }
        Command comm = null;
        GamePiece outer = Decorator.getOutermost(this);
        if (this.cloneKey != '\u0000' && KeyStroke.getKeyStroke((int)this.cloneKey, 128).equals(stroke)) {
            GamePiece newPiece = ((AddPiece)GameModule.getGameModule().decode(GameModule.getGameModule().encode(new AddPiece(outer)))).getTarget();
            newPiece.setId(null);
            GameModule.getGameModule().getGameState().addPiece(newPiece);
            newPiece.setState(outer.getState());
            comm = new AddPiece(newPiece);
            if (this.getMap() != null) {
                comm.append(this.getMap().placeOrMerge(newPiece, this.getPosition()));
                KeyBuffer.getBuffer().remove(outer);
                KeyBuffer.getBuffer().add(newPiece);
                if (GlobalOptions.getInstance().autoReportEnabled() && !Boolean.TRUE.equals(outer.getProperty("InvisibleToOthers"))) {
                    String name = outer.getLocalizedName();
                    String loc = this.getMap().locationName(outer.getPosition());
                    String s = loc != null ? Resources.getString("BasicPiece.clone_report_1", name, loc) : Resources.getString("BasicPiece.clone_report_2", name);
                    Chatter.DisplayText report = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), s);
                    report.execute();
                    comm = comm.append(report);
                }
            }
        } else if (this.deleteKey != '\u0000' && KeyStroke.getKeyStroke((int)this.deleteKey, 128).equals(stroke)) {
            comm = new RemovePiece(outer);
            if (this.getMap() != null && GlobalOptions.getInstance().autoReportEnabled() && !Boolean.TRUE.equals(outer.getProperty("InvisibleToOthers"))) {
                String name = outer.getLocalizedName();
                String loc = this.getMap().locationName(outer.getPosition());
                String s = loc != null ? Resources.getString("BasicPiece.delete_report_1", name, loc) : Resources.getString("BasicPiece.delete_report_2", name);
                Chatter.DisplayText report = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), s);
                comm = comm.append(report);
            }
            comm.execute();
        } else if (this.getMap() != null && stroke.equals(this.getMap().getStackMetrics().getMoveUpKey())) {
            if (this.parent != null) {
                String oldState = this.parent.getState();
                int index = this.parent.indexOf(outer);
                if (index < this.parent.getPieceCount() - 1) {
                    this.parent.insert(outer, index + 1);
                    comm = new ChangePiece(this.parent.getId(), oldState, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToFront(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToFront(outer);
            }
        } else if (this.getMap() != null && stroke.equals(this.getMap().getStackMetrics().getMoveDownKey())) {
            if (this.parent != null) {
                String oldState = this.parent.getState();
                int index = this.parent.indexOf(outer);
                if (index > 0) {
                    this.parent.insert(outer, index - 1);
                    comm = new ChangePiece(this.parent.getId(), oldState, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToBack(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToBack(outer);
            }
        } else if (this.getMap() != null && stroke.equals(this.getMap().getStackMetrics().getMoveTopKey())) {
            this.parent = outer.getParent();
            if (this.parent != null) {
                String oldState = this.parent.getState();
                if (this.parent.indexOf(outer) < this.parent.getPieceCount() - 1) {
                    this.parent.insert(outer, this.parent.getPieceCount() - 1);
                    comm = new ChangePiece(this.parent.getId(), oldState, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToFront(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToFront(outer);
            }
        } else if (this.getMap() != null && stroke.equals(this.getMap().getStackMetrics().getMoveBottomKey())) {
            this.parent = this.getParent();
            if (this.parent != null) {
                String oldState = this.parent.getState();
                if (this.parent.indexOf(outer) > 0) {
                    this.parent.insert(outer, 0);
                    comm = new ChangePiece(this.parent.getId(), oldState, this.parent.getState());
                } else {
                    this.getMap().getPieceCollection().moveToBack(this.parent);
                }
            } else {
                this.getMap().getPieceCollection().moveToBack(outer);
            }
        }
        return comm;
    }

    @Override
    public String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        Map m = this.getMap();
        String mapName = m == null ? "null" : m.getIdentifier();
        se.append(mapName);
        Point p = this.getPosition();
        se.append(p.x).append(p.y);
        se.append(this.getGpId());
        se.append(this.getPersistentProps().size());
        this.getPersistentProps().forEach((key, val) -> {
            se.append(key == null ? "" : key.toString());
            se.append(val == null ? "" : val.toString());
        });
        return se.getValue();
    }

    @Override
    public void setState(String s) {
        GamePiece outer = Decorator.getOutermost(this);
        Map oldMap = this.getMap();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        String mapId = st.nextToken();
        Map newMap = null;
        if (!"null".equals(mapId) && (newMap = Map.getMapById(mapId)) == null) {
            Decorator.reportDataError(this, Resources.getString("Error.not_found", "Map"), "mapId=" + mapId);
        }
        Point newPos = new Point(st.nextInt(0), st.nextInt(0));
        this.setPosition(newPos);
        if (newMap != oldMap) {
            if (newMap != null) {
                newMap.addPiece(outer);
            } else {
                oldMap.removePiece(outer);
                this.setMap(null);
            }
        }
        this.setGpId(st.nextToken(""));
        Object uniqueId = this.getPersistentProps().get(UNIQUE_ID);
        this.getPersistentProps().clear();
        if (uniqueId != null) {
            this.getPersistentProps().put(UNIQUE_ID, uniqueId);
        }
        int propCount = st.nextInt(0);
        for (int i = 0; i < propCount; ++i) {
            String key = st.nextToken("");
            String val = st.nextToken("");
            this.getPersistentProps().put(key, val);
        }
    }

    @Override
    public void mergeState(String newState, String oldState) {
        if (!newState.equals(oldState)) {
            this.setState(newState);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
        if (this.getPersistentProps().get(UNIQUE_ID) == null) {
            this.getPersistentProps().put(UNIQUE_ID, id);
        }
    }

    public static Highlighter getHighlighter() {
        if (highlighter == null) {
            highlighter = new ColoredBorder();
        }
        return highlighter;
    }

    public static void setHighlighter(Highlighter h) {
        highlighter = h;
    }

    @Override
    public String getDescription() {
        Object s = this.getBaseDescription();
        if (this.commonName != null && !this.commonName.isEmpty()) {
            s = (String)s + " - " + this.commonName;
        }
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.BasicPiece.trait_description");
    }

    public String getGpId() {
        String id = (String)this.getProperty("PieceId");
        return id == null ? "" : id;
    }

    public void setGpId(String id) {
        this.setProperty("PieceId", id == null ? "" : id);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("BasicPiece.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public boolean testEquals(Object o) {
        String mapName2;
        if (!(o instanceof BasicPiece)) {
            return false;
        }
        BasicPiece bp = (BasicPiece)o;
        if (!Objects.equals(Character.valueOf(this.cloneKey), Character.valueOf(bp.cloneKey))) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.deleteKey), Character.valueOf(bp.deleteKey))) {
            return false;
        }
        if (!Objects.equals(this.imageName, bp.imageName)) {
            return false;
        }
        if (!Objects.equals(this.commonName, bp.commonName)) {
            return false;
        }
        String mapName1 = this.map == null ? "null" : this.map.getIdentifier();
        String string = mapName2 = bp.map == null ? "null" : bp.map.getIdentifier();
        if (!Objects.equals(mapName1, mapName2)) {
            return false;
        }
        if (!Objects.equals(this.getPosition(), bp.getPosition())) {
            return false;
        }
        if (!Objects.equals(this.getGpId(), bp.getGpId())) {
            return false;
        }
        int pp1 = this.getPersistentProps().size();
        int pp2 = bp.getPersistentProps().size();
        if (!Objects.equals(pp1, pp2)) {
            return false;
        }
        for (Object key : this.getPersistentProps().keySet()) {
            if (Objects.equals(this.getPersistentProps().get(key), bp.getPersistentProps().get(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[name=" + this.getName() + ",type=" + this.getType() + ",state=" + this.getState() + "]";
    }

    @Override
    public PieceI18nData getI18nData() {
        PieceI18nData data = new PieceI18nData(this);
        data.add(this.commonName, Resources.getString("Editor.BasicPiece.basic_piece_name_description"));
        return data;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(BASIC_NAME);
        l.add(CLICKED_X);
        l.add(CLICKED_Y);
        l.add(CURRENT_BOARD);
        l.add(CURRENT_MAP);
        l.add(CURRENT_X);
        l.add(CURRENT_Y);
        l.add(CURRENT_ZONE);
        l.add(DECK_NAME);
        l.add(DECK_POSITION);
        l.add("DrawingMouseover");
        l.add("DrawingMouseoverIndex");
        l.add(LOCATION_NAME);
        l.add(OLD_BOARD);
        l.add(OLD_DECK_NAME);
        l.add(OLD_LOCATION_NAME);
        l.add(OLD_MAP);
        l.add(OLD_X);
        l.add(OLD_Y);
        l.add(OLD_ZONE);
        l.add("PieceId");
        l.add(PIECE_NAME);
        l.add(PIECE_UID);
        l.add("Selected");
        l.add(STACK_POS);
        l.add(STACK_SIZE);
        l.add(UNIQUE_ID);
        return l;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.imageName != null) {
            s.add(this.imageName);
        }
    }

    static {
        POPUP_MENU_FONT = new Font("Dialog", 0, 11);
    }

    private static class Ed
    implements PieceEditor {
        private TraitConfigPanel panel;
        private KeySpecifier cloneKeyInput;
        private KeySpecifier deleteKeyInput;
        private StringConfigurer pieceName;
        private ImageSelector picker;
        private final String state;

        private Ed(BasicPiece p) {
            this.state = p.getState();
            this.initComponents(p);
        }

        private void initComponents(BasicPiece p) {
            this.panel = new TraitConfigPanel();
            this.pieceName = new StringConfigurer(p.commonName);
            this.panel.add("Editor.name_label", (Configurer)this.pieceName);
            this.cloneKeyInput = new KeySpecifier(p.cloneKey);
            if (p.cloneKey != '\u0000') {
                this.panel.add(new JLabel(Resources.getString("Editor.BasicPiece.to_clone")));
                this.panel.add(this.cloneKeyInput);
            }
            this.deleteKeyInput = new KeySpecifier(p.deleteKey);
            if (p.deleteKey != '\u0000') {
                this.panel.add(new JLabel(Resources.getString("Editor.BasicPiece.to_delete")));
                this.panel.add(this.deleteKeyInput);
            }
            this.picker = new ImageSelector(p.imageName);
            this.panel.add("Editor.image_label", (Configurer)this.picker);
        }

        public void reset(BasicPiece p) {
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(this.cloneKeyInput.getKey(), ';');
            String type = se.append(this.deleteKeyInput.getKey()).append(this.picker.getValueString()).append(this.pieceName.getValueString()).getValue();
            return BasicPiece.ID + type;
        }
    }
}

