/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class BorderOutline
extends Decorator
implements TranslatablePiece {
    public static final String ID = "border;";
    private String propertyName;
    private String compareMode;
    private String propertyName2;
    private String description;
    private int thickness = 2;
    private Color color = Color.RED;
    private final ColoredBorder border = new ColoredBorder();

    public BorderOutline() {
        this("border;;", null);
    }

    public BorderOutline(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.propertyName = st.nextToken("");
        this.description = st.nextToken("");
        this.thickness = st.nextInt(2);
        this.color = st.nextColor(Color.RED);
        this.propertyName2 = st.nextToken("");
        this.compareMode = st.nextToken(LogicalCompareMode.AND.toString());
        this.border.setColor(this.color);
        this.border.setThickness(this.thickness);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.propertyName).append(this.description).append(this.thickness).append(this.color).append(this.propertyName2).append(this.compareMode);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        r.add(this.border.boundingBox(this));
        return r;
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    protected boolean checkProperty(String name) {
        if (name != null && !name.isEmpty()) {
            Object propValue = Decorator.getOutermost(this).getProperty(name);
            if (propValue == null) {
                return false;
            }
            if (propValue instanceof String) {
                String string = (String)propValue;
                return !"".equals(string) && !"false".equals(string) && !"0".equals(string);
            }
            if (propValue instanceof Boolean) {
                return (Boolean)propValue;
            }
            if (propValue instanceof Integer) {
                return (Integer)propValue != 0;
            }
        }
        return true;
    }

    protected boolean checkProperties() {
        boolean p1 = this.checkProperty(this.propertyName);
        if (this.propertyName.isEmpty()) {
            return true;
        }
        if (this.propertyName2.isEmpty()) {
            return p1;
        }
        boolean p2 = this.checkProperty(this.propertyName2);
        LogicalCompareMode mode = LogicalCompareMode.whichSymbol(this.compareMode);
        switch (mode.ordinal()) {
            case 1: {
                return p1 || p2;
            }
            case 2: {
                return !(!p1 && !p2 || p1 && p2);
            }
            case 3: {
                return !p1 && !p2;
            }
        }
        return p1 && p2;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
        if (this.checkProperties()) {
            this.border.draw(this, g, x, y, obs, zoom);
        }
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.BorderOutline.trait_description", this.propertyName + (String)(this.propertyName2 != null && !this.propertyName2.isEmpty() ? " " + this.compareMode + " " + this.propertyName2 : ""), this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.BorderOutline.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("BorderOutline.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof BorderOutline)) {
            return false;
        }
        BorderOutline c = (BorderOutline)o;
        if (!Objects.equals(this.color, c.color)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, c.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.propertyName2, c.propertyName2)) {
            return false;
        }
        if (!Objects.equals(this.compareMode, c.compareMode)) {
            return false;
        }
        return Objects.equals(this.thickness, c.thickness);
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals("visibleState")) {
            return String.valueOf(super.getProperty(key)) + this.checkProperties();
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals("visibleState")) {
            return this.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.propertyName, this.propertyName2);
    }

    public static enum LogicalCompareMode {
        AND("AND"),
        OR("OR"),
        XOR("XOR"),
        NOR("NOR");

        private static final String[] KEYS;
        private final String symbol;

        private LogicalCompareMode(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static LogicalCompareMode whichSymbol(String symbol) {
            for (LogicalCompareMode mode : LogicalCompareMode.values()) {
                if (!mode.getSymbol().equals(symbol)) continue;
                return mode;
            }
            return AND;
        }

        public static String[] getSymbols() {
            return (String[])Arrays.stream(LogicalCompareMode.values()).map(LogicalCompareMode::getSymbol).toArray(String[]::new);
        }

        public static String[] getKeys() {
            return KEYS;
        }

        static {
            KEYS = new String[]{"Editor.AND", "Editor.OR", "Editor.XOR", "Editor.NOR"};
        }
    }

    private static class Ed
    implements PieceEditor {
        private final StringConfigurer propertyInput;
        private final LogicalCompareConfigurer compareInput;
        private final StringConfigurer propertyInput2;
        private final StringConfigurer descInput;
        private final IntConfigurer thicknessConfig;
        private final ColorConfigurer colorConfig;
        private final TraitConfigPanel box = new TraitConfigPanel();

        private Ed(BorderOutline p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descInput);
            this.propertyInput = new StringConfigurer(p.propertyName);
            this.box.add("Editor.BorderOutline.property_name", (Configurer)this.propertyInput);
            this.compareInput = new LogicalCompareConfigurer();
            this.compareInput.setValue(p.compareMode);
            this.box.add("Editor.BorderOutline.compare_mode", (Configurer)this.compareInput);
            this.propertyInput2 = new StringConfigurer(p.propertyName2);
            this.box.add("Editor.BorderOutline.property_name_2", (Configurer)this.propertyInput2);
            this.colorConfig = new ColorConfigurer(p.color);
            this.box.add("Editor.BorderOutline.color", (Configurer)this.colorConfig);
            this.thicknessConfig = new IntConfigurer(p.thickness);
            this.box.add("Editor.BorderOutline.thickness", (Configurer)this.thicknessConfig);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.propertyInput.getValueString()).append(this.descInput.getValueString()).append(this.thicknessConfig.getValueString()).append(this.colorConfig.getValueString()).append(this.propertyInput2.getValueString()).append(this.compareInput.getValueString());
            return BorderOutline.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "false";
        }
    }

    private static class LogicalCompareConfigurer
    extends TranslatingStringEnumConfigurer {
        LogicalCompareConfigurer() {
            super(null, null, LogicalCompareMode.getSymbols(), LogicalCompareMode.getKeys());
        }
    }
}

