/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ResourcePathFinder;
import java.io.IOException;
import java.util.SortedSet;

public class I18nResourcePathFinder
implements ResourcePathFinder {
    private SortedSet<String> images = null;
    private final DataArchive archive;
    private String language = "en";

    public I18nResourcePathFinder(DataArchive d, String l) {
        this.archive = d;
        this.language = l;
    }

    public void changeLanguage(String l) {
        this.language = l;
    }

    @Override
    public String findImagePath(String name) {
        Object path;
        if (this.images == null) {
            this.images = this.archive.getImageNameSet(true, true);
        }
        if (this.images != null) {
            path = "images/";
            path = ((String)path).substring(0, ((String)path).length() - 1);
            if (this.images.contains(path = (String)path + "_" + this.language + "/" + name)) {
                return path;
            }
        }
        path = "images/" + name;
        return path;
    }

    @Override
    public String findHelpFileName(String name) {
        Object modifiedName = name;
        if (!this.language.equals("en")) {
            modifiedName = name.contains("help/") ? name.replace("help/", "help_" + this.language + "/") : "help_" + this.language + "/" + name;
            try {
                GameModule.getGameModule().getDataArchive().getURL((String)modifiedName);
            }
            catch (IOException e) {
                modifiedName = name;
            }
        }
        return modifiedName;
    }
}

