/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Language;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.Translation;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import org.apache.commons.lang3.SystemUtils;

public class TranslateWindow
extends JDialog
implements ListSelectionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static final Color TRANSLATION_NEEDED_COLOR = Color.black;
    protected static final Color TRANSLATION_DONE_COLOR = Color.black;
    protected static final Color NO_TRANSLATION_NEEDED_COLOR = Color.black;
    protected Translatable target;
    protected String[] keys;
    protected JTable keyTable;
    protected Translatable keyTarget;
    protected JTree tree;
    protected Translation currentTranslation = null;
    protected JComboBox<String> langBox;
    protected ActionListener boxListener;
    protected int lastSelectedLangIndex;
    protected String currentKey = "";
    protected ConfigureTree myConfigureTree;
    protected CopyButton[] copyButtons;
    protected JButton okButton;
    protected JButton cancelButton;
    static final int ATTR_COL = 0;
    static final int SOURCE_COL = 1;
    static final int CC_COL = 2;
    static final int TRAN_COL = 3;

    public TranslateWindow(Frame owner, boolean modal, Translatable target, ConfigureTree tree) {
        super(owner, modal);
        this.target = target;
        this.myConfigureTree = tree;
        this.initComponents();
    }

    protected void initComponents() {
        if (SystemUtils.IS_OS_MAC) {
            UIManager.put("Table.selectionBackground", new Color(184, 207, 229));
            UIManager.put("Tree.selectionBackground", new Color(184, 207, 229));
        }
        this.setTitle(Resources.getString("Editor.TranslateWindow.translate", ConfigureTree.getConfigureName((Configurable)this.target)));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.getHeaderPanel(), "First");
        mainPanel.add(this.buildMainPanel(), "Center");
        mainPanel.add(this.getButtonPanel(), "Last");
        this.add(mainPanel);
        this.pack();
        SwingUtils.setDefaultButtons(this.getRootPane(), this.okButton, this.cancelButton);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                TranslateWindow.this.cancel();
            }
        });
    }

    protected Component getHeaderPanel() {
        JPanel langPanel = new JPanel();
        langPanel.add(new JLabel(Resources.getString("Editor.TranslateWindow.language")));
        this.langBox = new JComboBox<String>(Localization.getInstance().getTranslationList());
        langPanel.add(this.langBox);
        this.boxListener = e -> {
            this.commitTableEdit();
            String selectedTranslation = (String)((JComboBox)e.getSource()).getSelectedItem();
            this.changeLanguage(selectedTranslation);
        };
        this.langBox.addActionListener(this.boxListener);
        if (Localization.getInstance().getTranslationList().length > 0) {
            this.langBox.setSelectedIndex(0);
        }
        langPanel.setMinimumSize(new Dimension(800, 0));
        JButton addButton = new JButton(Resources.getString("Editor.TranslateWindow.add_translation"));
        addButton.addActionListener(e -> this.getNewTranslation());
        langPanel.add(addButton);
        return langPanel;
    }

    protected void getNewTranslation() {
        Translation t = new Translation();
        MyPropertiesWindow w = new MyPropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), false, t, null, this);
        w.setVisible(true);
    }

    protected void refreshTranslationList(Configurable target) {
        String[] langs;
        Translation newTranslation = (Translation)target;
        List<Language> list = GameModule.getGameModule().getComponentsOf(Language.class);
        if (list != null) {
            if (list.get(0).contains(newTranslation)) {
                WarningDialog.show("Editor.TranslateWindow.translation_exists", newTranslation.getDescription());
                return;
            }
            Language language = list.iterator().next();
            this.myConfigureTree.externalInsert(language, target);
        }
        this.langBox.removeAllItems();
        for (String lang : langs = Localization.getInstance().getTranslationList()) {
            this.langBox.addItem(lang);
        }
        this.langBox.setSelectedItem(newTranslation.getDescription());
        this.keyTable.setEnabled(true);
        this.tree.repaint();
    }

    protected Component buildMainPanel() {
        JPanel keyPanel = this.buildKeyTablePanel();
        JPanel treePanel = new JPanel(new BorderLayout());
        MyTreeNode top = new MyTreeNode(this.target);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setSelectionRow(0);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane treeScroll = new JScrollPane(this.tree, 20, 30);
        treePanel.add((Component)treeScroll, "Center");
        treePanel.setMinimumSize(new Dimension(400, 100));
        treePanel.setPreferredSize(new Dimension(800, 300));
        JSplitPane split1 = new JSplitPane(0, treePanel, keyPanel);
        split1.setResizeWeight(0.5);
        return split1;
    }

    protected JPanel buildKeyTablePanel() {
        JPanel keyPanel = new JPanel(new BorderLayout());
        keyPanel.setMinimumSize(new Dimension(800, 100));
        this.keyTable = new MyTable();
        this.keyTable.setSelectionMode(0);
        this.keyTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TranslateWindow.this.commitTableEdit();
            }
        });
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.setEnabled(this.currentTranslation != null);
        JScrollPane keyScroll = new JScrollPane(this.keyTable, 20, 30);
        keyPanel.add((Component)keyScroll, "Center");
        keyPanel.setMinimumSize(new Dimension(400, 100));
        keyPanel.setPreferredSize(new Dimension(800, 200));
        return keyPanel;
    }

    protected Component getButtonPanel() {
        JPanel buttonBox = new JPanel();
        JButton helpButton = new JButton(Resources.getString("General.help"));
        helpButton.addActionListener(new ShowHelpAction(HelpFile.getReferenceManualPage("Translations.html", "module").getContents(), null));
        buttonBox.add(helpButton);
        this.okButton = new JButton(Resources.getString("General.ok"));
        this.okButton.addActionListener(e -> {
            try {
                this.save();
            }
            catch (IOException e1) {
                WriteErrorDialog.error(e1, GameModule.getGameModule().getArchiveWriter().getName());
            }
        });
        buttonBox.add(this.okButton);
        this.cancelButton = new JButton(Resources.getString("General.cancel"));
        this.cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add(this.cancelButton);
        return buttonBox;
    }

    protected void commitTableEdit() {
        if (this.keyTable != null && this.keyTable.isEditing()) {
            int row = this.keyTable.getEditingRow();
            int column = this.keyTable.getEditingColumn();
            if (row != -1 && column != -1) {
                this.keyTable.editCellAt(row, column);
            }
        }
    }

    protected void changeLanguage(String selectedTranslation) {
        if (this.currentTranslation != null && this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    this.langBox.removeActionListener(this.boxListener);
                    this.langBox.setSelectedItem(this.lastSelectedLangIndex);
                    this.langBox.addActionListener(this.boxListener);
                }
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, GameModule.getGameModule().getArchiveWriter().getName());
            }
        }
        this.currentTranslation = Localization.getInstance().getTranslation(selectedTranslation);
        this.lastSelectedLangIndex = this.langBox.getSelectedIndex();
        if (this.keyTable != null) {
            ((MyTableModel)this.keyTable.getModel()).update();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.commitTableEdit();
        MyTreeNode node = (MyTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.keys = node.getTarget().getI18nData().getAttributeKeys().toArray(new String[0]);
        this.copyButtons = new CopyButton[this.keys.length];
        this.keyTarget = node.getTarget();
        ((AbstractTableModel)this.keyTable.getModel()).fireTableStructureChanged();
        if (this.keys != null && this.keys.length > 0) {
            this.keyTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        ((MyTableModel)this.keyTable.getModel()).update();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            String key = this.keys[lsm.getMinSelectionIndex()];
            this.currentKey = this.keyTarget.getI18nData().getFullPrefix() + key;
        }
    }

    protected void createNodes(MyTreeNode top) {
        for (Translatable child : top.getTarget().getI18nData().getChildren()) {
            MyTreeNode childNode = new MyTreeNode(child);
            this.createNodes(childNode);
            top.add(childNode);
        }
    }

    public static String getDisplayName(Translatable t) {
        if (t == null) {
            return "";
        }
        String type = ConfigureTree.getConfigureName(t.getClass());
        String name = "";
        if (t instanceof Configurable) {
            name = ((Configurable)t).getConfigureName();
        }
        Object s = name == null ? "" : name + " ";
        return (String)s + " [" + type + "]";
    }

    protected void cancel() {
        this.commitTableEdit();
        if (this.currentTranslation != null && this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    return;
                }
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, GameModule.getGameModule().getArchiveWriter().getName());
            }
        }
        this.dispose();
    }

    protected boolean querySave() throws IOException {
        switch (JOptionPane.showConfirmDialog(this, Resources.getString("Editor.TranslateWindow.save_now"), Resources.getString("Editor.TranslateWindow.unsaved"), 1)) {
            case 0: {
                this.saveTranslation();
                return true;
            }
            case 1: {
                this.reloadTranslation();
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    protected void save() throws IOException {
        this.commitTableEdit();
        if (this.saveTranslation()) {
            this.dispose();
        }
    }

    protected boolean saveTranslation() throws IOException {
        if (this.currentTranslation != null) {
            this.currentTranslation.saveProperties();
        }
        return true;
    }

    protected void reloadTranslation() throws IOException {
        if (this.currentTranslation != null) {
            this.currentTranslation.reloadProperties();
        }
    }

    protected static class MyPropertiesWindow
    extends PropertiesWindow {
        private static final long serialVersionUID = 1L;
        protected Configurable myTarget;
        protected TranslateWindow owningWindow;

        public MyPropertiesWindow(Frame owner, boolean modal, Configurable target, HelpWindow helpWindow, TranslateWindow tw) {
            super(owner, modal, target, helpWindow);
            this.myTarget = target;
            this.owningWindow = tw;
        }

        @Override
        public void save() {
            super.save();
            this.owningWindow.refreshTranslationList(this.myTarget);
        }

        @Override
        public void cancel() {
            this.dispose();
        }
    }

    protected static class MyTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        Translatable component;

        public MyTreeNode(Translatable t) {
            this.component = t;
        }

        public Translatable getTarget() {
            return this.component;
        }

        @Override
        public String toString() {
            return TranslateWindow.getDisplayName(this.component);
        }
    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Translatable t = ((MyTreeNode)value).getTarget();
            if (t.getI18nData().hasUntranslatedAttributes(TranslateWindow.this.currentTranslation)) {
                c.setForeground(TRANSLATION_NEEDED_COLOR);
                c.setFont(c.getFont().deriveFont(1));
            } else {
                c.setForeground(NO_TRANSLATION_NEEDED_COLOR);
                c.setFont(c.getFont().deriveFont(0));
            }
            return c;
        }
    }

    class MyTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public MyTable() {
            super(new MyTableModel());
            this.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
            this.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            if (renderer == null) {
                Object o;
                Class<?> c = this.getColumnClass(column);
                if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                    c = this.getValueAt(row, column).getClass();
                }
                renderer = this.getDefaultRenderer(c);
            }
            return renderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellEditor editor = tableColumn.getCellEditor();
            if (editor == null) {
                Object o;
                Class<?> c = this.getColumnClass(column);
                if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                    c = this.getValueAt(row, column).getClass();
                }
                editor = this.getDefaultEditor(c);
            }
            return editor;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Resources.getString("Editor.TranslateWindow.attribute");
                }
                case 1: {
                    return Resources.getString("Editor.TranslateWindow.source_text");
                }
                case 2: {
                    return Resources.getString("Editor.TranslateWindow.cc");
                }
                case 3: {
                    return Resources.getString("Editor.TranslateWindow.translation");
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return TranslateWindow.this.keys == null ? 0 : TranslateWindow.this.keys.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return TranslateWindow.this.keys == null ? null : TranslateWindow.this.keyTarget.getI18nData().getAttributeDescription(TranslateWindow.this.keys[row]);
                }
                case 1: {
                    return TranslateWindow.this.keys == null ? null : TranslateWindow.this.keyTarget.getAttributeValueString(TranslateWindow.this.keys[row]);
                }
                case 2: {
                    if (TranslateWindow.this.copyButtons[row] == null) {
                        TranslateWindow.this.copyButtons[row] = new CopyButton(row);
                    }
                    return TranslateWindow.this.copyButtons[row];
                }
                case 3: {
                    if (TranslateWindow.this.currentTranslation == null) break;
                    String key = TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + TranslateWindow.this.keys[row];
                    return TranslateWindow.this.currentTranslation.translate(key);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 3) {
                TranslateWindow.this.currentTranslation.setProperty(TranslateWindow.this.currentKey, (String)value);
                TranslateWindow.this.copyButtons[row].checkEnabled();
                this.fireTableCellUpdated(row, col);
                TranslateWindow.this.tree.repaint();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3 || col == 2;
        }

        public void update() {
            this.fireTableStructureChanged();
            TranslateWindow.this.keyTable.getColumnModel().getColumn(0).setCellRenderer(new MyTableCellRenderer(TranslateWindow.this.keyTarget));
            TranslateWindow.this.keyTable.getColumnModel().getColumn(2).setMaxWidth(25);
        }
    }

    class CopyButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        int row;

        public CopyButton(int i) {
            super("->");
            this.row = i;
            this.addActionListener(this);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.checkEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = TranslateWindow.this.keys[this.row];
            TranslateWindow.this.currentKey = TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + key;
            TranslateWindow.this.currentTranslation.setProperty(TranslateWindow.this.currentKey, TranslateWindow.this.keyTarget.getAttributeValueString(TranslateWindow.this.keys[this.row]));
            this.checkEnabled();
            ((MyTableModel)TranslateWindow.this.keyTable.getModel()).update();
        }

        public void checkEnabled() {
            if (TranslateWindow.this.keyTarget != null && TranslateWindow.this.keys != null && TranslateWindow.this.keys[this.row] != null) {
                String t = TranslateWindow.this.currentTranslation == null ? "" : TranslateWindow.this.currentTranslation.translate(TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + TranslateWindow.this.keys[this.row]);
                this.setEnabled(t == null || t.length() == 0);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Translatable target;

        public MyTableCellRenderer(Translatable target) {
            this.target = target;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            String fullKey = this.target.getI18nData().getFullPrefix() + TranslateWindow.this.keys[row];
            String translation = TranslateWindow.this.currentTranslation == null ? "" : TranslateWindow.this.currentTranslation.translate(fullKey);
            String originalValue = this.target.getAttributeValueString(TranslateWindow.this.keys[row]);
            if (originalValue == null || originalValue.length() == 0) {
                c.setForeground(NO_TRANSLATION_NEEDED_COLOR);
                c.setFont(c.getFont().deriveFont(0));
            } else if (translation == null || translation.length() == 0) {
                c.setForeground(TRANSLATION_NEEDED_COLOR);
                c.setFont(c.getFont().deriveFont(1));
            } else {
                c.setForeground(TRANSLATION_DONE_COLOR);
                c.setFont(c.getFont().deriveFont(0));
            }
            return c;
        }
    }

    protected static class JComponentCellEditor
    implements TableCellEditor,
    TreeCellEditor,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;
        protected JComponent container = null;

        protected JComponentCellEditor() {
        }

        public Component getComponent() {
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (this.editorComponent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getID() == 501) {
                Component dispatchComponent = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                ((CopyButton)dispatchComponent).setSelected(true);
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorComponent = (JComponent)value;
            this.container = tree;
            return this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorComponent = (JComponent)value;
            this.container = table;
            return this.editorComponent;
        }
    }

    protected static class JComponentCellRenderer
    implements TableCellRenderer {
        protected JComponentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }
}

