/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.BrokenImageException;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageTypeConverter;
import VASSAL.tools.image.JPEGDecoder;
import VASSAL.tools.image.PNGDecoder;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.io.RereadableInputStream;
import VASSAL.tools.lang.Reference;
import java.awt.Dimension;
import java.awt.color.CMMException;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferInt;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageIOImageLoader
implements ImageLoader {
    protected final ImageTypeConverter tconv;
    protected static final boolean YCbCrBug;
    protected static final Wrapper<BufferedImage> readImage;
    protected static final Wrapper<Dimension> readSize;

    public ImageIOImageLoader(ImageTypeConverter tconv) {
        this.tconv = tconv;
    }

    @Override
    public BufferedImage load(String name, InputStream in, int typeIfOpaque, int typeIfTransparent, boolean managed) throws ImageIOException {
        boolean fix_tRNS = false;
        int tRNS = 0;
        boolean fix_YCbCr = false;
        boolean fix_grayscale_gamma = false;
        BufferedImage img = null;
        try (RereadableInputStream rin = new RereadableInputStream(in);){
            block42: {
                rin.mark(512);
                DataInputStream din = new DataInputStream(rin);
                if (PNGDecoder.decodeSignature(din)) {
                    PNGDecoder.Chunk ch = PNGDecoder.decodeChunk(din);
                    if (ch.type == 1229472850) {
                        if (ch.data[8] == 8 && ch.data[9] == 2) {
                            block23: while (true) {
                                ch = PNGDecoder.decodeChunk(din);
                                switch (ch.type) {
                                    case 1951551059: {
                                        fix_tRNS = true;
                                        break block23;
                                    }
                                    case 1229209940: {
                                        fix_tRNS = false;
                                        break block23;
                                    }
                                    default: {
                                        continue block23;
                                    }
                                }
                                break;
                            }
                            if (fix_tRNS) {
                                if (ch.data.length != 6) {
                                    throw new BrokenImageException(name, "bad tRNS chunk length");
                                }
                                tRNS = 0xFF000000 | (ch.data[1] & 0xFF) << 16 | (ch.data[3] & 0xFF) << 8 | ch.data[5] & 0xFF;
                            }
                        } else if (ch.data[9] == 4) {
                            while (true) {
                                ch = PNGDecoder.decodeChunk(din);
                                switch (ch.type) {
                                    case 1766015824: {
                                        fix_grayscale_gamma = false;
                                        break block42;
                                    }
                                    case 1229209940: {
                                        fix_grayscale_gamma = true;
                                        break block42;
                                    }
                                }
                            }
                        }
                    }
                } else if (YCbCrBug) {
                    rin.reset();
                    rin.mark(512);
                    din = new DataInputStream(rin);
                    if (JPEGDecoder.decodeSignature(din)) {
                        fix_YCbCr = true;
                        block25: while (true) {
                            JPEGDecoder.Chunk ch = JPEGDecoder.decodeChunk(din);
                            switch (ch.type) {
                                case 65472: 
                                case 65473: 
                                case 65474: 
                                case 65475: 
                                case 65476: 
                                case 65477: 
                                case 65478: 
                                case 65479: 
                                case 65481: 
                                case 65482: 
                                case 65483: 
                                case 65484: 
                                case 65485: 
                                case 65486: 
                                case 65487: {
                                    fix_YCbCr = ch.data.length == 15 && ch.data[5] == 3 && ch.data[7] == ch.data[10] && ch.data[7] == ch.data[13];
                                    break block25;
                                }
                                case 65504: {
                                    if (ch.data.length < 4 || ch.data[0] != 74 || ch.data[1] != 70 || ch.data[2] != 73 || ch.data[3] != 70) continue block25;
                                    fix_YCbCr = false;
                                    break block25;
                                }
                                case 65506: {
                                    if (ch.data.length < 12 || ch.data[0] != 73 || ch.data[1] != 67 || ch.data[2] != 67 || ch.data[3] != 95 || ch.data[4] != 80 || ch.data[5] != 82 || ch.data[6] != 79 || ch.data[7] != 70 || ch.data[8] != 73 || ch.data[9] != 76 || ch.data[10] != 69 || ch.data[11] != 0) continue block25;
                                    fix_YCbCr = false;
                                    break block25;
                                }
                                case 65517: 
                                case 65518: {
                                    fix_YCbCr = false;
                                    break block25;
                                }
                                case 65497: 
                                case 65498: {
                                    break block25;
                                }
                                default: {
                                    continue block25;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            rin.reset();
            img = this.wrapImageIO(name, rin, readImage);
        }
        catch (ImageIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
        int type = img.getTransparency() == 1 && !fix_tRNS ? typeIfOpaque : typeIfTransparent;
        Reference<BufferedImage> ref = new Reference<BufferedImage>(img);
        if (fix_tRNS) {
            img = null;
            img = this.fix_tRNS(ref, tRNS, type);
            ref.obj = img;
        } else if (fix_YCbCr) {
            img = null;
            img = this.fix_YCbCr(ref, type);
            ref.obj = img;
        } else if (fix_grayscale_gamma) {
            img = null;
            img = this.fix_grayscale_gamma(ref, type);
            ref.obj = img;
        }
        if (img.getType() != type || (fix_tRNS || fix_YCbCr) && managed) {
            img = null;
            img = this.tconv.convert(ref, type);
        }
        return img;
    }

    protected <T> T wrapImageIO(String name, InputStream in, Wrapper<T> w) throws ImageIOException {
        try {
            return w.run(name, in);
        }
        catch (CMMException | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new BrokenImageException(name, (Throwable)e);
        }
        catch (ImageIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
    }

    protected BufferedImage fix_tRNS(Reference<BufferedImage> ref, int tRNS, int type) throws ImageIOException {
        BufferedImage img = (BufferedImage)ref.obj;
        if (img.getType() != 2 && img.getType() != 3) {
            if (type != 2 && type != 3) {
                type = 2;
            }
            img = null;
            img = this.tconv.convert(ref, type);
        }
        DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
        int[] data = db.getData();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != tRNS) continue;
            data[i] = 0;
        }
        return img;
    }

    protected BufferedImage fix_YCbCr(Reference<BufferedImage> ref, int type) throws ImageIOException {
        BufferedImage img = (BufferedImage)ref.obj;
        if (img.getType() != 1 && img.getType() != 2) {
            if (type != 1 && type != 2) {
                type = 2;
            }
            img = null;
            img = this.tconv.convert(ref, type);
        }
        DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
        int[] data = db.getData();
        for (int i = 0; i < data.length; ++i) {
            int y = data[i] >> 16 & 0xFF;
            int pb = (data[i] >> 8 & 0xFF) - 128;
            int pr = (data[i] & 0xFF) - 128;
            int a = data[i] >> 24 & 0xFF;
            int r = (int)Math.round((double)y + 1.402 * (double)pr);
            int g = (int)Math.round((double)y - 0.34414 * (double)pb - 0.71414 * (double)pr);
            int b = (int)Math.round((double)y + 1.772 * (double)pb);
            data[i] = a << 24 | (r < 0 ? 0 : (r > 255 ? 255 : r)) << 16 | (g < 0 ? 0 : (g > 255 ? 255 : g)) << 8 | (b < 0 ? 0 : (b > 255 ? 255 : b));
        }
        return img;
    }

    private static ICC_Profile load_grayscale_icc() throws ImageIOException {
        ICC_Profile iCC_Profile;
        block8: {
            String icc = "/grayscale.icc";
            InputStream in = ImageIOImageLoader.class.getResourceAsStream("/grayscale.icc");
            try {
                iCC_Profile = ICC_Profile.getInstance(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ImageIOException("/grayscale.icc", (Throwable)e);
                }
            }
            in.close();
        }
        return iCC_Profile;
    }

    protected BufferedImage fix_grayscale_gamma(Reference<BufferedImage> ref, int type) throws ImageIOException {
        BufferedImage img = (BufferedImage)ref.obj;
        ColorModel cm = img.getColorModel();
        return new BufferedImage(new ComponentColorModel(new ICC_ColorSpace(ImageIOImageLoader.load_grayscale_icc()), cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), cm.getTransferType()), img.getRaster(), img.isAlphaPremultiplied(), null);
    }

    @Override
    public Dimension size(String name, InputStream in) throws ImageIOException {
        return this.wrapImageIO(name, in, readSize);
    }

    static {
        BufferedImage img;
        try (InputStream in = ImageIOImageLoader.class.getResourceAsStream("/images/black.jpg");){
            img = ImageIO.read(new MemoryCacheImageInputStream(in));
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        if (img == null) {
            throw new IllegalStateException();
        }
        int pixel = img.getRGB(0, 0);
        switch (pixel) {
            case -16777216: {
                YCbCrBug = false;
                break;
            }
            case -16744320: 
            case -16742656: {
                YCbCrBug = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected pixel value 0x" + String.format("%08x", pixel));
            }
        }
        ICC_Profile.getInstance(1000).getPCSType();
        readImage = new Wrapper<BufferedImage>(){

            @Override
            public BufferedImage run(String name, InputStream in) throws IOException {
                BufferedImage img = ImageIO.read(new MemoryCacheImageInputStream(in));
                if (img == null) {
                    throw new UnrecognizedImageTypeException(name);
                }
                return img;
            }
        };
        readSize = new Wrapper<Dimension>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension run(String name, InputStream in) throws IOException {
                MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(in);
                Iterator<ImageReader> i = ImageIO.getImageReaders(stream);
                if (!i.hasNext()) {
                    throw new UnrecognizedImageTypeException(name);
                }
                ImageReader reader = i.next();
                try {
                    reader.setInput(stream);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    return dimension;
                }
                finally {
                    reader.dispose();
                }
            }
        };
    }

    @FunctionalInterface
    protected static interface Wrapper<T> {
        public T run(String var1, InputStream var2) throws IOException;
    }
}

