/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.i18n.Resources;
import VASSAL.tools.QuickColors;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class LabelUtils {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;

    private LabelUtils() {
    }

    public static void drawLabel(Graphics g, String text, int x, int y, int hAlign, int vAlign, Color fgColor, Color bgColor) {
        LabelUtils.drawLabel(g, text, x, y, new Font("Dialog", 0, 10), hAlign, vAlign, fgColor, bgColor, null);
    }

    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor) {
        LabelUtils.drawLabel(g, text, x, y, f, hAlign, vAlign, fgColor, bgColor, borderColor, 0, 0, 0, 0);
    }

    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor, int objectWidth, int textPad, int minWidth, int extraBorder) {
        int xBox;
        ((Graphics2D)g).addRenderingHints(SwingUtils.FONT_HINTS);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(f);
        int width = g.getFontMetrics().stringWidth(text + "  ") + textPad * 2 + extraBorder;
        int height = g.getFontMetrics().getHeight() + textPad * 2 + extraBorder * 2;
        int width2 = Math.max(width, minWidth + extraBorder);
        int x0 = x -= extraBorder;
        int y0 = y -= extraBorder;
        if (objectWidth <= 0) {
            switch (hAlign) {
                case 0: {
                    x0 = x - width / 2;
                    break;
                }
                case 2: {
                    x0 = x - width;
                    break;
                }
                case 1: {
                    x0 = x;
                }
            }
            xBox = x0;
        } else {
            switch (hAlign) {
                case 0: {
                    x0 = x + objectWidth / 2 - width / 2;
                    break;
                }
                case 2: {
                    x0 = x + objectWidth;
                    break;
                }
                case 1: {
                    x0 = x;
                }
            }
            xBox = minWidth > 0 && width2 > width ? x : x0;
        }
        switch (vAlign) {
            case 0: {
                y0 = y - height / 2;
                break;
            }
            case 4: {
                y0 = y - height;
            }
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(xBox, y0, width2, height);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(xBox, y0, width2, height);
            if (extraBorder > 0) {
                Dimension size4 = new Dimension(width2, height);
                int x1 = xBox;
                int y1 = y0;
                for (int extra = 0; extra < extraBorder; ++extra) {
                    size4.width -= 2;
                    size4.height -= 2;
                    g.drawRect(++x1, ++y1, size4.width, size4.height);
                }
            }
        }
        g.setColor(fgColor);
        g.drawString(" " + text + " ", x0 + textPad + extraBorder, y0 + textPad + extraBorder + g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent());
    }

    public static void drawHTMLLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor, Component comp, int objectWidth, int textPad, int minWidth, int extraBorder) {
        LabelUtils.drawHTMLLabel(g, text, x, y, f, hAlign, vAlign, fgColor, bgColor, borderColor, comp, objectWidth, textPad, minWidth, extraBorder, extraBorder, extraBorder, true);
    }

    public static void drawHTMLLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor, Component comp, int objectWidth, int textPad, int minWidth, int extraBorder, int extraTop, int extraBottom, boolean allowHTML) {
        int xBox;
        boolean addTags;
        ((Graphics2D)g).addRenderingHints(SwingUtils.FONT_HINTS);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String style = QuickColors.getQuickColor(text) >= 0 ? QuickColors.getQuickColorHTMLStyle(text) + "color" : "";
        String baseString = QuickColors.stripQuickColorTag(text);
        boolean bl = addTags = text.length() <= 6 || !"<html>".equalsIgnoreCase(text.substring(0, 6));
        String htmlString = (String)(addTags ? "<html>" + (String)(!style.isEmpty() ? "<div class=\"" + style + "\">" : "<div>") + "&nbsp;" : "") + baseString + (addTags ? "&nbsp;</div></html>" : "");
        JLabel j = new JLabel(allowHTML ? htmlString : " " + baseString + " ");
        j.setForeground(fgColor);
        j.setFont(f);
        Dimension size = j.getPreferredSize();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        j.setSize(size);
        if (extraBorder < 0 || extraTop < 0 || extraBottom < 0) {
            extraBottom = 0;
            extraTop = 0;
            extraBorder = 0;
            borderColor = null;
        }
        Dimension size2 = new Dimension();
        size2.width = size.width + textPad * 2 + extraBorder * 2;
        size2.height = size.height + textPad * 2 + extraTop + extraBottom;
        Dimension size3 = new Dimension();
        size3.width = Math.max(size2.width, minWidth);
        size3.height = size2.height;
        g.setFont(f);
        int x0 = x;
        int y0 = y;
        if (objectWidth <= 0) {
            switch (hAlign) {
                case 0: {
                    x0 -= size2.width / 2;
                    break;
                }
                case 2: {
                    x0 -= size2.width;
                    break;
                }
            }
            xBox = x0 - extraBorder;
        } else {
            switch (hAlign) {
                case 0: {
                    x0 = x0 + objectWidth / 2 - size2.width / 2;
                    break;
                }
                case 2: {
                    x0 = x0 + objectWidth - size2.width;
                    break;
                }
            }
            xBox = minWidth > 0 && size3.width > size2.width ? x - extraBorder : x0;
        }
        switch (vAlign) {
            case 0: {
                y0 -= size2.height / 2;
                break;
            }
            case 4: {
                y0 -= size2.height;
            }
        }
        int yBox = y0 - extraTop;
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(xBox, yBox, size3.width, size3.height);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(xBox, yBox, size3.width - 1, size3.height);
            if (extraBorder > 0 || extraTop > 0 || extraBottom > 0) {
                int extra;
                int x1 = xBox;
                int y1 = yBox;
                if (extraBorder > 0) {
                    int width = size3.width;
                    for (int extra2 = 0; extra2 < extraBorder; ++extra2) {
                        g.drawRect(++x1, y1, (width -= 2) - 1, size3.height);
                    }
                }
                if (extraTop > 0) {
                    for (extra = 0; extra < extraTop; ++extra) {
                        g.drawRect(xBox, ++y1, size3.width - 1, 0);
                    }
                }
                if (extraBottom > 0) {
                    y1 = yBox + size3.height;
                    for (extra = 0; extra < extraBottom; ++extra) {
                        g.drawRect(xBox, --y1, size3.width - 1, 0);
                    }
                }
            }
        }
        g.setColor(fgColor);
        BufferedImage im = ImageUtils.createCompatibleImage(size.width, size.height, true);
        Graphics2D gTemp = im.createGraphics();
        gTemp.addRenderingHints(SwingUtils.FONT_HINTS);
        gTemp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        j.paint(gTemp);
        BufferedImage im2 = ImageUtils.createCompatibleImage(size3.width, size3.height, true);
        Graphics2D gTemp2 = im2.createGraphics();
        gTemp2.addRenderingHints(SwingUtils.FONT_HINTS);
        gTemp2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gTemp2.drawImage((Image)im, textPad + extraBorder, textPad, null);
        g.drawImage(im2, x0, y0, comp);
    }

    public static int labelWidth(Font font, String s) {
        Graphics2D g = (Graphics2D)ImageUtils.NULL_IMAGE.getGraphics();
        g.addRenderingHints(SwingUtils.FONT_HINTS);
        g.setFont(font);
        int stringWidth = g.getFontMetrics().stringWidth(s);
        g.dispose();
        return stringWidth;
    }

    public static void drawLabelBox(Graphics2D g, Font font, String s, int imageWidth, int stringWidth, int height) {
        g.addRenderingHints(SwingUtils.FONT_HINTS);
        g.setFont(font);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, imageWidth - 1, height - 1);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, imageWidth - 1, height - 1);
        g.drawString(s, (imageWidth - stringWidth) / 2 - 1, height / 2 + 4);
    }

    public static BufferedImage labelBoxImage(Font font, String s, int minWidth, int height) {
        int stringWidth = LabelUtils.labelWidth(font, s);
        int imageWidth = Math.max(minWidth, stringWidth + 20);
        BufferedImage image = ImageUtils.createCompatibleImage(imageWidth, height);
        Graphics2D g = (Graphics2D)image.getGraphics();
        LabelUtils.drawLabelBox(g, font, s, imageWidth, stringWidth, height);
        g.dispose();
        return image;
    }

    public static BufferedImage noImageBoxImage(int w, int h, double scale) {
        return LabelUtils.labelBoxImage(new Font("Dialog", 2, 12).deriveFont((float)(12.0 * scale)), Resources.getString("Editor.ImageUtils.no_image"), w, h);
    }

    public static BufferedImage noImageBoxImage() {
        return LabelUtils.noImageBoxImage(64, 64, 1.0);
    }
}

