/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTiledOpImpl
extends AbstractOpImpl {
    private static final Dimension DEFAULT_TILE_SIZE = new Dimension(256, 256);
    protected Dimension tileSize;
    protected int numXTiles;
    protected int numYTiles;
    protected ImageOp[] tiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixTileSize() {
        AbstractTiledOpImpl abstractTiledOpImpl = this;
        synchronized (abstractTiledOpImpl) {
            if (this.size == null) {
                this.fixSize();
            }
            if (this.tileSize == null) {
                this.numXTiles = (int)Math.ceil((double)this.size.width / (double)AbstractTiledOpImpl.DEFAULT_TILE_SIZE.width);
                this.numYTiles = (int)Math.ceil((double)this.size.height / (double)AbstractTiledOpImpl.DEFAULT_TILE_SIZE.height);
                this.tiles = new ImageOp[this.numXTiles * this.numYTiles];
                this.tileSize = DEFAULT_TILE_SIZE;
            }
        }
    }

    @Override
    public Dimension getTileSize() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return new Dimension(this.tileSize);
    }

    @Override
    public int getTileHeight() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.tileSize.height;
    }

    @Override
    public int getTileWidth() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.tileSize.width;
    }

    @Override
    public int getNumXTiles() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.numXTiles;
    }

    @Override
    public int getNumYTiles() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.numYTiles;
    }

    @Override
    public ImageOp getTileOp(int tileX, int tileY) {
        ImageOp top = this.tiles[tileY * this.numXTiles + tileX];
        if (top == null) {
            ImageOp imageOp = this.createTileOp(tileX, tileY);
            this.tiles[tileY * this.numXTiles + tileX] = imageOp;
            top = imageOp;
        }
        return top;
    }

    protected abstract ImageOp createTileOp(int var1, int var2);

    @Override
    public BufferedImage getTile(int tileX, int tileY, ImageOpObserver obs) throws CancellationException, InterruptedException, ExecutionException {
        if (tileX < 0 || tileX >= this.numXTiles || tileY < 0 || tileY >= this.numYTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.getTileOp(tileX, tileY).getImage(obs);
    }

    @Override
    public Future<BufferedImage> getFutureTile(int tileX, int tileY, ImageOpObserver obs) throws ExecutionException {
        if (tileX < 0 || tileX >= this.numXTiles || tileY < 0 || tileY >= this.numYTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.getTileOp(tileX, tileY).getFutureImage(obs);
    }

    @Override
    public Point[] getTileIndices(Rectangle rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        if (this.size == null || this.tileSize == null) {
            this.fixTileSize();
        }
        if ((rect = rect.intersection(new Rectangle(this.size))).isEmpty()) {
            return new Point[0];
        }
        int minTileX = rect.x / this.tileSize.width;
        int minTileY = rect.y / this.tileSize.height;
        int maxTileX = (rect.x + rect.width - 1) / this.tileSize.width;
        int maxTileY = (rect.y + rect.height - 1) / this.tileSize.height;
        Point[] tilesInRect = new Point[(maxTileX - minTileX + 1) * (maxTileY - minTileY + 1)];
        int offset = 0;
        for (int ty = minTileY; ty <= maxTileY; ++ty) {
            for (int tx = minTileX; tx <= maxTileX; ++tx) {
                tilesInRect[offset++] = new Point(tx, ty);
            }
        }
        return tilesInRect;
    }
}

