/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MovePiece;
import VASSAL.command.NullCommand;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MovementReporter {
    protected FormattedString format = new FormattedString();
    protected List<MoveSummary> movesToReport = new ArrayList<MoveSummary>();
    protected List<MoveSummary> movesToMark = new ArrayList<MoveSummary>();

    public MovementReporter(Command moveCommand) {
        this.extractMoveCommands(moveCommand);
    }

    protected void extractMoveCommands(Command c) {
        Command[] sub;
        MovePiece movePiece;
        MoveSummary summary = null;
        if (c instanceof AddPiece) {
            AddPiece addPiece = (AddPiece)c;
            if (this.shouldReport(addPiece)) {
                summary = this.createMoveSummary(addPiece);
            }
        } else if (c instanceof MovePiece && this.shouldReport(movePiece = (MovePiece)c)) {
            summary = this.createMoveSummary(movePiece);
        }
        if (summary != null) {
            int index = this.movesToReport.indexOf(summary);
            if (index >= 0 && c instanceof MovePiece && this.shouldReport((MovePiece)c)) {
                MoveSummary existing = this.movesToReport.get(index);
                existing.append((MovePiece)c);
            } else {
                this.movesToReport.add(summary);
            }
            if (this.shouldMarkMoved(summary)) {
                this.movesToMark.add(summary);
            }
        }
        for (Command command : sub = c.getSubCommands()) {
            this.extractMoveCommands(command);
        }
    }

    protected MoveSummary createMoveSummary(AddPiece c) {
        return new MoveSummary(c);
    }

    protected MoveSummary createMoveSummary(MovePiece c) {
        return new MoveSummary(c);
    }

    public Command markMovedPieces() {
        NullCommand c = null;
        if (!this.movesToMark.isEmpty()) {
            c = new NullCommand();
            for (MoveSummary ms : this.movesToMark) {
                for (GamePiece p : ms.pieces) {
                    c.append(this.markMoved(p));
                }
            }
        }
        return c;
    }

    public Command markMoved(GamePiece p) {
        Command c = null;
        if (p instanceof Stack) {
            c = new NullCommand();
            for (GamePiece gp : ((Stack)p).asList()) {
                c = c.append(this.markMoved(gp));
            }
        } else if (p.getProperty("Moved") != null && p.getId() != null) {
            ChangeTracker comm = new ChangeTracker(p);
            p.setProperty("Moved", Boolean.TRUE);
            c = comm.getChangeCommand();
        }
        return c;
    }

    protected boolean shouldMarkMoved(MoveSummary summary) {
        String option;
        Map mappy = Map.getMapById(summary.getNewMapId());
        String string = option = mappy == null ? null : mappy.getAttributeValueString("markMoved");
        if (option == null) {
            option = "Always";
        }
        if ("Always".equals(option)) {
            return true;
        }
        if ("Never".equals(option)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("markMoved"));
    }

    protected boolean shouldReport(AddPiece addPiece) {
        GamePiece target = addPiece.getTarget();
        return target != null && !(target instanceof Stack) && !Boolean.TRUE.equals(target.getProperty("Invisible")) && !Boolean.TRUE.equals(target.getProperty("InvisibleToOthers"));
    }

    protected boolean shouldReport(MovePiece movePiece) {
        GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
        if (target == null) {
            return false;
        }
        if (target instanceof Stack) {
            GamePiece top = ((Stack)target).topPiece(null);
            return top != null;
        }
        return !Boolean.TRUE.equals(target.getProperty("Invisible")) && !Boolean.TRUE.equals(target.getProperty("InvisibleToOthers"));
    }

    public Command getReportCommand() {
        PieceAccess.GlobalAccess.hideAll();
        Command c = new NullCommand();
        for (MoveSummary ms : this.movesToReport) {
            String sourceFieldKey;
            Map fromMap = Map.getMapById(ms.getOldMapId());
            Map toMap = Map.getMapById(ms.getNewMapId());
            this.format.clearProperties();
            if (fromMap == null) {
                this.format.setFormat(toMap.getCreateFormat());
                sourceFieldKey = "Editor.Map.report_created";
            } else if (fromMap != toMap) {
                this.format.setFormat(toMap.getMoveToFormat());
                sourceFieldKey = "Editor.Map.report_move_to";
            } else {
                this.format.setFormat(toMap.getMoveWithinFormat());
                sourceFieldKey = "Editor.Map.report_move_within";
            }
            if (this.format.getFormat().length() == 0) break;
            this.format.setProperty("pieceName", ms.getPieceName());
            String loc = this.getLocation(toMap, ms.getNewPosition());
            this.format.setProperty("location", loc);
            if (fromMap != null) {
                this.format.setProperty("previousMap", fromMap.getLocalizedConfigureName());
                String oldLoc = this.getLocation(fromMap, ms.getOldPosition());
                this.format.setProperty("previousLocation", oldLoc);
                if (toMap == fromMap && toMap.isOnlyReportChangedLocation() && loc.equals(oldLoc)) continue;
            }
            this.format.setProperty("mapName", toMap.getLocalizedConfigureName());
            String moveText = this.format.getLocalizedText(toMap, sourceFieldKey);
            if (moveText.length() <= 0) continue;
            c = c.append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + moveText));
        }
        PieceAccess.GlobalAccess.revertAll();
        return c;
    }

    protected String getLocation(Map map, Point p) {
        return map.localizedLocationName(p);
    }

    public static class MoveSummary {
        protected String oldMapId;
        protected String newMapId;
        protected Point oldPosition;
        protected Point newPosition;
        protected List<GamePiece> pieces = new ArrayList<GamePiece>();

        public MoveSummary(AddPiece c) {
            GamePiece target = c.getTarget();
            this.newMapId = target.getMap().getIdentifier();
            this.newPosition = target.getPosition();
            this.pieces.add(target);
        }

        public MoveSummary(MovePiece c) {
            GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(c.getId());
            this.oldMapId = c.getOldMapId();
            this.newMapId = c.getNewMapId();
            this.oldPosition = c.getOldPosition();
            this.newPosition = c.getNewPosition();
            if (target != null) {
                this.pieces.add(target);
            }
        }

        public String getNewMapId() {
            return this.newMapId;
        }

        public Point getNewPosition() {
            return this.newPosition;
        }

        public String getOldMapId() {
            return this.oldMapId;
        }

        public Point getOldPosition() {
            return this.oldPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MoveSummary)) {
                return false;
            }
            MoveSummary moveSummary = (MoveSummary)o;
            if (!this.newPosition.equals(moveSummary.newPosition)) {
                return false;
            }
            if (!this.newMapId.equals(moveSummary.newMapId)) {
                return false;
            }
            if (!Objects.equals(this.oldMapId, moveSummary.oldMapId)) {
                return false;
            }
            if (this.oldMapId != null) {
                return Objects.equals(this.oldPosition, moveSummary.oldPosition);
            }
            return true;
        }

        public int hashCode() {
            int result = this.oldMapId != null ? this.oldMapId.hashCode() : 0;
            result = 29 * result + this.newMapId.hashCode();
            result = 29 * result + this.newPosition.hashCode();
            if (this.oldMapId != null) {
                result = 29 * result + (this.oldPosition != null ? this.oldPosition.hashCode() : 0);
            }
            return result;
        }

        public void append(MovePiece movePiece) {
            GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
            if (target != null && !this.pieces.contains(target)) {
                this.pieces.add(target);
            }
        }

        public String getPieceName() {
            StringBuilder names = new StringBuilder();
            Iterator<GamePiece> i = this.pieces.iterator();
            while (i.hasNext()) {
                names.append(i.next().getLocalizedName());
                if (!i.hasNext()) continue;
                names.append(", ");
            }
            return names.toString();
        }
    }

    public static class HiddenMoveSummary
    extends MoveSummary {
        public HiddenMoveSummary(AddPiece c) {
            super(c);
        }

        public HiddenMoveSummary(MovePiece c) {
            super(c);
        }

        @Override
        public String getPieceName() {
            StringBuilder names = new StringBuilder();
            boolean first = true;
            for (GamePiece piece : this.pieces) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        if (!this.isInvisible(p)) continue;
                        if (!first) {
                            names.append(", ");
                        }
                        names.append('?');
                        first = false;
                    }
                    continue;
                }
                if (!this.isInvisible(piece)) continue;
                if (!first) {
                    names.append(", ");
                }
                names.append('?');
                first = false;
            }
            return names.toString();
        }

        protected boolean isInvisible(GamePiece piece) {
            return Boolean.TRUE.equals(piece.getProperty("Invisible")) || Boolean.TRUE.equals(piece.getProperty("InvisibleToOthers"));
        }
    }

    public static class HiddenMovementReporter
    extends MovementReporter {
        public HiddenMovementReporter(Command moveCommand) {
            super(moveCommand);
        }

        @Override
        protected MoveSummary createMoveSummary(AddPiece c) {
            return new HiddenMoveSummary(c);
        }

        @Override
        protected MoveSummary createMoveSummary(MovePiece c) {
            return new HiddenMoveSummary(c);
        }

        @Override
        protected boolean shouldReport(AddPiece addPiece) {
            GamePiece target = addPiece.getTarget();
            return target != null && !(target instanceof Stack) && (Boolean.TRUE.equals(target.getProperty("Invisible")) || Boolean.TRUE.equals(target.getProperty("InvisibleToOthers")));
        }

        @Override
        protected boolean shouldReport(MovePiece movePiece) {
            GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(movePiece.getId());
            if (target == null) {
                return false;
            }
            if (target instanceof Stack) {
                Predicate<GamePiece> gamePiecePredicate = piece -> Boolean.TRUE.equals(piece.getProperty("Invisible")) || Boolean.TRUE.equals(piece.getProperty("InvisibleToOthers"));
                return ((Stack)target).asList().stream().anyMatch(gamePiecePredicate);
            }
            return Boolean.FALSE.equals(target.getProperty("InvisibleDisableAutoReportMoves")) && (Boolean.TRUE.equals(target.getProperty("Invisible")) || Boolean.TRUE.equals(target.getProperty("InvisibleToOthers")));
        }

        @Override
        protected String getLocation(Map map, Point p) {
            return "?";
        }
    }
}

