/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Attachment;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Labeler;
import VASSAL.counters.PieceDefiner;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.script.expression.IntBuilder;
import VASSAL.script.expression.StrBuilder;
import VASSAL.tools.menu.MenuScroller;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class BeanShellFunctionMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    public static final String COMMENT = "Comment";
    protected static final String[] NO_HINTS = new String[0];
    protected static final String[] GENERAL_PME_HINTS = new String[]{Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static final String[] SUM_COUNT_HINTS = new String[]{Resources.getString("Editor.BeanShell.warning"), Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static final String[] SUM_COUNT_MAP_HINTS = new String[]{Resources.getString("Editor.BeanShell.warning"), Resources.getString("Editor.BeanShell.map_warning"), Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static final String[] AUDIT_OPTION_HINTS = new String[]{Resources.getString("Editor.BeanShell.debug.audit.hint1"), Resources.getString("Editor.BeanShell.debug.audit.hint2"), Resources.getString("Editor.BeanShell.debug.audit.hint3"), Resources.getString("Editor.BeanShell.debug.audit.hint4"), Resources.getString("Editor.BeanShell.debug.audit.hint5")};
    protected static final String[] ATTACHMENT_INDEX_HINTS = new String[]{Resources.getString("Editor.BeanShell.attach_index.hint1")};
    protected static final String[] NAME_HINTS = new String[]{Resources.getString("Editor.BeanShell.debug.name_hint1")};
    protected static final String[] NAME_PME_HINTS = new String[]{Resources.getString("Editor.BeanShell.debug.name_hint1"), Resources.getString("Editor.BeanShell.warning2"), Resources.getString("Editor.BeanShell.warning3")};
    protected static int maxScrollItems = 0;
    protected BeanShellExpressionConfigurer configurer;
    protected EditablePiece target;
    protected Map menuMap;
    protected Zone menuZone;

    public BeanShellFunctionMenu(EditablePiece target, BeanShellExpressionConfigurer configurer) {
        this.target = target;
        this.configurer = configurer;
        JMenu constantMenu = new JMenu(Resources.getString("Editor.BeanShell.constant"));
        JMenuItem integerItem = new JMenuItem(Resources.getString("Editor.BeanShell.number"));
        integerItem.setToolTipText(Resources.getString("Editor.BeanShell.a_number"));
        integerItem.addActionListener(e -> this.buildInteger());
        constantMenu.add(integerItem);
        JMenuItem stringItem = new JMenuItem(Resources.getString("Editor.BeanShell.string"));
        stringItem.setToolTipText(Resources.getString("Editor.BeanShell.a_string"));
        stringItem.addActionListener(e -> this.buildString());
        constantMenu.add(stringItem);
        this.addSeparator(constantMenu);
        JMenuItem trueItem = new JMenuItem(Resources.getString("Editor.BeanShell.true"));
        trueItem.addActionListener(e -> this.buildBoolean(true));
        constantMenu.add(trueItem);
        JMenuItem falseItem = new JMenuItem(Resources.getString("Editor.BeanShell.false"));
        falseItem.addActionListener(e -> this.buildBoolean(false));
        constantMenu.add(falseItem);
        this.addSeparator(constantMenu);
        this.addFunction(constantMenu, COMMENT, Resources.getString("Editor.BeanShell.inline_comment"), new String[]{Resources.getString("Editor.BeanShell.comment")}, "", NO_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.COMMENT});
        this.add(constantMenu);
        JMenu propertyMenu = new JMenu(Resources.getString("Editor.BeanShell.property"));
        if (this.isPieceContext() || this.requiresGenericPiecePropertyMenu()) {
            JMenu pieceMenu = new JMenu(Resources.getString("Editor.BeanShell.piece_property"));
            this.addPieceProps(pieceMenu, target);
            if (this.requiresGenericPiecePropertyMenu()) {
                this.addGenericPiecePropMenu(pieceMenu);
            }
            propertyMenu.add(pieceMenu);
        }
        JMenu globalsMenu = new JMenu(Resources.getString("Editor.BeanShell.global_property"));
        this.buildGlobalMenu(globalsMenu, GameModule.getGameModule(), true);
        MenuScroller.setScrollerFor(globalsMenu, this.getMaxScrollItems(), 100);
        propertyMenu.add(globalsMenu);
        JMenu vassalMenu = new JMenu(Resources.getString("Editor.BeanShell.vassal_property"));
        for (String prop : GameModule.getGameModule().getPropertyNames()) {
            this.addProp(vassalMenu, prop, PropertyType.VASSAL);
        }
        propertyMenu.add(vassalMenu);
        this.add(propertyMenu);
        JMenu operatorMenu = new JMenu(Resources.getString("Editor.BeanShell.operator"));
        this.addOperator(operatorMenu, "+", Resources.getString("Editor.BeanShell.add"));
        this.addOperator(operatorMenu, "-", Resources.getString("Editor.BeanShell.subtract"));
        this.addOperator(operatorMenu, "*", Resources.getString("Editor.BeanShell.multiply"));
        this.addOperator(operatorMenu, "/", Resources.getString("Editor.BeanShell.divide"));
        this.addOperator(operatorMenu, "%", Resources.getString("Editor.BeanShell.modulus"));
        this.add(operatorMenu);
        JMenu comparisonMenu = new JMenu(Resources.getString("Editor.BeanShell.comparison"));
        this.addOperator(comparisonMenu, "==", Resources.getString("Editor.BeanShell.equals"));
        this.addOperator(comparisonMenu, "!=", Resources.getString("Editor.BeanShell.not_equals"));
        this.addOperator(comparisonMenu, ">", Resources.getString("Editor.BeanShell.greater_than"));
        this.addOperator(comparisonMenu, ">=", Resources.getString("Editor.BeanShell.greater_than_or_equal_to"));
        this.addOperator(comparisonMenu, "<", Resources.getString("Editor.BeanShell.less_than"));
        this.addOperator(comparisonMenu, "<=", Resources.getString("Editor.BeanShell.less_than_or_equal_to"));
        this.addOperator(comparisonMenu, "=~", Resources.getString("Editor.BeanShell.matches_regular_expression"));
        this.addOperator(comparisonMenu, "!~", Resources.getString("Editor.BeanShell.does_not_match_regular_expression"));
        this.add(comparisonMenu);
        JMenu logicalMenu = new JMenu(Resources.getString("Editor.BeanShell.logical"));
        this.addOperator(logicalMenu, "&&", Resources.getString("Editor.BeanShell.and"));
        this.addOperator(logicalMenu, "||", Resources.getString("Editor.BeanShell.or"));
        this.addOperator(logicalMenu, "!", Resources.getString("Editor.BeanShell.not"));
        this.addOperator(logicalMenu, "(", Resources.getString("Editor.BeanShell.left_parenthesis"));
        this.addOperator(logicalMenu, ")", Resources.getString("Editor.BeanShell.right_parenthesis"));
        this.add(logicalMenu);
        JMenu mathMenu = new JMenu(Resources.getString("Editor.BeanShell.math"));
        this.addFunction(mathMenu, "Math.abs", Resources.getString("Editor.BeanShell.abs"), new String[]{Resources.getString("Editor.BeanShell.number")}, "(n)");
        this.addFunction(mathMenu, "Math.min", Resources.getString("Editor.BeanShell.min"), new String[]{Resources.getString("Editor.BeanShell.number1"), Resources.getString("Editor.BeanShell.number2")}, "(m, n)");
        this.addFunction(mathMenu, "Math.max", Resources.getString("Editor.BeanShell.max"), new String[]{Resources.getString("Editor.BeanShell.number1"), Resources.getString("Editor.BeanShell.number2")}, "(m, n)");
        JMenu propMenu = new JMenu(Resources.getString("Editor.BeanShell.property"));
        this.addFunction(propMenu, "GetProperty", Resources.getString("Editor.BeanShell.getproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addFunction(propMenu, "GetString", Resources.getString("Editor.BeanShell.getstring"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addSeparator(propMenu);
        this.addFunction(propMenu, "GetAttachProperty", Resources.getString("Editor.BeanShell.getattachmentpropertyf"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name")}, "(attachment, prop)", NAME_HINTS);
        this.addFunction(propMenu, "GetAttachProperty", Resources.getString("Editor.BeanShell.getattachmentproperty"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.index_name")}, "(attachment, prop, index)", NAME_HINTS);
        this.addFunction(propMenu, "GetAttachProperty", Resources.getString("Editor.BeanShell.getattachmentpropertyb"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.basic_name")}, "(attachment, prop, basicName)", NAME_HINTS);
        this.addFunction(propMenu, "GetAttachProperty", Resources.getString("Editor.BeanShell.getattachmentpropertye"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(attachment, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(propMenu);
        this.addFunction(propMenu, "GetMapProperty", Resources.getString("Editor.BeanShell.getmapproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, map)", NAME_HINTS);
        this.addSeparator(propMenu);
        this.addFunction(propMenu, "GetZoneProperty", Resources.getString("Editor.BeanShell.getzoneproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name")}, "(prop, zone)", NAME_HINTS);
        this.addFunction(propMenu, "GetZoneProperty", Resources.getString("Editor.BeanShell.getzonemapproperty"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, zone, map)", NAME_HINTS);
        JMenu stringMenu = new JMenu(Resources.getString("Editor.BeanShell.string"));
        this.addFunction(stringMenu, ".length", Resources.getString("Editor.BeanShell.Slength"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".contains", Resources.getString("Editor.BeanShell.Scontains"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".isEmpty", Resources.getString("Editor.BeanShell.Sempty"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".isBlank", Resources.getString("Editor.BeanShell.Sblank"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".startsWith", Resources.getString("Editor.BeanShell.Sstartswith"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".endsWith", Resources.getString("Editor.BeanShell.Sendswith"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".matches", Resources.getString("Editor.BeanShell.Smatches"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.regex")}, "(regExpr)");
        this.addFunction(stringMenu, ".indexOf", Resources.getString("Editor.BeanShell.Sindexof"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".lastIndexOf", Resources.getString("Editor.BeanShell.Slastindexof"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.search_string")}, "(string)");
        this.addFunction(stringMenu, ".substring", Resources.getString("Editor.BeanShell.Ssubstring"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.starting_position")}, "(start)");
        this.addFunction(stringMenu, ".substring", Resources.getString("Editor.BeanShell.Ssubstring2"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.starting_position"), Resources.getString("Editor.BeanShell.ending_position")}, "(start, end)");
        this.addFunction(stringMenu, ".replace", Resources.getString("Editor.BeanShell.Sreplace"), new String[]{Resources.getString("Editor.BeanShell.target_string"), Resources.getString("Editor.BeanShell.to_find"), Resources.getString("Editor.BeanShell.to_replace")}, "(old, new)");
        this.addFunction(stringMenu, ".trim", Resources.getString("Editor.BeanShell.Strim"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".toUpperCase", Resources.getString("Editor.BeanShell.StoUpperCase"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".toLowerCase", Resources.getString("Editor.BeanShell.StoLowerCase"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        this.addFunction(stringMenu, ".toString", Resources.getString("Editor.BeanShell.Stostring"), new String[]{Resources.getString("Editor.BeanShell.target_string")}, "()");
        JMenu randomMenu = new JMenu(Resources.getString("Editor.BeanShell.random"));
        this.addFunction(randomMenu, "Random", Resources.getString("Editor.BeanShell.random1"), new String[]{Resources.getString("Editor.BeanShell.randomhi")}, "(x)");
        this.addFunction(randomMenu, "Random", Resources.getString("Editor.BeanShell.random2"), new String[]{Resources.getString("Editor.BeanShell.randomlo"), Resources.getString("Editor.BeanShell.randomhi")}, "(x, y)");
        this.addSeparator(randomMenu);
        this.addFunction(randomMenu, "IsRandom", Resources.getString("Editor.BeanShell.random3"), new String[0], "()");
        this.addFunction(randomMenu, "IsRandom", Resources.getString("Editor.BeanShell.random4"), new String[]{Resources.getString("Editor.BeanShell.randomp")}, "(p)");
        JMenu attachmentMenu = new JMenu(Resources.getString("Editor.BeanShell.by_attachment"));
        this.addFunction(attachmentMenu, "SumAttach", Resources.getString("Editor.BeanShell.sum10"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name")}, "(name, prop)", NAME_HINTS);
        this.addFunction(attachmentMenu, "SumAttach", Resources.getString("Editor.BeanShell.sum10e"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(name, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(attachmentMenu);
        this.addFunction(attachmentMenu, "CountAttach", Resources.getString("Editor.BeanShell.sum11a"), new String[]{Resources.getString("Editor.BeanShell.attachment_name")}, "(name)", NAME_HINTS);
        this.addFunction(attachmentMenu, "CountAttach", Resources.getString("Editor.BeanShell.sum11"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name")}, "(name, prop)", NAME_HINTS);
        this.addFunction(attachmentMenu, "CountAttach", Resources.getString("Editor.BeanShell.sum12"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(name, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(attachmentMenu, "CountAttach", Resources.getString("Editor.BeanShell.sum12e"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(name, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(attachmentMenu);
        this.addFunction(attachmentMenu, "MinAttach", Resources.getString("Editor.BeanShell.sum14"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name")}, "(name, prop)", NAME_HINTS);
        this.addFunction(attachmentMenu, "MaxAttach", Resources.getString("Editor.BeanShell.sum13"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_name")}, "(name, prop)", NAME_HINTS);
        JMenu locationMenu = new JMenu(Resources.getString("Editor.BeanShell.by_location"));
        if (this.isPieceContext()) {
            this.addFunction(locationMenu, "SumLocation", Resources.getString("Editor.BeanShell.sum15"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(locationMenu, "SumLocation", Resources.getString("Editor.BeanShell.sum16"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(locationMenu);
        }
        this.addFunction(locationMenu, "SumLocation", Resources.getString("Editor.BeanShell.sum17"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, loc, map)", NAME_HINTS);
        this.addFunction(locationMenu, "SumLocation", Resources.getString("Editor.BeanShell.sum18"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, loc, map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(locationMenu);
        if (this.isPieceContext()) {
            this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum19"), new String[0], "()");
            this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum20"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum21"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
            this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum22"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(locationMenu);
        }
        this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum23"), new String[]{Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name")}, "(loc, map)", NAME_HINTS);
        this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum24"), new String[]{Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name")}, "(loc, map, prop)", NAME_HINTS);
        this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum25"), new String[]{Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(loc, map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(locationMenu, "CountLocation", Resources.getString("Editor.BeanShell.sum26"), new String[]{Resources.getString("Editor.BeanShell.location_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(loc, map, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        JMenu stackMenu = new JMenu(Resources.getString("Editor.BeanShell.by_stack"));
        this.addFunction(stackMenu, "SumStack", Resources.getString("Editor.BeanShell.sum1"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addFunction(stackMenu, "SumStack", Resources.getString("Editor.BeanShell.sum1e"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(stackMenu);
        this.addFunction(stackMenu, "CountStack", Resources.getString("Editor.BeanShell.sum6"), new String[0], "()");
        this.addFunction(stackMenu, "CountStack", Resources.getString("Editor.BeanShell.sum7"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addFunction(stackMenu, "CountStack", Resources.getString("Editor.BeanShell.sum6e"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(stackMenu, "CountStack", Resources.getString("Editor.BeanShell.sum7e"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        JMenu matMenu = new JMenu(Resources.getString("Editor.BeanShell.by_mat"));
        this.addFunction(matMenu, "SumMat", Resources.getString("Editor.BeanShell.sum8"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addFunction(matMenu, "SumMat", Resources.getString("Editor.BeanShell.sum8e"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(matMenu);
        this.addFunction(matMenu, "CountMat", Resources.getString("Editor.BeanShell.sum9b"), new String[0], "()");
        this.addFunction(matMenu, "CountMat", Resources.getString("Editor.BeanShell.sum9"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
        this.addFunction(matMenu, "CountMat", Resources.getString("Editor.BeanShell.sum9e"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(matMenu, "CountMat", Resources.getString("Editor.BeanShell.sum9ee"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        JMenu zoneMenu = new JMenu(Resources.getString("Editor.BeanShell.by_zone"));
        if (this.isPieceContext()) {
            this.addFunction(zoneMenu, "SumZone", Resources.getString("Editor.BeanShell.sum27"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(zoneMenu, "SumZone", Resources.getString("Editor.BeanShell.sum28"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(zoneMenu);
        }
        this.addFunction(zoneMenu, "SumZone", Resources.getString("Editor.BeanShell.sum29"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, zone, map)", NAME_HINTS);
        this.addFunction(zoneMenu, "SumZone", Resources.getString("Editor.BeanShell.sum30"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, zone, map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(zoneMenu);
        if (this.isPieceContext()) {
            this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum31"), new String[0], "()");
            this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum32"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum33"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
            this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum34"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(zoneMenu);
        }
        this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum35"), new String[]{Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name")}, "(zone, map)", NAME_HINTS);
        this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum36"), new String[]{Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name")}, "(zone, map, prop)", NAME_HINTS);
        this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum37"), new String[]{Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(zone, map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(zoneMenu, "CountZone", Resources.getString("Editor.BeanShell.sum38"), new String[]{Resources.getString("Editor.BeanShell.zone_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(zone, map, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        JMenu mapMenu = new JMenu(Resources.getString("Editor.BeanShell.by_map"));
        if (this.isPieceContext()) {
            this.addFunction(mapMenu, "SumMap", Resources.getString("Editor.BeanShell.sum39"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(mapMenu, "SumMap", Resources.getString("Editor.BeanShell.sum40"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(mapMenu);
        }
        this.addFunction(mapMenu, "SumMap", Resources.getString("Editor.BeanShell.sum41"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.map_name")}, "(prop, map)", NAME_HINTS);
        this.addFunction(mapMenu, "SumMap", Resources.getString("Editor.BeanShell.sum42"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addSeparator(mapMenu);
        if (this.isPieceContext()) {
            this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum43"), new String[0], "()");
            this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum44"), new String[]{Resources.getString("Editor.BeanShell.property_name")}, "(prop)", NAME_HINTS);
            this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum45"), new String[]{Resources.getString("Editor.BeanShell.property_match_expression")}, "(expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.PME});
            this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum46"), new String[]{Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(mapMenu);
        }
        this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum47"), new String[]{Resources.getString("Editor.BeanShell.map_name")}, "(map)", NAME_HINTS);
        this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum48"), new String[]{Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name")}, "(map, prop)", NAME_HINTS);
        this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum49"), new String[]{Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(map, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(mapMenu, "CountMap", Resources.getString("Editor.BeanShell.sum50"), new String[]{Resources.getString("Editor.BeanShell.map_name"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(map, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        JMenu rangedMenu = new JMenu(Resources.getString("Editor.BeanShell.ranged"));
        if (this.isPieceContext()) {
            this.addFunction(rangedMenu, "SumRange", Resources.getString("Editor.BeanShell.ranged1"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name")}, "(min, max, prop)", NAME_HINTS);
            this.addFunction(rangedMenu, "SumRange", Resources.getString("Editor.BeanShell.ranged2"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range", Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression"))}, "(min, max, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(rangedMenu);
            this.addFunction(rangedMenu, "SumRangePx", Resources.getString("Editor.BeanShell.ranged1p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name")}, "(min, max, prop)", NAME_HINTS);
            this.addFunction(rangedMenu, "SumRangePx", Resources.getString("Editor.BeanShell.ranged2p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range", Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression"))}, "(min, max, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(rangedMenu);
            this.addFunction(rangedMenu, "CountRange", Resources.getString("Editor.BeanShell.ranged3"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range")}, "(min, max)");
            this.addFunction(rangedMenu, "CountRange", Resources.getString("Editor.BeanShell.ranged4"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name")}, "(min, max, prop)", NAME_HINTS);
            this.addFunction(rangedMenu, "CountRange", Resources.getString("Editor.BeanShell.ranged5"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(min, max, expr)", GENERAL_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addFunction(rangedMenu, "CountRange", Resources.getString("Editor.BeanShell.ranged6"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(min, max, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(rangedMenu);
            this.addFunction(rangedMenu, "CountRangePx", Resources.getString("Editor.BeanShell.ranged3p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range")}, "(min, max)");
            this.addFunction(rangedMenu, "CountRangePx", Resources.getString("Editor.BeanShell.ranged4p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name")}, "(min, max, prop)", NAME_HINTS);
            this.addFunction(rangedMenu, "CountRangePx", Resources.getString("Editor.BeanShell.ranged5p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(min, max, expr)", GENERAL_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addFunction(rangedMenu, "CountRangePx", Resources.getString("Editor.BeanShell.ranged6p"), new String[]{Resources.getString("Editor.BeanShell.minimum_range"), Resources.getString("Editor.BeanShell.maximum_range"), Resources.getString("Editor.BeanShell.property_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(min, max, prop, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        }
        JMenu countMenu = new JMenu(Resources.getString("Editor.BeanShell.sumcount"));
        if (this.isPieceContext()) {
            countMenu.add(stackMenu);
            countMenu.add(matMenu);
            countMenu.add(attachmentMenu);
        }
        countMenu.add(locationMenu);
        countMenu.add(zoneMenu);
        countMenu.add(mapMenu);
        if (this.isPieceContext()) {
            countMenu.add(rangedMenu);
        }
        JMenu rangeMenu = new JMenu(Resources.getString("Editor.BeanShell.range"));
        if (this.isPieceContext()) {
            this.addFunction(rangeMenu, "Range", Resources.getString("Editor.BeanShell.range2"), new String[]{Resources.getString("Editor.BeanShell.x"), Resources.getString("Editor.BeanShell.y")}, "(x, y)");
            this.addFunction(rangeMenu, "Range", Resources.getString("Editor.BeanShell.range8"), new String[]{Resources.getString("Editor.BeanShell.fromx"), Resources.getString("Editor.BeanShell.fromy"), Resources.getString("Editor.BeanShell.tox"), Resources.getString("Editor.BeanShell.toy")}, "(x1, y1, x2, y2)");
            this.addFunction(rangeMenu, "Range", Resources.getString("Editor.BeanShell.range4"), new String[]{Resources.getString("Editor.BeanShell.attachment_name")}, "(attachment)");
            this.addFunction(rangeMenu, "Range", Resources.getString("Editor.BeanShell.range4e"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(attachment, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(rangeMenu);
        }
        this.addFunction(rangeMenu, "Range", Resources.getString("Editor.BeanShell.range6"), new String[]{Resources.getString("Editor.BeanShell.fromx"), Resources.getString("Editor.BeanShell.fromy"), Resources.getString("Editor.BeanShell.tox"), Resources.getString("Editor.BeanShell.toy"), Resources.getString("Editor.BeanShell.map")}, "(x1, y1, x2, y2, map)");
        this.addSeparator(rangeMenu);
        if (this.isPieceContext()) {
            this.addFunction(rangeMenu, "RangePx", Resources.getString("Editor.BeanShell.range1"), new String[]{Resources.getString("Editor.BeanShell.x"), Resources.getString("Editor.BeanShell.y")}, "(x, y)");
            this.addFunction(rangeMenu, "RangePx", Resources.getString("Editor.BeanShell.range7"), new String[]{Resources.getString("Editor.BeanShell.fromx"), Resources.getString("Editor.BeanShell.fromy"), Resources.getString("Editor.BeanShell.tox"), Resources.getString("Editor.BeanShell.toy")}, "(x1, y1, x2, y2)");
            this.addFunction(rangeMenu, "RangePx", Resources.getString("Editor.BeanShell.range3"), new String[]{Resources.getString("Editor.BeanShell.attachment_name")}, "(attachment)", NAME_HINTS);
            this.addFunction(rangeMenu, "RangePx", Resources.getString("Editor.BeanShell.range3e"), new String[]{Resources.getString("Editor.BeanShell.attachment_name"), Resources.getString("Editor.BeanShell.property_match_expression")}, "(attachment, expr)", NAME_PME_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
            this.addSeparator(rangeMenu);
        }
        this.addFunction(rangeMenu, "RangePx", Resources.getString("Editor.BeanShell.range5"), new String[]{Resources.getString("Editor.BeanShell.fromx"), Resources.getString("Editor.BeanShell.fromy"), Resources.getString("Editor.BeanShell.tox"), Resources.getString("Editor.BeanShell.toy"), Resources.getString("Editor.BeanShell.map")}, "(x1, y1, x2, y2, map)");
        JMenu functionMenu = new JMenu(Resources.getString("Editor.BeanShell.function"));
        functionMenu.add(mathMenu);
        functionMenu.add(propMenu);
        functionMenu.add(randomMenu);
        functionMenu.add(stringMenu);
        functionMenu.add(countMenu);
        functionMenu.add(rangeMenu);
        this.addFunction(functionMenu, "?", Resources.getString("Editor.BeanShell.ternary"), new String[]{Resources.getString("Editor.BeanShell.logical_expression"), Resources.getString("Editor.BeanShell.if_true"), Resources.getString("Editor.BeanShell.if_false")}, "(expr ? r1 : r2)");
        this.add(functionMenu);
        JMenu otherMenu = new JMenu(Resources.getString("Editor.BeanShell.other"));
        this.addFunction(otherMenu, "Alert", Resources.getString("Editor.BeanShell.debug.alert"), new String[]{Resources.getString("Editor.BeanShell.text_to_display")}, "(text)");
        this.addFunction(otherMenu, "Alert", Resources.getString("Editor.BeanShell.debug.alert2"), new String[]{Resources.getString("Editor.BeanShell.text_to_display"), Resources.getString("Editor.BeanShell.milliseconds")}, "(text, ms)");
        this.addFunction(otherMenu, "Sleep", Resources.getString("Editor.BeanShell.debug.sleep"), new String[]{Resources.getString("Editor.BeanShell.milliseconds")}, "(ms)");
        this.addFunction(otherMenu, "Audit", Resources.getString("Editor.BeanShell.debug.audit1"), new String[]{Resources.getString("Editor.BeanShell.text_to_display")}, "(text)");
        this.addFunction(otherMenu, "Audit", Resources.getString("Editor.BeanShell.debug.audit2"), new String[]{Resources.getString("Editor.BeanShell.text_to_display"), Resources.getString("Editor.BeanShell.debug.audit.options")}, "(text, options)", AUDIT_OPTION_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.NONE});
        this.addFunction(otherMenu, "Audit", Resources.getString("Editor.BeanShell.debug.audit3"), new String[]{Resources.getString("Editor.BeanShell.text_to_display"), Resources.getString("Editor.BeanShell.debug.audit.match_expression")}, "(text, expr)", NO_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME});
        this.addFunction(otherMenu, "Audit", Resources.getString("Editor.BeanShell.debug.audit4"), new String[]{Resources.getString("Editor.BeanShell.text_to_display"), Resources.getString("Editor.BeanShell.debug.audit.match_expression"), Resources.getString("Editor.BeanShell.debug.audit.options")}, "(text, expr, options)", AUDIT_OPTION_HINTS, new BeanShellExpressionConfigurer.Option[]{BeanShellExpressionConfigurer.Option.NONE, BeanShellExpressionConfigurer.Option.PME, BeanShellExpressionConfigurer.Option.NONE});
        this.add(otherMenu);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo) {
        this.addFunction(menu, op, desc, parms, parmInfo, null);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints) {
        BeanShellExpressionConfigurer.Option[] options = new BeanShellExpressionConfigurer.Option[parms.length];
        Arrays.fill((Object[])options, (Object)BeanShellExpressionConfigurer.Option.NONE);
        this.addFunction(menu, op, desc, parms, parmInfo, hints, options);
    }

    protected void addFunction(JMenu menu, String op, String desc, String[] parms, String parmInfo, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        JMenuItem item = new JMenuItem(op + (String)(parmInfo != null && parmInfo.length() == 0 ? "" : " " + parmInfo));
        item.setToolTipText(desc);
        item.addActionListener(e -> this.buildFunction(op, desc, parms, hints, options));
        menu.add(item);
    }

    protected void addSeparator(JMenu menu) {
        menu.addSeparator();
    }

    protected void buildFunction(String op, String desc, String[] parmDesc, String[] hints, BeanShellExpressionConfigurer.Option[] options) {
        if (parmDesc.length == 0) {
            this.configurer.insertName(op + "()");
        } else {
            StringConfigurer result = new StringConfigurer(null, "", "");
            new FunctionBuilder(result, (JDialog)this.configurer.getTopLevelAncestor(), op, desc, parmDesc, this.target, hints, options, this.configurer.getSelectedText()).setVisible(true);
            if (result.getValue() != null && result.getValueString().length() > 0) {
                this.configurer.insertName(result.getValueString());
            }
        }
    }

    protected void buildInteger() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new IntBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void buildString() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new StrBuilder(result, (JDialog)this.configurer.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.configurer.insertName(result.getValueString());
        }
    }

    protected void buildBoolean(boolean b) {
        this.configurer.insertName(b ? "true" : "false");
    }

    protected void addOperator(JMenu menu, String op, String desc) {
        JMenuItem item = new JMenuItem(op);
        item.setToolTipText(desc);
        item.addActionListener(e -> this.configurer.insertName(op));
        menu.add(item);
    }

    protected void addProp(JMenu menu, String propName, PropertyType propertyType) {
        if (propName == null) {
            return;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).getText().equals(propName)) continue;
            return;
        }
        if (this.isPieceContext() && PropertyType.GLOBAL == propertyType) {
            if (this.menuZone != null) {
                JMenu pieceMenu = new JMenu(propName);
                JMenuItem sameZone = new JMenuItem(Resources.getString("Editor.BeanShell.same_zone"));
                sameZone.addActionListener(e -> this.configurer.insertPropertyName(propName));
                JMenuItem sameItem = new JMenuItem(Resources.getString("Editor.BeanShell.same_map"));
                String actionName = this.getActionName(propName, true);
                sameItem.addActionListener(e -> this.configurer.insertName(actionName));
                JMenuItem diffItem = new JMenuItem(Resources.getString("Editor.BeanShell.different_map"));
                diffItem.addActionListener(e -> this.configurer.insertName(actionName));
                pieceMenu.add(sameZone);
                pieceMenu.add(sameItem);
                pieceMenu.add(diffItem);
                this.insertMenuItem(menu, propName, pieceMenu);
                return;
            }
            if (this.menuMap != null) {
                JMenu pieceMenu = new JMenu(propName);
                JMenuItem sameItem = new JMenuItem(Resources.getString("Editor.BeanShell.same_map"));
                sameItem.addActionListener(e -> this.configurer.insertPropertyName(propName));
                JMenuItem diffItem = new JMenuItem(Resources.getString("Editor.BeanShell.different_map"));
                String actionName = this.getActionName(propName);
                diffItem.addActionListener(e -> this.configurer.insertName(actionName));
                pieceMenu.add(sameItem);
                pieceMenu.add(diffItem);
                this.insertMenuItem(menu, propName, pieceMenu);
                return;
            }
        }
        JMenuItem item = new JMenuItem(propName);
        String actionName = this.getActionName(propName);
        if (actionName.startsWith("\"") && actionName.endsWith("\"")) {
            item.addActionListener(e -> this.configurer.insertPropertyName(actionName));
        } else {
            item.addActionListener(e -> this.configurer.insertName(actionName));
        }
        this.insertMenuItem(menu, propName, item);
    }

    protected void insertMenuItem(JMenu menu, String name, JMenuItem item) {
        int pos = -1;
        for (int i = 0; i < menu.getItemCount() && pos < 0; ++i) {
            if (name.compareTo(menu.getItem(i).getText()) > 0) continue;
            pos = i;
        }
        menu.add((Component)item, pos);
    }

    protected String getActionName(String propName) {
        return this.getActionName(propName, false);
    }

    protected String getActionName(String propName, boolean zoneCurrentMapOverride) {
        if (this.menuZone != null) {
            if (this.menuMap.equals(this.configurer.getContext()) || zoneCurrentMapOverride) {
                return "GetZoneProperty(\"" + propName + "\", \"" + this.menuZone.getName() + "\", CurrentMap)";
            }
            return "GetZoneProperty(\"" + propName + "\", \"" + this.menuZone.getName() + "\", \"" + this.menuMap.getMapName() + "\")";
        }
        if (this.menuMap != null) {
            if (this.menuMap.equals(this.configurer.getContext())) {
                return propName;
            }
            return "GetMapProperty(\"" + propName + "\", \"" + this.menuMap.getMapName() + "\")";
        }
        return propName;
    }

    protected void addPieceProps(JMenu menu, EditablePiece piece) {
        if (piece == null) {
            return;
        }
        JMenu pieceMenu = null;
        if (piece instanceof PropertyNameSource) {
            List<String> propNames = ((PropertyNameSource)((Object)piece)).getPropertyNames();
            for (String propName : propNames) {
                if (pieceMenu == null) {
                    pieceMenu = new JMenu();
                    String menuText = piece instanceof BasicPiece && piece.getDescription().isEmpty() ? Resources.getString("Editor.BasicPiece.trait_description") : piece.getDescription();
                    pieceMenu.setText(menuText);
                }
                this.addProp(pieceMenu, propName, PropertyType.PIECE);
            }
            if (pieceMenu != null) {
                menu.add(pieceMenu);
            }
            if (piece instanceof Decorator) {
                this.addPieceProps(menu, (EditablePiece)((Decorator)piece).getInner());
            }
        }
    }

    protected void addGenericPiecePropMenu(JMenu menu) {
        JMenu propMenu = new JMenu(Resources.getString("Editor.BeanShell.generic_piece_propertys"));
        BasicPiece basicPiece = new BasicPiece();
        this.addPieceProps(propMenu, basicPiece);
        for (GamePiece piece : new PieceDefiner().getTraitList()) {
            List<String> propNames = ((PropertyNameSource)((Object)piece)).getPropertyNames();
            if (propNames.isEmpty()) continue;
            JMenu pieceMenu = new JMenu(((Decorator)piece).getBaseDescription());
            for (String propName : propNames) {
                Object displayName = propName;
                if (propName.isEmpty()) {
                    displayName = "<" + Resources.getString("Editor.BeanShell.prop_name") + ">";
                } else if (propName.startsWith("_")) {
                    displayName = "<" + Resources.getString(piece instanceof Attachment ? "Editor.BeanShell.attach_name" : "Editor.BeanShell.trait_name") + ">" + propName;
                } else if (piece instanceof Labeler) {
                    displayName = "<" + Resources.getString("Editor.BeanShell.label_name") + ">";
                }
                this.addProp(pieceMenu, (String)displayName, PropertyType.PIECE);
            }
            propMenu.add(pieceMenu);
        }
        menu.add(propMenu);
    }

    protected void buildGlobalMenu(JMenu parentMenu, AbstractBuildable target, boolean useParentMenu) {
        String n;
        if (target instanceof Map) {
            this.menuMap = (Map)target;
        } else if (target instanceof Zone) {
            this.menuZone = (Zone)target;
        }
        List<Buildable> buildables = target.getBuildables();
        Object menuName = ConfigureTree.getConfigureName(target.getClass());
        if (target instanceof AbstractConfigurable && (n = ((AbstractConfigurable)target).getConfigureName()) != null && n.length() > 0) {
            menuName = (String)menuName + " " + n;
        }
        JMenu myMenu = new JMenu((String)menuName);
        if (!(target instanceof GameModule)) {
            List<String> propNames = target.getPropertyNames();
            Iterator iterator = propNames.iterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                this.addProp(useParentMenu ? parentMenu : myMenu, propName, PropertyType.GLOBAL);
            }
        }
        for (Buildable b : buildables) {
            if (b instanceof AbstractConfigurable) {
                boolean useParent = b instanceof GlobalProperties || b instanceof Board || b instanceof ZonedGrid;
                this.buildGlobalMenu(useParentMenu ? parentMenu : myMenu, (AbstractConfigurable)b, useParent);
                continue;
            }
            if (!(b instanceof BoardPicker)) continue;
            this.buildGlobalMenu(myMenu, (AbstractBuildable)b, true);
        }
        if (!useParentMenu && myMenu.getItemCount() > 0) {
            MenuScroller.setScrollerFor(myMenu, this.getMaxScrollItems(), 100);
            int pos = -1;
            for (int i = 0; i < parentMenu.getItemCount() && pos < 0; ++i) {
                if (myMenu.getText().compareTo(parentMenu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            parentMenu.add((Component)myMenu, pos);
        }
        if (target instanceof Map) {
            this.menuMap = null;
        } else if (target instanceof Zone) {
            this.menuZone = null;
        }
    }

    protected int getMaxScrollItems() {
        if (maxScrollItems == 0) {
            Dimension itemSize = new JMenuItem("Testing").getPreferredSize();
            maxScrollItems = (int)(0.98 * (double)SwingUtils.getScreenBounds((Component)this.configurer.getControls()).height / (double)itemSize.height);
        }
        return maxScrollItems;
    }

    protected boolean isPieceContext() {
        return this.configurer.isPieceContext() || this.configurer.getOption() == BeanShellExpressionConfigurer.Option.PME;
    }

    protected boolean requiresGenericPiecePropertyMenu() {
        return this.configurer.getOption() == BeanShellExpressionConfigurer.Option.PME || this.configurer.isPieceContext() && this.target == null;
    }

    static enum PropertyType {
        PIECE,
        GLOBAL,
        VASSAL,
        ALL;

    }
}

