/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Comment
extends Decorator
implements EditablePiece {
    public static final String ID = "cmt;";
    private String comment;

    public Comment() {
        this(ID, null);
    }

    public Comment(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.comment;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Comment.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Comment.html");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.comment = st.nextToken("");
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.comment);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment c = (Comment)o;
        return Objects.equals(this.comment, c.comment);
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.comment);
    }

    public static class Editor
    implements PieceEditor {
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer commentConfig;

        public Editor(Comment cmt) {
            this.commentConfig = new StringConfigurer(cmt.comment);
            this.controls.add("Editor.Comment.comment", (Configurer)this.commentConfig);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            return Comment.ID + this.commentConfig.getValueString();
        }
    }
}

