/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.SystemUtils;

public class Immobilized
extends Decorator
implements EditablePiece {
    public static final String ID = "immob;";
    protected boolean shiftToSelect = false;
    protected boolean ctrlToSelect = false;
    protected boolean altToSelect = false;
    protected boolean ignoreGrid = false;
    protected boolean neverSelect = false;
    protected boolean neverMove = false;
    protected boolean moveIfSelected = false;
    protected boolean neverBandSelect = false;
    protected boolean altToBandSelect = false;
    protected boolean altShiftToBandSelect = false;
    protected boolean canStack = false;
    protected String description;
    protected EventFilter selectFilter;
    protected EventFilter moveFilter;
    protected EventFilter bandselectFilter;
    protected static final char MOVE_SELECTED = 'I';
    protected static final char MOVE_NORMAL = 'N';
    protected static final char NEVER_MOVE = 'V';
    protected static final char IGNORE_GRID = 'g';
    protected static final char SHIFT_SELECT = 'i';
    protected static final char CTRL_SELECT = 't';
    protected static final char ALT_SELECT = 'c';
    protected static final char NEVER_SELECT = 'n';
    protected static final char NEVER_BAND_SELECT = 'Z';
    protected static final char ALT_BAND_SELECT = 'A';
    protected static final char ALT_SHIFT_BAND_SELECT = 'B';
    protected static final char STACK_NORMAL = 'L';
    protected static final char NEVER_STACK = 'R';
    public static final String BASE_IGNORE_GRID = "baseIgnoreGrid";
    protected static final EventFilter NEVER = evt -> true;

    public Immobilized() {
        this(ID, null);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public Immobilized(GamePiece p, String type) {
        this(type, p);
    }

    public Immobilized(String type, GamePiece p) {
        this.setInner(p);
        this.mySetType(type);
    }

    @Override
    public void mySetType(String type) {
        this.shiftToSelect = false;
        this.ctrlToSelect = false;
        this.altToSelect = false;
        this.neverSelect = false;
        this.ignoreGrid = false;
        this.neverMove = false;
        this.moveIfSelected = false;
        this.neverBandSelect = false;
        this.altToBandSelect = false;
        this.altShiftToBandSelect = false;
        this.canStack = false;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String selectionOptions = st.nextToken("");
        String movementOptions = st.nextToken("");
        String stackingOptions = st.nextToken(String.valueOf('R'));
        this.description = st.nextToken("");
        if (selectionOptions.indexOf(105) >= 0) {
            this.shiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(116) >= 0) {
            this.ctrlToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(99) >= 0) {
            this.altToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(110) >= 0) {
            this.neverSelect = true;
            this.neverMove = true;
        }
        if (selectionOptions.indexOf(103) >= 0) {
            this.ignoreGrid = true;
        }
        if (selectionOptions.indexOf(65) >= 0) {
            this.altToBandSelect = true;
        }
        if (selectionOptions.indexOf(66) >= 0) {
            this.altShiftToBandSelect = true;
        }
        if (selectionOptions.indexOf(90) >= 0) {
            this.neverBandSelect = true;
        }
        if (movementOptions.length() > 0) {
            switch (movementOptions.charAt(0)) {
                case 'V': {
                    this.neverMove = true;
                    this.moveIfSelected = false;
                    break;
                }
                case 'I': {
                    this.neverMove = false;
                    this.moveIfSelected = true;
                    break;
                }
                default: {
                    this.neverMove = false;
                    this.moveIfSelected = false;
                }
            }
        }
        this.selectFilter = this.neverSelect ? NEVER : (this.shiftToSelect ? new UseShift() : (this.ctrlToSelect ? new UseCtrl() : (this.altToSelect ? new UseAlt() : null)));
        this.moveFilter = this.neverMove ? NEVER : (this.moveIfSelected ? new MoveIfSelected() : null);
        this.bandselectFilter = this.neverBandSelect ? NEVER : (this.altToBandSelect ? new UseAlt() : (this.altShiftToBandSelect ? new UseAltShift() : null));
        if (stackingOptions.charAt(0) == 'L') {
            this.canStack = true;
        }
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public Command myKeyEvent(KeyStroke e) {
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("NoStack".equals(key)) {
            return this.canStack ? null : Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if (BASE_IGNORE_GRID.equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("NoStack".equals(key)) {
            return this.canStack ? null : Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if (BASE_IGNORE_GRID.equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getProperty(key);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetType() {
        StringBuilder buffer = new StringBuilder(ID);
        if (this.neverSelect) {
            buffer.append('n');
        } else if (this.shiftToSelect) {
            buffer.append('i');
        } else if (this.ctrlToSelect) {
            buffer.append('t');
        } else if (this.altToSelect) {
            buffer.append('c');
        }
        if (this.ignoreGrid) {
            buffer.append('g');
        }
        if (this.neverBandSelect) {
            buffer.append('Z');
        } else if (this.altToBandSelect) {
            buffer.append('A');
        } else if (this.altShiftToBandSelect) {
            buffer.append('B');
        }
        buffer.append(';');
        if (this.neverMove) {
            buffer.append('V');
        } else if (this.moveIfSelected) {
            buffer.append('I');
        } else {
            buffer.append('N');
        }
        buffer.append(';');
        if (this.canStack) {
            buffer.append('L');
        } else {
            buffer.append('R');
        }
        buffer.append(';').append(this.description);
        return buffer.toString();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String s) {
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.Immobilized.trait_description", this.description);
        Object options = "";
        if (this.canStack) {
            options = (String)options + Resources.getString("Editor.Immobilized.summary_does_stack");
        }
        if (this.neverSelect) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_never_select");
        } else if (this.altToSelect) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_alt_select");
        } else if (this.shiftToSelect) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_shift_select");
        } else if (this.ctrlToSelect) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_ctrl_select");
        }
        if (!this.neverSelect) {
            if (this.neverBandSelect) {
                if (!((String)options).isEmpty()) {
                    options = (String)options + ", ";
                }
                options = (String)options + Resources.getString("Editor.Immobilized.summary_never_band_select");
            } else if (this.altToBandSelect) {
                if (!((String)options).isEmpty()) {
                    options = (String)options + ", ";
                }
                options = (String)options + Resources.getString("Editor.Immobilized.summary_alt_band_select");
            } else if (this.altShiftToBandSelect) {
                if (!((String)options).isEmpty()) {
                    options = (String)options + ", ";
                }
                options = (String)options + Resources.getString("Editor.Immobilized.summary_alt_shift_band_select");
            }
        }
        if (this.neverMove) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_never_move");
        } else if (this.moveIfSelected) {
            if (!((String)options).isEmpty()) {
                options = (String)options + ", ";
            }
            options = (String)options + Resources.getString("Editor.Immobilized.summary_move_if_selected");
        }
        if (!((String)options).isEmpty()) {
            s = (String)s + " - ";
            s = (String)s + (String)options;
        }
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Immobilized.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonStacking.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Immobile");
        l.add("IgnoreGrid");
        l.add("cannotMove");
        l.add("NoStack");
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Immobilized)) {
            return false;
        }
        Immobilized c = (Immobilized)o;
        if (!Objects.equals(this.shiftToSelect, c.shiftToSelect)) {
            return false;
        }
        if (!Objects.equals(this.ctrlToSelect, c.ctrlToSelect)) {
            return false;
        }
        if (!Objects.equals(this.altToSelect, c.altToSelect)) {
            return false;
        }
        if (!Objects.equals(this.neverSelect, c.neverSelect)) {
            return false;
        }
        if (!Objects.equals(this.ignoreGrid, c.ignoreGrid)) {
            return false;
        }
        if (!Objects.equals(this.neverMove, c.neverMove)) {
            return false;
        }
        if (!Objects.equals(this.moveIfSelected, c.moveIfSelected)) {
            return false;
        }
        if (!Objects.equals(this.neverBandSelect, c.neverBandSelect)) {
            return false;
        }
        if (!Objects.equals(this.altShiftToBandSelect, c.altShiftToBandSelect)) {
            return false;
        }
        if (!Objects.equals(this.canStack, c.canStack)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        return Objects.equals(this.altToBandSelect, c.altToBandSelect);
    }

    public class UseShift
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isShiftDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseCtrl
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !(!SystemUtils.IS_OS_MAC ? evt.isControlDown() : evt.isMetaDown()) && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseAlt
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isAltDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    protected class MoveIfSelected
    implements EventFilter {
        protected MoveIfSelected() {
        }

        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseAltShift
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return (!evt.isAltDown() || !evt.isShiftDown()) && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    private static class Ed
    implements PieceEditor {
        private final TranslatingStringEnumConfigurer selectionOption;
        private final TranslatingStringEnumConfigurer movementOption;
        private final TranslatingStringEnumConfigurer bandSelectOption;
        private final TranslatingStringEnumConfigurer stackOption;
        private final BooleanConfigurer ignoreGridBox;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer descOption;
        private static final String NORMAL = "normally";
        private static final String SHIFT = "when shift-key down";
        private static final String CTRL = "when ctrl/cmd key down";
        private static final String ALT = "when alt-key down";
        private static final String ALT_SHIFT = "when alt+shift keys down";
        private static final String NEVER = "never";
        private static final String SELECTED = "only if selected";
        private static final String[] SELECT_OPTIONS = new String[]{"normally", "when shift-key down", "when ctrl/cmd key down", "when alt-key down", "never"};
        private static final String[] SELECT_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.when_shift_key_down", "Editor.Immobilized.when_ctrl_key_down", "Editor.Immobilized.when_alt_key_down", "Editor.Immobilized.never"};
        private static final String[] BAND_SELECT_OPTIONS = new String[]{"normally", "when alt-key down", "when alt+shift keys down", "never"};
        private static final String[] BAND_SELECT_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.when_alt_key_down", "Editor.Immobilized.when_alt_shift_keys_down", "Editor.Immobilized.never"};
        private static final String[] MOVE_OPTIONS = new String[]{"normally", "only if selected", "never"};
        private static final String[] MOVE_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.only_if_selected", "Editor.Immobilized.never"};
        private static final String[] STACK_OPTIONS = new String[]{"normally", "never"};
        private static final String[] STACK_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.never"};

        public Ed(Immobilized p) {
            this.descOption = new StringConfigurer(p.description);
            this.descOption.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descOption);
            this.selectionOption = new TranslatingStringEnumConfigurer(SELECT_OPTIONS, SELECT_KEYS);
            if (p.neverSelect) {
                this.selectionOption.setValue(NEVER);
            } else if (p.altToSelect) {
                this.selectionOption.setValue(ALT);
            } else if (p.shiftToSelect) {
                this.selectionOption.setValue(SHIFT);
            } else if (p.ctrlToSelect) {
                this.selectionOption.setValue(CTRL);
            } else {
                this.selectionOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.select_piece", (Configurer)this.selectionOption);
            this.bandSelectOption = new TranslatingStringEnumConfigurer(BAND_SELECT_OPTIONS, BAND_SELECT_KEYS);
            if (p.neverBandSelect) {
                this.bandSelectOption.setValue(NEVER);
            } else if (p.altToBandSelect) {
                this.bandSelectOption.setValue(ALT);
            } else if (p.altShiftToBandSelect) {
                this.bandSelectOption.setValue(ALT_SHIFT);
            } else {
                this.bandSelectOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.band_select_piece", (Configurer)this.bandSelectOption);
            this.movementOption = new TranslatingStringEnumConfigurer(MOVE_OPTIONS, MOVE_KEYS);
            if (p.neverMove) {
                this.movementOption.setValue(NEVER);
            } else if (p.moveIfSelected) {
                this.movementOption.setValue(SELECTED);
            } else {
                this.movementOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.move_piece", (Configurer)this.movementOption);
            this.stackOption = new TranslatingStringEnumConfigurer(STACK_OPTIONS, STACK_KEYS);
            if (p.canStack) {
                this.stackOption.setValue(NORMAL);
            } else {
                this.stackOption.setValue(NEVER);
            }
            this.controls.add("Editor.Immobilized.stack_piece", (Configurer)this.stackOption);
            this.ignoreGridBox = new BooleanConfigurer(p.ignoreGrid);
            this.controls.add("Editor.Immobilized.ignore_map_grid_when_moving", (Configurer)this.ignoreGridBox);
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            Object s = Immobilized.ID;
            switch (this.selectionOption.getValueString()) {
                case "when shift-key down": {
                    s = (String)s + "i";
                    break;
                }
                case "when alt-key down": {
                    s = (String)s + "c";
                    break;
                }
                case "when ctrl/cmd key down": {
                    s = (String)s + "t";
                    break;
                }
                case "never": {
                    s = (String)s + "n";
                }
            }
            if (this.ignoreGridBox.getValueBoolean()) {
                s = (String)s + "g";
            }
            switch (this.bandSelectOption.getValueString()) {
                case "when alt-key down": {
                    s = (String)s + "A";
                    break;
                }
                case "when alt+shift keys down": {
                    s = (String)s + "B";
                    break;
                }
                case "never": {
                    s = (String)s + "Z";
                }
            }
            s = (String)s + ";";
            switch (this.movementOption.getValueString()) {
                case "normally": {
                    s = (String)s + "N";
                    break;
                }
                case "only if selected": {
                    s = (String)s + "I";
                    break;
                }
                case "never": {
                    s = (String)s + "V";
                }
            }
            s = (String)s + ";";
            switch (this.stackOption.getValueString()) {
                case "normally": {
                    s = (String)s + "L";
                    break;
                }
                case "never": {
                    s = (String)s + "R";
                }
            }
            s = (String)s + ";";
            s = (String)s + this.descOption.getValueString();
            return s;
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

