/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.LayerControl;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.HexGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.SquareGridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Marker;
import VASSAL.counters.UsePrototype;
import VASSAL.search.AbstractImageFinder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import VASSAL.tools.imports.adc2.SymbolSet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class MapBoard
extends Importer {
    private static final String PLACE_NAME = "Location Names";
    private static final java.util.Map<Integer, Font> defaultFonts = new HashMap<Integer, Font>();
    private static final int zoomLevel = 2;
    private static final String[] defaultFontNames = new String[]{"Courier", "Fixedsys", "MS Sans Serif", "MS Serif", "Impact", "Brush Script MT", "System", "Times New Roman", "Arial"};
    private static final String PLACE_NAMES = "Place Names";
    private final List<HexData> attributes = new ArrayList<HexData>();
    private String baseName;
    private Hex[] hexes;
    private final List<HexLine> hexLines = new ArrayList<HexLine>();
    private final List<HexSide> hexSides = new ArrayList<HexSide>();
    private Layout layout;
    private LineDefinition[] lineDefinitions;
    private List<MapLayer> mapElements = new ArrayList<MapLayer>();
    private final List<MapSheet> mapSheets = new ArrayList<MapSheet>();
    private final List<PlaceName> placeNames = new ArrayList<PlaceName>();
    private final List<HexData> placeSymbols = new ArrayList<HexData>();
    private final List<HexData> primaryMapBoardSymbols = new ArrayList<HexData>();
    private final List<HexData> secondaryMapBoardSymbols = new ArrayList<HexData>();
    private final List<MapBoardOverlay> overlaySymbol = new ArrayList<MapBoardOverlay>();
    private SymbolSet set;
    private int columns;
    private int rows;
    private Color tableColor;
    private boolean isPreV208 = true;
    private String path;
    private BoardPicker boardPicker;
    private final byte[] drawingPriorities = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    protected static Font getDefaultFont(int size, int font) {
        Integer key = (size << 8) + font;
        Font f = defaultFonts.get(key);
        if (f == null) {
            int fontIndex = font & 0xF;
            assert (fontIndex >= 1 && fontIndex <= 9);
            boolean isBold = (font & 0x10) > 0;
            boolean isItalic = (font & 0x20) > 0;
            boolean isUnderline = (font & 0x40) > 0;
            String fontName = defaultFontNames[fontIndex - 1];
            int fontStyle = 0;
            if (isItalic) {
                fontStyle |= 2;
            }
            if (isBold) {
                fontStyle |= 1;
            }
            f = new Font(fontName, fontStyle, size);
            if (isUnderline) {
                Hashtable<TextAttribute, Integer> hash = new Hashtable<TextAttribute, Integer>();
                hash.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                f = f.deriveFont(hash);
            }
            defaultFonts.put(key, f);
        }
        return f;
    }

    public MapBoard() {
        this.mapElements.add(new MapLayer(this.primaryMapBoardSymbols, "Primary MapBoard Symbols", false));
        this.mapElements.add(new MapLayer(this.secondaryMapBoardSymbols, "Secondary MapBoard Symbols", false));
        this.mapElements.add(new MapLayer(this.hexSides, "Hex Sides", true));
        this.mapElements.add(new MapLayer(this.hexLines, "Hex Lines", true));
        this.mapElements.add(new MapLayer(this.placeSymbols, "Place Symbols", false));
        this.mapElements.add(new MapLayer(this.attributes, "Attributes", false));
        this.mapElements.add(new MapLayer(this.overlaySymbol, "Overlay Symbol", true));
        this.mapElements.add(new MapLayer(this.placeNames, PLACE_NAMES, true));
    }

    protected void readScannedMapLayoutFile(File f, Graphics2D g) throws IOException {
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);
             BufferedInputStream bin = new BufferedInputStream(fin);
             DataInputStream in = new DataInputStream(bin);){
            int nSheets = ADC2Utils.readBase250Word(in);
            for (int i = 0; i < nSheets; ++i) {
                String name = MapBoard.stripExtension(MapBoard.readWindowsFileName(in));
                File file = this.action.getCaseInsensitiveFile(new File(name + "-L3.bmp"), new File(this.path), true, null);
                if (file == null) {
                    throw new FileNotFoundException("Unable to find map image.");
                }
                BufferedImage img = ImageIO.read(file);
                int x = 0;
                int y = 0;
                for (int j = 0; j < 3; ++j) {
                    int tempx = ADC2Utils.readBase250Integer(in);
                    int tempy = ADC2Utils.readBase250Integer(in);
                    if (j != 2) continue;
                    x = tempx;
                    y = tempy;
                }
                g.drawImage(img, null, x, y);
            }
        }
    }

    protected void readMapBoardOverlaySymbolBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "MapBoard Overlay Symbol");
        SymbolSet.SymbolData overlaySymbol = this.getSet().getMapBoardSymbol(ADC2Utils.readBase250Word(in));
        if (overlaySymbol != null) {
            this.overlaySymbol.add(new MapBoardOverlay(overlaySymbol));
        }
    }

    protected void readMapItemDrawFlagBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Map Item Draw Flag");
        ArrayList<MapLayer> elements = new ArrayList<MapLayer>(this.mapElements);
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[0]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[1]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[2]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[3]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[4]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[7]));
        }
        if (in.readByte() == 0) {
            this.mapElements.remove(elements.get(this.drawingPriorities[5]));
        }
    }

    protected void readAttributeBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Attribute Symbol");
        int nAttributes = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nAttributes; ++i) {
            int index = ADC2Utils.readBase250Word(in);
            SymbolSet.SymbolData symbol = this.set.getMapBoardSymbol(ADC2Utils.readBase250Word(in));
            if (!this.isOnMapBoard(index) || symbol == null) continue;
            this.attributes.add(new HexData(index, symbol));
        }
    }

    protected void readHexDataBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Hex Data");
        int count = this.getNColumns() * this.getNRows();
        for (int i = 0; i < count; ++i) {
            int symbolIndex = ADC2Utils.readBase250Word(in);
            SymbolSet.SymbolData symbol = this.getSet().getMapBoardSymbol(symbolIndex);
            if (symbol != null) {
                this.primaryMapBoardSymbols.add(new HexData(i, symbol));
            }
            symbolIndex = ADC2Utils.readBase250Word(in);
            symbol = this.getSet().getMapBoardSymbol(symbolIndex);
            if (symbol != null) {
                this.secondaryMapBoardSymbols.add(new HexData(i, symbol));
            }
            ADC2Utils.readBase250Word(in);
            in.readUnsignedByte();
        }
    }

    protected void readHexLineBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Hex Line");
        int nHexLines = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nHexLines; ++i) {
            int index = ADC2Utils.readBase250Word(in);
            int line = in.readUnsignedByte();
            int direction = in.readUnsignedShort();
            if (!this.isOnMapBoard(index)) continue;
            this.hexLines.add(new HexLine(index, line, direction));
        }
    }

    protected void readHexSideBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Hex Side");
        int nHexSides = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nHexSides; ++i) {
            int index = ADC2Utils.readBase250Word(in);
            int line = in.readUnsignedByte();
            int side = in.readUnsignedByte();
            if (!this.isOnMapBoard(index)) continue;
            this.hexSides.add(new HexSide(index, line, side));
        }
    }

    protected void readLineDefinitionBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Line Definition");
        int nLineDefinitions = in.readUnsignedByte();
        this.lineDefinitions = new LineDefinition[nLineDefinitions];
        for (int i = 0; i < nLineDefinitions; ++i) {
            LineStyle style;
            int colorIndex = in.readUnsignedByte();
            Color color = ADC2Utils.getColorFromIndex(colorIndex);
            byte size = 0;
            for (int j = 0; j < 3; ++j) {
                byte s = in.readByte();
                if (j != 2) continue;
                size = s;
            }
            MapBoard.readNullTerminatedString(in, 25);
            int styleByte = in.readUnsignedByte();
            switch (styleByte) {
                case 2: {
                    style = LineStyle.DOTTED;
                    break;
                }
                case 3: {
                    style = LineStyle.DASH_DOT;
                    break;
                }
                case 4: {
                    style = LineStyle.DASHED;
                    break;
                }
                case 5: {
                    style = LineStyle.DASH_DOT_DOT;
                    break;
                }
                default: {
                    style = LineStyle.SOLID;
                }
            }
            this.lineDefinitions[i] = size > 0 ? new LineDefinition(color, size, style) : null;
        }
    }

    protected void readLineDrawPriorityBlock(DataInputStream in) throws IOException {
        int index;
        int i;
        ADC2Utils.readBlockHeader(in, "Line Draw Priority");
        in.readByte();
        for (i = 1; i <= 10; ++i) {
            index = in.readUnsignedByte();
            if (index >= this.lineDefinitions.length || this.lineDefinitions[index] == null) continue;
            this.lineDefinitions[index].setHexLineDrawPriority(i);
        }
        for (i = 1; i <= 10; ++i) {
            index = in.readUnsignedByte();
            if (index >= this.lineDefinitions.length || this.lineDefinitions[index] == null) continue;
            this.lineDefinitions[index].setHexSideDrawPriority(i);
        }
    }

    protected void readMapSheetBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Map Sheet");
        int nMapSheets = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nMapSheets; ++i) {
            int x1 = ADC2Utils.readBase250Word(in);
            int y1 = ADC2Utils.readBase250Word(in);
            int x2 = ADC2Utils.readBase250Word(in);
            int y2 = ADC2Utils.readBase250Word(in);
            Rectangle r = new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
            String name = MapBoard.readNullTerminatedString(in, 10);
            if (name.length() < 9) {
                in.readFully(new byte[9 - name.length()]);
            }
            int style = in.readUnsignedByte();
            in.readFully(new byte[2]);
            int nColChars = in.readUnsignedByte();
            int nRowChars = in.readUnsignedByte();
            if (i >= nMapSheets - 1) continue;
            this.mapSheets.add(new MapSheet(name, r, style, nColChars, nRowChars));
        }
    }

    protected void readHexNumberingBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Hex Numbering");
        for (int i = 0; i < this.mapSheets.size() + 1; ++i) {
            int col = 0;
            for (int j = 0; j < 4; ++j) {
                col <<= 8;
                col += in.readUnsignedByte();
            }
            int row = 0;
            for (int j = 0; j < 4; ++j) {
                row <<= 8;
                row += in.readUnsignedByte();
            }
            if (i >= this.mapSheets.size()) continue;
            MapSheet ms = this.mapSheets.get(i);
            ms.setTopLeftCol(col);
            ms.setTopLeftRow(row);
        }
    }

    protected void readMapItemDrawingOrderBlock(DataInputStream in) throws IOException {
        int i;
        ADC2Utils.readBlockHeader(in, "Map Item Drawing Order");
        byte[] priority = new byte[10];
        in.readFully(priority);
        ArrayList<MapLayer> items = new ArrayList<MapLayer>(this.mapElements.size());
        for (i = 0; i < this.mapElements.size(); ++i) {
            if (priority[i] >= this.mapElements.size() || priority[i] < 0) {
                return;
            }
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    if (priority[j] != priority[i]) continue;
                    return;
                }
            }
            items.add(this.mapElements.get(priority[i]));
        }
        for (i = 0; i < this.mapElements.size(); ++i) {
            this.drawingPriorities[priority[i]] = (byte)i;
        }
        this.mapElements = items;
    }

    protected void readVersionBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "File Format Version");
        byte version = in.readByte();
        this.isPreV208 = version != 0;
    }

    protected void readTableColorBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Table Color");
        in.readByte();
        this.tableColor = ADC2Utils.getColorFromIndex(in.readUnsignedByte());
    }

    protected void readPlaceNameBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Place Name");
        int nNames = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nNames; ++i) {
            int index = ADC2Utils.readBase250Word(in);
            SymbolSet.SymbolData symbol = this.getSet().getMapBoardSymbol(ADC2Utils.readBase250Word(in));
            if (symbol != null && this.isOnMapBoard(index)) {
                this.placeSymbols.add(new HexData(index, symbol));
            }
            String text = MapBoard.readNullTerminatedString(in, 25);
            Color color = ADC2Utils.getColorFromIndex(in.readUnsignedByte());
            int size = 0;
            for (int z = 0; z < 3; ++z) {
                int b = in.readUnsignedByte();
                if (z != 2) continue;
                size = b;
            }
            PlaceNameOrientation orientation = null;
            block13: for (int z = 0; z < 3; ++z) {
                byte o = in.readByte();
                if (z != 2) continue;
                switch (o) {
                    case 1: {
                        orientation = PlaceNameOrientation.LOWER_CENTER;
                        continue block13;
                    }
                    case 2: {
                        orientation = PlaceNameOrientation.UPPER_CENTER;
                        continue block13;
                    }
                    case 3: {
                        orientation = PlaceNameOrientation.LOWER_RIGHT;
                        continue block13;
                    }
                    case 4: {
                        orientation = PlaceNameOrientation.UPPER_RIGHT;
                        continue block13;
                    }
                    case 5: {
                        orientation = PlaceNameOrientation.UPPER_LEFT;
                        continue block13;
                    }
                    case 6: {
                        orientation = PlaceNameOrientation.LOWER_LEFT;
                        continue block13;
                    }
                    case 7: {
                        orientation = PlaceNameOrientation.CENTER_LEFT;
                        continue block13;
                    }
                    case 8: {
                        orientation = PlaceNameOrientation.CENTER_RIGHT;
                        continue block13;
                    }
                    case 9: {
                        orientation = PlaceNameOrientation.HEX_CENTER;
                    }
                }
            }
            int font = in.readUnsignedByte();
            if (!this.isOnMapBoard(index) || text.length() == 0 || orientation == null) continue;
            this.placeNames.add(new PlaceName(index, text, color, orientation, size, font));
        }
    }

    boolean isOnMapBoard(int index) {
        return this.isOnMapBoard(index % this.columns, index / this.columns);
    }

    boolean isOnMapBoard(int x, int y) {
        return x >= 0 && x < this.columns && y >= 0 && y < this.rows;
    }

    protected Layout getLayout() {
        return this.layout;
    }

    protected LineDefinition getLineDefinition(int index) {
        if (index < 0 | index >= this.lineDefinitions.length) {
            return null;
        }
        return this.lineDefinitions[index];
    }

    int getNColumns() {
        return this.columns;
    }

    int getNRows() {
        return this.rows;
    }

    SymbolSet getSet() {
        return this.set;
    }

    @Override
    protected void load(File f) throws IOException {
        super.load(f);
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);
             BufferedInputStream bin = new BufferedInputStream(fin);
             DataInputStream in = new DataInputStream(bin);){
            this.baseName = MapBoard.stripExtension(f.getName());
            this.path = f.getPath();
            byte header = in.readByte();
            if (header != -3) {
                throw new FileFormatException("Invalid Mapboard File Header");
            }
            in.readFully(new byte[2]);
            String s = MapBoard.readWindowsFileName(in);
            String symbolSetFileName = MapBoard.forceExtension(s, "set");
            this.set = new SymbolSet();
            File setFile = this.action.getCaseInsensitiveFile(new File(symbolSetFileName), f, true, new ExtensionFileFilter("ADC2 Symbol Set", new String[]{".set"}));
            if (setFile == null) {
                throw new FileNotFoundException("Unable to find symbol set file.");
            }
            this.set.importFile(this.action, setFile);
            in.readByte();
            this.columns = ADC2Utils.readBase250Word(in);
            this.rows = ADC2Utils.readBase250Word(in);
            int hexSize = this.set.getMapBoardSymbolSize();
            this.readHexDataBlock(in);
            this.readPlaceNameBlock(in);
            this.readHexSideBlock(in);
            this.readLineDefinitionBlock(in);
            this.readAttributeBlock(in);
            this.readMapSheetBlock(in);
            this.readHexLineBlock(in);
            this.readLineDrawPriorityBlock(in);
            int orientation = in.read();
            switch (orientation) {
                case 0: 
                case 1: {
                    if (this.set.getMapBoardSymbolShape() == SymbolSet.Shape.SQUARE) {
                        this.layout = new GridOffsetColumnLayout(hexSize, this.columns, this.rows);
                        break;
                    }
                    this.layout = new VerticalHexLayout(hexSize, this.columns, this.rows);
                    break;
                }
                case 2: {
                    if (this.set.getMapBoardSymbolShape() == SymbolSet.Shape.SQUARE) {
                        this.layout = new GridOffsetRowLayout(hexSize, this.columns, this.rows);
                        break;
                    }
                    this.layout = new HorizontalHexLayout(hexSize, this.columns, this.rows);
                    break;
                }
                default: {
                    this.layout = new GridLayout(hexSize, this.columns, this.rows);
                }
            }
            in.readByte();
            in.readShort();
            in.readShort();
            in.readByte();
            this.readTableColorBlock(in);
            this.readHexNumberingBlock(in);
            try {
                this.readMapBoardOverlaySymbolBlock(in);
                this.readVersionBlock(in);
                this.readMapItemDrawingOrderBlock(in);
                this.readMapItemDrawFlagBlock(in);
            }
            catch (ADC2Utils.NoMoreBlocksException noMoreBlocksException) {
                // empty catch block
            }
        }
    }

    int getNFaces() {
        return this.getLayout().getNFaces();
    }

    Point getCenterOffset() {
        return this.getLayout().getOrigin();
    }

    Point coordinatesToPosition(int x, int y) {
        return this.getLayout().coordinatesToPosition(x, y, true);
    }

    Point indexToPosition(int index) {
        return this.getLayout().coordinatesToPosition(index % this.columns, index / this.columns, true);
    }

    Point indexToPosition(int index, boolean nullIfOffBoard) {
        return this.getLayout().coordinatesToPosition(index % this.columns, index / this.columns, nullIfOffBoard);
    }

    Point indexToCenterPosition(int index) {
        Point p = this.indexToPosition(index);
        if (p == null) {
            return p;
        }
        p.translate(this.getLayout().getDeltaX() / 2, this.getLayout().getDeltaY() / 2);
        return p;
    }

    @Override
    public void writeToArchive() throws IOException {
        Object under;
        Iterator<MapLayer> iter;
        GameModule module = GameModule.getGameModule();
        BaseLayer base = new BaseLayer();
        if (!base.hasBaseMap()) {
            iter = this.mapElements.iterator();
            while (iter.hasNext()) {
                base.overlay(iter.next());
                iter.remove();
            }
            this.mapElements.add(base);
        } else {
            this.mapElements.add(0, base);
            iter = this.mapElements.iterator();
            iter.next();
            while (iter.hasNext()) {
                MapLayer next = iter.next();
                if (next.isSwitchable()) continue;
                Iterator<MapLayer> iter2 = this.mapElements.iterator();
                under = iter2.next();
                while (under != next) {
                    ((MapLayer)under).overlay(next);
                    under = iter2.next();
                }
                iter.remove();
            }
            this.mapElements.add(0, base);
        }
        for (MapLayer layer : this.mapElements) {
            layer.writeToArchive();
        }
        this.getMainMap().setAttribute("moveWithinFormat", "$pieceName$ moving from [$previousLocation$] to [$location$]");
        this.getMainMap().setAttribute("moveToFormat", "$pieceName$ moving from [$previousLocation$] to [$location$]");
        this.getMainMap().setAttribute("createFormat", "$pieceName$ Added to [$location$]");
        AbstractConfigurable ac = this.getLayout().getGeometricGrid();
        if (this.mapSheets.size() == 1 && this.mapSheets.get(0) == null) {
            this.mapSheets.remove(0);
        }
        Board board = this.getBoard();
        if (!this.mapSheets.isEmpty()) {
            MapSheet ms;
            ZonedGrid zg = new ZonedGrid();
            under = this.mapSheets.iterator();
            while (under.hasNext() && (ms = (MapSheet)under.next()) != null) {
                Zone z = ms.getZone();
                if (z == null) continue;
                MapBoard.insertComponent(z, zg);
            }
            MapBoard.insertComponent(ac, zg);
            MapBoard.insertComponent(zg, board);
        } else {
            MapBoard.insertComponent(ac, board);
        }
        GlobalOptions options = module.getAllDescendantComponentsOf(GlobalOptions.class).toArray(new GlobalOptions[0])[0];
        options.setAttribute("autoReport", "Always");
        Zoomer zoom = new Zoomer();
        String[] s = new String[3];
        for (int i = 0; i < 3; ++i) {
            s[i] = Double.toString(this.set.getZoomFactor(i));
        }
        zoom.setAttribute("zoomLevels", StringArrayConfigurer.arrayToString(s));
        MapBoard.insertComponent(zoom, this.getMainMap());
        if (!this.placeNames.isEmpty()) {
            this.writePlaceNames(module);
        }
        Inventory inv = new Inventory();
        MapBoard.insertComponent(inv, module);
        inv.setAttribute("text", "Search");
        inv.setAttribute("tooltip", "Find place by name");
        inv.setAttribute("include", "CurrentMap = Main Map && Type != Layer");
        inv.setAttribute("icon", "");
        inv.setAttribute("groupBy", "Type");
    }

    protected void writePlaceNames(GameModule module) {
        PrototypesContainer container = module.getAllDescendantComponentsOf(PrototypesContainer.class).iterator().next();
        PrototypeDefinition def = new PrototypeDefinition();
        MapBoard.insertComponent(def, container);
        def.setConfigureName(PLACE_NAMES);
        AbstractImageFinder gp = new BasicPiece();
        SequenceEncoder se = new SequenceEncoder(',');
        se.append("Type");
        gp = new Marker("mark;" + se.getValue(), (GamePiece)((Object)gp));
        gp.setProperty("Type", PLACE_NAME);
        gp = new Immobilized("immob;n;V", (GamePiece)((Object)gp));
        def.setPiece((GamePiece)((Object)gp));
        this.getMainMap();
        Point offset = this.getCenterOffset();
        HashSet<String> set = new HashSet<String>();
        Board board = this.getBoard();
        for (PlaceName pn : this.placeNames) {
            String name = pn.getText();
            Point p = pn.getPosition();
            if (p == null || set.contains(name)) continue;
            set.add(name);
            SetupStack stack = new SetupStack();
            MapBoard.insertComponent(stack, this.getMainMap());
            p.translate(offset.x, offset.y);
            String location = this.getMainMap().locationName(p);
            stack.setAttribute("name", name);
            stack.setAttribute("owningBoard", board.getConfigureName());
            MapGrid mg = board.getGrid();
            Zone z = null;
            if (mg instanceof ZonedGrid) {
                z = ((ZonedGrid)mg).findZone(p);
            }
            stack.setAttribute("x", Integer.toString(p.x));
            stack.setAttribute("y", Integer.toString(p.y));
            if (z != null) {
                try {
                    if (mg.getLocation(location) != null) {
                        assert (mg.locationName(mg.getLocation(location)).equals(location));
                        stack.setAttribute("useGridLocation", true);
                        stack.setAttribute("location", location);
                    }
                }
                catch (MapGrid.BadCoords badCoords) {
                    // empty catch block
                }
            }
            BasicPiece bp = new BasicPiece();
            se = new SequenceEncoder("piece;", ';');
            se.append("").append("").append("").append(name);
            bp.mySetType(se.getValue());
            se = new SequenceEncoder("prototype;".replaceAll(";", ""), ';');
            se.append(PLACE_NAMES);
            gp = new UsePrototype(se.getValue(), bp);
            PieceSlot ps = new PieceSlot((GamePiece)((Object)gp));
            MapBoard.insertComponent(ps, stack);
        }
    }

    boolean isPreV208Layout() {
        return this.isPreV208;
    }

    Board getBoard() {
        BoardPicker picker = this.getBoardPicker();
        String[] boards = picker.getAllowableBoardNames();
        assert (boards.length <= 1);
        Board board = null;
        if (boards.length == 0) {
            board = new Board();
            MapBoard.insertComponent(board, picker);
        } else {
            board = picker.getBoard(boards[0]);
        }
        return board;
    }

    private ToolbarMenu getToolbarMenu() {
        List<ToolbarMenu> list = this.getMainMap().getComponentsOf(ToolbarMenu.class);
        ToolbarMenu menu = null;
        if (list.isEmpty()) {
            menu = new ToolbarMenu();
            MapBoard.insertComponent(menu, this.getMainMap());
            menu.setAttribute("text", "View");
            menu.setAttribute("tooltip", "Toggle visibility of map elements");
        } else {
            assert (list.size() == 1);
            menu = list.get(0);
        }
        return menu;
    }

    Color getTableColor() {
        return this.tableColor;
    }

    BoardPicker getBoardPicker() {
        if (this.boardPicker == null) {
            this.boardPicker = this.getMainMap().getAllDescendantComponentsOf(BoardPicker.class).toArray(new BoardPicker[0])[0];
        }
        return this.boardPicker;
    }

    @Override
    public boolean isValidImportFile(File f) throws IOException {
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            boolean bl;
            try (DataInputStream in = new DataInputStream(fin);){
                bl = in.readByte() == -3;
            }
            return bl;
        }
    }

    protected class MapLayer {
        private final List<? extends MapDrawable> elements;
        private final String name;
        private final boolean switchable;
        protected List<MapLayer> layers = null;
        protected String imageName;
        boolean shouldDraw = true;

        MapLayer(List<? extends MapDrawable> elements, String name, boolean switchable) {
            this.elements = elements;
            this.name = name;
            this.switchable = switchable;
        }

        void writeToArchive() throws IOException {
            Rectangle r = this.writeImageToArchive();
            if (this.imageName != null && r != null && r.width > 0 && r.height > 0) {
                SequenceEncoder se = new SequenceEncoder(';');
                se.append("").append("").append(this.imageName).append(this.getName());
                AbstractImageFinder gp = new BasicPiece("piece;" + se.getValue());
                gp = new Marker("mark;Layer", (GamePiece)((Object)gp));
                gp.setProperty("Layer", this.getName());
                gp = new Marker("mark;Type", (GamePiece)((Object)gp));
                gp.setProperty("Type", "Layer");
                gp = new Immobilized("immob;n;V", (GamePiece)((Object)gp));
                LayeredPieceCollection l = MapBoard.this.getLayeredPieceCollection();
                Object order = l.getAttributeValueString("layerOrder");
                order = ((String)order).equals("") ? this.getName() : (String)order + "," + this.getName();
                l.setAttribute("layerOrder", order);
                Map mainMap = MapBoard.this.getMainMap();
                Board board = MapBoard.this.getBoard();
                SetupStack stack = new SetupStack();
                MapBoard.insertComponent(stack, mainMap);
                Point p = new Point(r.x + r.width / 2, r.y + r.height / 2);
                stack.setAttribute("name", this.getName());
                stack.setAttribute("owningBoard", board.getConfigureName());
                stack.setAttribute("x", Integer.toString(p.x));
                stack.setAttribute("y", Integer.toString(p.y));
                PieceSlot slot = new PieceSlot((GamePiece)((Object)gp));
                MapBoard.insertComponent(slot, stack);
                if (this.isSwitchable()) {
                    LayerControl control = new LayerControl();
                    MapBoard.insertComponent(control, l);
                    control.setAttribute("text", this.getName());
                    control.setAttribute("tooltip", "Toggle " + this.getName().toLowerCase() + " visibility");
                    control.setAttribute("command", "Switch Layer between Active and Inactive");
                    control.setAttribute("layers", this.getName());
                    ToolbarMenu menu = MapBoard.this.getToolbarMenu();
                    Object entries = menu.getAttributeValueString("menuItems");
                    entries = ((String)entries).equals("") ? this.getName() : (String)entries + "," + new SequenceEncoder(this.getName(), ',').getValue();
                    menu.setAttribute("menuItems", entries);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Rectangle writeImageToArchive() throws IOException {
            BufferedImage image = this.getLayerImage();
            if (image == null) {
                return null;
            }
            Rectangle r = this.getCropRectangle(image);
            if (r.width == 0 || r.height == 0) {
                return null;
            }
            File f = Files.createTempFile(Info.getTempDir().toPath(), "map_", ".png", new FileAttribute[0]).toFile();
            try {
                ImageIO.write((RenderedImage)image.getSubimage(r.x, r.y, r.width, r.height), "png", f);
                this.imageName = Importer.getUniqueImageFileName(this.getName(), ".png");
                GameModule.getGameModule().getArchiveWriter().addImage(f.getPath(), this.imageName);
                Rectangle rectangle = r;
                return rectangle;
            }
            finally {
                FileUtils.forceDelete((File)f);
            }
        }

        protected Rectangle getCropRectangle(BufferedImage image) {
            int i;
            Rectangle r;
            block9: {
                r = new Rectangle(MapBoard.this.getLayout().getBoardSize());
                do {
                    for (i = r.y; i < r.y + r.height; ++i) {
                        if (image.getRGB(r.x, i) == 0) {
                            continue;
                        }
                        break block9;
                    }
                    ++r.x;
                    --r.width;
                } while (r.width != 0);
                r.height = 0;
                return r;
            }
            block2: while (true) {
                for (i = r.x; i < r.x + r.width; ++i) {
                    if (image.getRGB(i, r.y) != 0) break block2;
                }
                ++r.y;
                --r.height;
            }
            block4: while (true) {
                for (i = r.y; i < r.y + r.height; ++i) {
                    if (image.getRGB(r.x + r.width - 1, i) != 0) break block4;
                }
                --r.width;
            }
            block6: while (true) {
                for (i = r.x; i < r.x + r.width; ++i) {
                    if (image.getRGB(i, r.y + r.height - 1) != 0) break block6;
                }
                --r.height;
            }
            return r;
        }

        void overlay(MapLayer layer) {
            if (this.layers == null) {
                this.layers = new ArrayList<MapLayer>();
            }
            this.layers.add(layer);
        }

        protected AlphaComposite getComposite() {
            return AlphaComposite.SrcAtop;
        }

        BufferedImage getLayerImage() {
            Dimension d = MapBoard.this.getLayout().getBoardSize();
            BufferedImage image = new BufferedImage(d.width, d.height, 2);
            Graphics2D g = image.createGraphics();
            if (this.draw(g)) {
                if (this.layers != null) {
                    g.setComposite(this.getComposite());
                    for (MapLayer l : this.layers) {
                        l.draw(g);
                    }
                }
            } else {
                image = null;
            }
            return image;
        }

        boolean draw(Graphics2D g) {
            if (this.shouldDraw) {
                this.shouldDraw = false;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                for (MapDrawable mapDrawable : this.elements) {
                    if (!mapDrawable.draw(g)) continue;
                    this.shouldDraw = true;
                }
            }
            return this.shouldDraw;
        }

        boolean isSwitchable() {
            return this.switchable;
        }

        String getName() {
            return this.name;
        }

        boolean hasElements() {
            return !this.elements.isEmpty();
        }
    }

    protected class MapBoardOverlay
    extends HexData {
        @Override
        boolean draw(Graphics2D g) {
            if (this.symbol != null) {
                for (int y = 0; y < MapBoard.this.getNRows(); ++y) {
                    for (int x = 0; x < MapBoard.this.getNColumns(); ++x) {
                        Point p = MapBoard.this.coordinatesToPosition(x, y);
                        g.drawImage(this.symbol.getImage(), null, p.x, p.y);
                    }
                }
                return true;
            }
            return false;
        }

        MapBoardOverlay(SymbolSet.SymbolData symbol) {
            super(-1, symbol);
        }
    }

    protected class HexData
    extends MapDrawable {
        final SymbolSet.SymbolData symbol;

        HexData(int index, SymbolSet.SymbolData symbol) {
            super(index);
            assert (symbol != null);
            this.symbol = symbol;
        }

        @Override
        boolean draw(Graphics2D g) {
            Point p = this.getPosition();
            if (this.symbol != null && !this.symbol.isTransparent()) {
                g.drawImage(this.symbol.getImage(), null, p.x, p.y);
                return true;
            }
            return false;
        }
    }

    protected class HexLine
    extends Line {
        private final int direction;

        HexLine(int index, int line, int direction) {
            super(index, line);
            this.direction = direction;
        }

        @Override
        int compare(LineDefinition o1, LineDefinition o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int priority = o1.getHexLineDrawPriority() - o2.getHexLineDrawPriority();
            if (priority != 0) {
                return priority;
            }
            return super.compare(o1, o2);
        }

        @Override
        boolean draw(Graphics2D g) {
            LineDefinition l = this.getLine();
            boolean result = false;
            if (l != null) {
                result = true;
                Point pos = this.getPosition();
                int size = MapBoard.this.getLayout().getHexSize();
                pos.translate(size / 2, size / 2);
                Layout lo = MapBoard.this.getLayout();
                if ((this.direction & 6) > 0) {
                    Point nw = lo.getNorthWest(this.hexIndex);
                    nw.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + nw.x) / 2.0f, (float)(pos.y + nw.y) / 2.0f);
                }
                if ((this.direction & 8) > 0) {
                    Point w = lo.getWest(this.hexIndex);
                    w.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + w.x) / 2.0f, (float)(pos.y + w.y) / 2.0f);
                }
                if ((this.direction & 0x30) > 0) {
                    Point sw = lo.getSouthWest(this.hexIndex);
                    sw.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + sw.x) / 2.0f, (float)(pos.y + sw.y) / 2.0f);
                }
                if ((this.direction & 0x80) > 0) {
                    Point s = lo.getSouth(this.hexIndex);
                    s.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + s.x) / 2.0f, (float)(pos.y + s.y) / 2.0f);
                }
                if ((this.direction & 0x100) > 0) {
                    Point n = lo.getNorth(this.hexIndex);
                    n.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + n.x) / 2.0f, (float)(pos.y + n.y) / 2.0f);
                }
                if ((this.direction & 0xC00) > 0) {
                    Point ne = lo.getNorthEast(this.hexIndex);
                    ne.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + ne.x) / 2.0f, (float)(pos.y + ne.y) / 2.0f);
                }
                if ((this.direction & 0x1000) > 0) {
                    Point e = lo.getEast(this.hexIndex);
                    e.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + e.x) / 2.0f, (float)(pos.y + e.y) / 2.0f);
                }
                if ((this.direction & 0x6000) > 0) {
                    Point se = lo.getSouthEast(this.hexIndex);
                    se.translate(size / 2, size / 2);
                    l.addLine(pos.x, pos.y, (float)(pos.x + se.x) / 2.0f, (float)(pos.y + se.y) / 2.0f);
                }
            }
            if (this == MapBoard.this.hexLines.get(MapBoard.this.hexLines.size() - 1)) {
                this.drawLines(g, 0);
            }
            return result;
        }

        @Override
        List<Line> getLineList(Hex h) {
            return h.hexLines;
        }
    }

    protected class HexSide
    extends Line {
        private final int side;

        HexSide(int index, int line, int side) {
            super(index, line);
            this.side = side;
        }

        @Override
        int compare(LineDefinition o1, LineDefinition o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int priority = o1.getHexSideDrawPriority() - o2.getHexSideDrawPriority();
            if (priority != 0) {
                return priority;
            }
            return super.compare(o1, o2);
        }

        @Override
        boolean draw(Graphics2D g) {
            LineDefinition l = this.getLine();
            boolean result = false;
            if (l != null) {
                Point sw;
                result = true;
                Point p = this.getPosition();
                int size = MapBoard.this.getLayout().getHexSize();
                int dX = MapBoard.this.getLayout().getDeltaX();
                int dY = MapBoard.this.getLayout().getDeltaY();
                if ((this.side & 1) > 0) {
                    sw = MapBoard.this.getLayout().getSouthWest(this.hexIndex);
                    sw.translate(dX, 0);
                    Point s = MapBoard.this.getLayout().getSouth(this.hexIndex);
                    l.addLine(p.x, sw.y, p.x + size / 5, s.y);
                }
                if ((this.side & 2) > 0) {
                    sw = MapBoard.this.getLayout().getSouthWest(this.hexIndex);
                    sw.translate(dX, 0);
                    l.addLine(p.x, sw.y, p.x + size / 5, p.y);
                }
                if ((this.side & 4) > 0) {
                    l.addLine(p.x + size / 5, p.y, p.x + dX, p.y);
                }
                if ((this.side & 8) > 0) {
                    Point se = MapBoard.this.getLayout().getSouthEast(this.hexIndex);
                    l.addLine(p.x, p.y + dY, se.x, p.y + dY + size / 5);
                }
                if ((this.side & 0x10) > 0) {
                    l.addLine(p.x, p.y + size / 5, p.x, p.y + dY);
                }
                if ((this.side & 0x20) > 0) {
                    Point ne = MapBoard.this.getLayout().getNorthEast(this.hexIndex);
                    l.addLine(p.x, p.y + size / 5, ne.x, p.y);
                }
                if ((this.side & 0x40) > 0) {
                    l.addLine(p.x, p.y, p.x, p.y + dY);
                }
                if ((this.side & 0x80) > 0) {
                    l.addLine(p.x, p.y, p.x + dX, p.y);
                }
            }
            if (this == MapBoard.this.hexSides.get(MapBoard.this.hexSides.size() - 1)) {
                this.drawLines(g, 1);
            }
            return result;
        }

        @Override
        List<Line> getLineList(Hex h) {
            return h.hexSides;
        }
    }

    protected static class LineDefinition {
        private final Color color;
        private int hexLineDrawPriority;
        private int hexSideDrawPriority;
        private final List<List<Point2D.Float>> points = new ArrayList<List<Point2D.Float>>();
        private final int size;
        private final LineStyle style;

        LineDefinition(Color color, int size, LineStyle style) {
            this.color = color;
            this.size = size;
            this.style = style;
        }

        private void setHexLineDrawPriority(int priority) {
            if (this.hexLineDrawPriority == 0) {
                this.hexLineDrawPriority = priority;
            }
        }

        private void setHexSideDrawPriority(int priority) {
            if (this.hexSideDrawPriority == 0) {
                this.hexSideDrawPriority = priority;
            }
        }

        Color getColor() {
            return this.color;
        }

        BasicStroke getStroke(int cap) {
            if (this.size <= 0 || this.style == null) {
                return null;
            }
            return this.style.getStroke(this.size, cap);
        }

        void addLine(float x1, float y1, float x2, float y2) {
            this.addLine(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2));
        }

        void addLine(int x1, int y1, float x2, float y2) {
            this.addLine(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2));
        }

        void addLine(int x1, int y1, int x2, int y2) {
            this.addLine(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2));
        }

        void addLine(Point2D.Float a, Point2D.Float b) {
            for (int i = 0; i < this.points.size(); ++i) {
                int j;
                List<Point2D.Float> lineA = this.points.get(i);
                if (a.equals(lineA.get(0))) {
                    if (b.equals(lineA.get(1))) {
                        return;
                    }
                    for (j = 0; j < this.points.size(); ++j) {
                        if (i == j) continue;
                        List<Point2D.Float> lineB = this.points.get(j);
                        if (b.equals(lineB.get(0))) {
                            if (lineA.size() < lineB.size()) {
                                for (Point2D.Float aFloat : lineA) {
                                    lineB.add(0, aFloat);
                                }
                                this.points.remove(i);
                            } else {
                                for (Point2D.Float aFloat : lineB) {
                                    lineA.add(0, aFloat);
                                }
                                this.points.remove(j);
                            }
                            return;
                        }
                        if (!b.equals(lineB.get(lineB.size() - 1))) continue;
                        lineB.addAll(lineA);
                        this.points.remove(i);
                        return;
                    }
                    lineA.add(0, b);
                    return;
                }
                if (a.equals(lineA.get(lineA.size() - 1))) {
                    if (b.equals(lineA.get(lineA.size() - 2))) {
                        return;
                    }
                    for (j = 0; j < this.points.size(); ++j) {
                        if (i == j) continue;
                        List<Point2D.Float> lineB = this.points.get(j);
                        if (b.equals(lineB.get(0))) {
                            lineA.addAll(lineB);
                            this.points.remove(j);
                            return;
                        }
                        if (!b.equals(lineB.get(lineB.size() - 1))) continue;
                        if (lineA.size() < lineB.size()) {
                            for (int k = lineA.size() - 1; k >= 0; --k) {
                                lineB.add(lineA.get(k));
                            }
                            this.points.remove(i);
                        } else {
                            for (int k = lineB.size() - 1; k >= 0; --k) {
                                lineA.add(lineB.get(k));
                            }
                            this.points.remove(j);
                        }
                        return;
                    }
                    lineA.add(b);
                    return;
                }
                for (j = 1; j < lineA.size() - 1; ++j) {
                    if (!a.equals(lineA.get(j)) || !b.equals(lineA.get(j - 1)) && !b.equals(lineA.get(j + 1))) continue;
                    return;
                }
            }
            for (List<Point2D.Float> line : this.points) {
                if (b.equals(line.get(0))) {
                    if (a.equals(line.get(1))) {
                        return;
                    }
                    line.add(0, a);
                    return;
                }
                if (!b.equals(line.get(line.size() - 1))) continue;
                if (a.equals(line.get(line.size() - 2))) {
                    return;
                }
                line.add(a);
                return;
            }
            ArrayList<Point2D.Float> newLine = new ArrayList<Point2D.Float>(2);
            newLine.add(a);
            newLine.add(b);
            this.points.add(newLine);
        }

        void clearPoints() {
            this.points.clear();
        }

        void draw(Graphics2D g, int cap) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = this.getStroke(cap);
            if (stroke == null) {
                return;
            }
            g.setStroke(stroke);
            g.setColor(this.getColor());
            GeneralPath gp = new GeneralPath(0);
            for (List<Point2D.Float> line : this.points) {
                gp.moveTo(line.get((int)0).x, line.get((int)0).y);
                for (Point2D.Float p : line) {
                    if (!p.equals(line.get(0))) {
                        gp.lineTo(p.x, p.y);
                        continue;
                    }
                    if (p == line.get(0)) continue;
                    gp.closePath();
                }
            }
            g.draw(gp);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        int getHexLineDrawPriority() {
            return this.hexLineDrawPriority;
        }

        int getHexSideDrawPriority() {
            return this.hexSideDrawPriority;
        }
    }

    protected static enum LineStyle {
        DASH_DOT(new float[]{12.0f, 8.0f, 4.0f, 8.0f}),
        DASH_DOT_DOT(new float[]{12.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f}),
        DASHED(new float[]{12.0f, 8.0f}),
        DOTTED(new float[]{4.0f, 4.0f}),
        SOLID(null);

        private final float[] dash;

        private LineStyle(float[] dash) {
            this.dash = dash;
        }

        BasicStroke getStroke(int size, int cap) {
            if (this.dash == null) {
                return new BasicStroke(size, cap, 1);
            }
            return new BasicStroke(size, 0, 1, 0.0f, this.dash, 0.0f);
        }
    }

    protected class MapSheet {
        private int topLeftCol;
        private int topLeftRow;
        private final Rectangle field;
        private final String name;
        private final int nColChars;
        private final int nRowChars;
        private final int style;
        private Zone zone;

        MapSheet(String name, Rectangle playingFieldPosition, int style, int nColChars, int nRowChars) {
            this.name = name;
            this.field = playingFieldPosition;
            this.style = style;
            this.nColChars = nColChars;
            this.nRowChars = nRowChars;
        }

        Rectangle getField() {
            return this.field;
        }

        String getName() {
            return this.name;
        }

        int getNColChars() {
            return this.nColChars;
        }

        int getNRowChars() {
            return this.nRowChars;
        }

        String getRectangleAsString() {
            Rectangle r = MapBoard.this.getLayout().getRectangle(this);
            if (r == null) {
                return null;
            }
            return r.x + "," + r.y + ";" + (r.x + r.width - 1) + "," + r.y + ";" + (r.x + r.width - 1) + "," + (r.y + r.height - 1) + ";" + r.x + "," + (r.y + r.height - 1);
        }

        boolean alphaCols() {
            return !this.numericCols();
        }

        boolean alphaRows() {
            return !this.numericRows();
        }

        boolean colsAndRows() {
            return (this.style & 2) > 0;
        }

        boolean colsIncreaseLeft() {
            return !this.colsIncreaseRight();
        }

        boolean colsIncreaseRight() {
            return (this.style & 0x10) > 0;
        }

        boolean firstHexDown() {
            return (this.style & 0x40) > 0 && MapBoard.this.getLayout() instanceof VerticalLayout;
        }

        boolean firstHexLeft() {
            return (this.style & 0x40) > 0 && MapBoard.this.getLayout() instanceof HorizontalLayout;
        }

        boolean firstHexRight() {
            return (this.style & 0x40) == 0 && MapBoard.this.getLayout() instanceof HorizontalLayout;
        }

        boolean firstHexUp() {
            return (this.style & 0x40) == 0 && MapBoard.this.getLayout() instanceof VerticalLayout;
        }

        RegularGridNumbering getGridNumbering() {
            RegularGridNumbering gn = MapBoard.this.getLayout().getGridNumbering();
            MapBoard.this.getLayout().initGridNumbering(gn, this);
            return gn;
        }

        Zone getZone() {
            if (this.zone == null) {
                this.zone = new Zone();
                this.zone.setConfigureName(this.getName());
                String rect = this.getRectangleAsString();
                if (rect == null) {
                    return null;
                }
                this.zone.setAttribute("path", rect);
                this.zone.setAttribute("locationFormat", "$name$ $gridLocation$");
                AbstractConfigurable mg = MapBoard.this.getLayout().getGeometricGrid();
                RegularGridNumbering gn = this.getGridNumbering();
                MapBoard.insertComponent(gn, mg);
                MapBoard.insertComponent(mg, this.zone);
                MapBoard.this.getLayout().setGridNumberingOffsets(gn, this);
            }
            return this.zone;
        }

        boolean numericCols() {
            return (this.style & 4) > 0;
        }

        boolean numericRows() {
            return (this.style & 8) > 0;
        }

        boolean rowsAndCols() {
            return !this.colsAndRows();
        }

        boolean rowsIncreaseDown() {
            return (this.style & 0x20) > 0;
        }

        boolean rowsIncreaseUp() {
            return !this.rowsIncreaseDown();
        }

        int getTopLeftCol() {
            return this.topLeftCol;
        }

        void setTopLeftCol(int topLeftCol) {
            this.topLeftCol = topLeftCol;
        }

        int getTopLeftRow() {
            return this.topLeftRow;
        }

        void setTopLeftRow(int topLeftRow) {
            this.topLeftRow = topLeftRow;
        }
    }

    protected static enum PlaceNameOrientation {
        CENTER_LEFT,
        CENTER_RIGHT,
        HEX_CENTER,
        LOWER_CENTER,
        LOWER_LEFT,
        LOWER_RIGHT,
        UPPER_CENTER,
        UPPER_LEFT,
        UPPER_RIGHT;

    }

    protected class PlaceName
    extends MapDrawable {
        private final Color color;
        private final int font;
        private final PlaceNameOrientation orientation;
        private final int size;
        private final String text;

        PlaceName(int index, String text, Color color, PlaceNameOrientation orientation, int size, int font) {
            super(index);
            this.text = text;
            assert (color != null);
            this.color = color;
            assert (orientation != null);
            this.orientation = orientation;
            this.size = size;
            int fontIndex = (font &= 0x7F) & 0xF;
            if (fontIndex < 1 || fontIndex > 9) {
                fontIndex = 9;
                font = font & 0xF0 | fontIndex;
            }
            this.font = font;
        }

        Font getFont() {
            int size = this.getSize();
            return size == 0 ? null : MapBoard.getDefaultFont(this.getSize(), this.font);
        }

        Point getPosition(Graphics2D g) {
            Point p = this.getPosition();
            if (this.getSize() == 0) {
                return p;
            }
            assert (g.getFont() == this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int size = MapBoard.this.getLayout().getHexSize();
            switch (this.orientation.ordinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    p.x += size / 2;
                    break;
                }
                case 1: {
                    p.x += size;
                    break;
                }
            }
            switch (this.orientation.ordinal()) {
                case 2: 
                case 3: 
                case 6: {
                    p.x -= fm.charsWidth(this.text.toCharArray(), 0, this.text.length()) / 2;
                    break;
                }
                case 0: 
                case 4: 
                case 7: {
                    p.x -= fm.charsWidth(this.text.toCharArray(), 0, this.text.length());
                    break;
                }
            }
            switch (this.orientation.ordinal()) {
                case 3: 
                case 4: 
                case 5: {
                    p.y += size + fm.getAscent();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    p.y -= fm.getDescent();
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    p.y += size / 2 + fm.getHeight() / 2 - fm.getDescent();
                }
            }
            return p;
        }

        int getSize() {
            return this.size <= 5 ? 0 : (this.size + 1) * 4 / 3 - 1;
        }

        @Override
        boolean draw(Graphics2D g) {
            if (this.getSize() != 0) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setFont(this.getFont());
                g.setColor(this.color);
                Point p = this.getPosition(g);
                g.drawString(this.text, p.x, p.y);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                return true;
            }
            return false;
        }

        String getText() {
            return this.text;
        }
    }

    protected abstract class Layout {
        protected final int nColumns;
        protected final int nRows;
        private final int size;

        Layout(int size, int columns, int rows) {
            this.size = size;
            this.nColumns = columns;
            this.nRows = rows;
        }

        protected int getRow(int index) {
            return index / this.nColumns;
        }

        protected int getCol(int index) {
            return index % this.nColumns;
        }

        void constrainRectangle(Point upperLeft, Point lowerRight) {
            if (upperLeft.x < 0) {
                upperLeft.x = 0;
            }
            if (upperLeft.y < 0) {
                upperLeft.y = 0;
            }
            Dimension d = this.getBoardSize();
            if (lowerRight.x >= d.width) {
                lowerRight.x = d.width - 1;
            }
            if (lowerRight.y >= d.height) {
                lowerRight.y = d.height - 1;
            }
        }

        abstract int getNFaces();

        void initGridNumbering(RegularGridNumbering numbering, MapSheet sheet) {
            numbering.setAttribute("first", sheet.colsAndRows() ? "H" : "V");
            numbering.setAttribute("hType", sheet.numericCols() ? "N" : "A");
            numbering.setAttribute("hLeading", sheet.getNColChars() - 1);
            numbering.setAttribute("hDescend", sheet.colsIncreaseLeft());
            numbering.setAttribute("hDescend", sheet.colsIncreaseLeft());
            numbering.setAttribute("vType", sheet.numericRows() ? "N" : "A");
            numbering.setAttribute("vLeading", sheet.getNRowChars() - 1);
            numbering.setAttribute("vDescend", sheet.rowsIncreaseUp());
        }

        void setGridNumberingOffsets(RegularGridNumbering numbering, MapSheet sheet) {
            Point position = this.coordinatesToPosition(sheet.getField().x, sheet.getField().y, true);
            position.translate(this.getDeltaX() / 2, this.getDeltaY() / 2);
            int rowOffset = numbering.getRow(position);
            int colOffset = numbering.getColumn(position);
            rowOffset = -rowOffset + sheet.getTopLeftRow();
            colOffset = -colOffset + sheet.getTopLeftCol();
            numbering.setAttribute("hOff", colOffset);
            numbering.setAttribute("vOff", rowOffset);
        }

        abstract RegularGridNumbering getGridNumbering();

        abstract Point coordinatesToPosition(int var1, int var2, boolean var3);

        abstract Dimension getBoardSize();

        abstract int getDeltaX();

        abstract int getDeltaY();

        Point getEast(int index) {
            int row = this.getRow(index);
            int col = this.getCol(index) + 1;
            return this.coordinatesToPosition(col, row, false);
        }

        abstract AbstractConfigurable getGeometricGrid();

        Point getNorth(int index) {
            int row = this.getRow(index) - 1;
            int col = this.getCol(index);
            return this.coordinatesToPosition(col, row, false);
        }

        Point getNorthEast(int index) {
            int row = this.getRow(index) - 1;
            int col = this.getCol(index) + 1;
            return this.coordinatesToPosition(col, row, false);
        }

        Point getNorthWest(int index) {
            int row = this.getRow(index) - 1;
            int col = this.getCol(index) - 1;
            return this.coordinatesToPosition(col, row, false);
        }

        abstract Point getOrigin();

        abstract Rectangle getRectangle(MapSheet var1);

        int getHexSize() {
            return this.size;
        }

        Point getSouth(int index) {
            int row = this.getRow(index) + 1;
            int col = this.getCol(index);
            return this.coordinatesToPosition(col, row, false);
        }

        Point getSouthEast(int index) {
            int row = this.getRow(index) + 1;
            int col = this.getCol(index) + 1;
            return MapBoard.this.getLayout().coordinatesToPosition(col, row, false);
        }

        Point getSouthWest(int index) {
            int row = this.getRow(index) + 1;
            int col = this.getCol(index) - 1;
            return this.coordinatesToPosition(col, row, false);
        }

        Point getWest(int index) {
            int row = this.getRow(index);
            int col = this.getCol(index) - 1;
            return this.coordinatesToPosition(col, row, false);
        }
    }

    protected class GridOffsetColumnLayout
    extends VerticalLayout {
        GridOffsetColumnLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        Dimension getBoardSize() {
            Dimension d = new Dimension();
            d.width = this.getDeltaX() * this.nColumns + 1;
            d.height = this.getDeltaY() * this.nRows + this.getHexSize() / 2 + 1;
            return d;
        }

        @Override
        int getDeltaX() {
            return this.getHexSize();
        }

        @Override
        int getDeltaY() {
            return this.getHexSize();
        }

        @Override
        Point getOrigin() {
            return new Point(this.getHexSize() * 7 / 12, this.getHexSize() / 2);
        }

        @Override
        AbstractConfigurable getGeometricGrid() {
            HexGrid mg = new HexGrid();
            mg.setOrigin(this.getOrigin());
            mg.setDx(this.getDeltaX());
            mg.setDy(this.getDeltaY());
            return mg;
        }
    }

    protected class VerticalHexLayout
    extends VerticalLayout {
        VerticalHexLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        Dimension getBoardSize() {
            Dimension d = new Dimension();
            d.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 5 + 1;
            d.height = this.getDeltaY() * this.nRows + this.getHexSize() / 2 + 1;
            return d;
        }

        @Override
        int getDeltaX() {
            return this.getHexSize() * 4 / 5 - (MapBoard.this.isPreV208Layout() ? 1 : 0);
        }

        @Override
        int getDeltaY() {
            return this.getHexSize() - (MapBoard.this.isPreV208Layout() ? 2 : 1);
        }

        @Override
        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2 - (MapBoard.this.isPreV208Layout() ? 1 : 0));
        }

        @Override
        HexGrid getGeometricGrid() {
            HexGrid mg = new HexGrid();
            mg.setOrigin(this.getOrigin());
            mg.setDx(this.getDeltaX());
            mg.setDy(this.getDeltaY());
            return mg;
        }
    }

    protected class GridOffsetRowLayout
    extends HorizontalLayout {
        GridOffsetRowLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        Dimension getBoardSize() {
            Dimension d = new Dimension();
            d.height = this.getDeltaY() * this.nRows + 1;
            d.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 2 + 1;
            return d;
        }

        @Override
        int getDeltaX() {
            return this.getHexSize();
        }

        @Override
        int getDeltaY() {
            return this.getHexSize();
        }

        @Override
        Point getOrigin() {
            return new Point(this.getHexSize() * 7 / 12, this.getHexSize() / 2);
        }

        @Override
        AbstractConfigurable getGeometricGrid() {
            HexGrid mg = new HexGrid();
            mg.setSideways(true);
            mg.setOrigin(this.getOrigin());
            mg.setDx(this.getDeltaY());
            mg.setDy(this.getDeltaX());
            return mg;
        }
    }

    protected class HorizontalHexLayout
    extends HorizontalLayout {
        HorizontalHexLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        Dimension getBoardSize() {
            Dimension d = new Dimension();
            d.width = this.getDeltaX() * this.nColumns + this.getHexSize() / 2;
            d.height = this.getDeltaY() * this.nRows + this.getHexSize() / 5 + 1;
            return d;
        }

        @Override
        int getDeltaX() {
            return this.getHexSize() - (MapBoard.this.isPreV208Layout() ? 2 : 0);
        }

        @Override
        int getDeltaY() {
            return this.getHexSize() * 4 / 5 - 1;
        }

        @Override
        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2 - (MapBoard.this.isPreV208Layout() ? 1 : 0));
        }

        @Override
        HexGrid getGeometricGrid() {
            HexGrid mg = new HexGrid();
            mg.setSideways(true);
            mg.setOrigin(this.getOrigin());
            mg.setDy(this.getDeltaX());
            mg.setDx(this.getDeltaY());
            return mg;
        }
    }

    protected class GridLayout
    extends Layout {
        GridLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        Point coordinatesToPosition(int x, int y, boolean nullIfOffBoard) {
            if (!nullIfOffBoard || MapBoard.this.isOnMapBoard(x, y)) {
                int xx = this.getDeltaX() * x;
                int yy = this.getDeltaY() * y;
                return new Point(xx, yy);
            }
            return null;
        }

        @Override
        Dimension getBoardSize() {
            Dimension d = new Dimension();
            d.width = this.getDeltaX() * this.nColumns;
            d.height = this.getDeltaY() * this.nRows;
            return d;
        }

        @Override
        int getDeltaX() {
            return this.getHexSize();
        }

        @Override
        int getDeltaY() {
            return this.getHexSize();
        }

        @Override
        Point getOrigin() {
            return new Point(this.getHexSize() / 2, this.getHexSize() / 2);
        }

        @Override
        SquareGrid getGeometricGrid() {
            SquareGrid grid = new SquareGrid();
            grid.setOrigin(this.getOrigin());
            grid.setDx(this.getDeltaX());
            grid.setDy(this.getDeltaY());
            return grid;
        }

        @Override
        Rectangle getRectangle(MapSheet map) {
            Rectangle r = map.getField();
            Point upperLeft = this.coordinatesToPosition(r.x, r.y, false);
            Point lowerRight = this.coordinatesToPosition(r.x + r.width - 1, r.y + r.height - 1, false);
            lowerRight.x += this.getHexSize() - 1;
            lowerRight.y += this.getHexSize() - 1;
            this.constrainRectangle(upperLeft, lowerRight);
            return new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x - upperLeft.x + 1, lowerRight.y - upperLeft.y + 1);
        }

        @Override
        RegularGridNumbering getGridNumbering() {
            return new SquareGridNumbering();
        }

        @Override
        int getNFaces() {
            return 4;
        }
    }

    class BaseLayer
    extends MapLayer {
        BaseLayer() {
            super(null, "Base Layer", false);
        }

        boolean hasBaseMap() {
            File underlay = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.forceExtension(MapBoard.this.path, "sml")), null, false, null);
            if (underlay == null) {
                underlay = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.stripExtension(MapBoard.this.path) + "-Z3.bmp"), null, false, null);
            }
            return underlay != null;
        }

        @Override
        boolean draw(Graphics2D g) {
            g.setBackground(MapBoard.this.tableColor);
            Dimension d = MapBoard.this.getLayout().getBoardSize();
            g.clearRect(0, 0, d.width, d.height);
            File sml = MapBoard.this.action.getCaseInsensitiveFile(new File(Importer.forceExtension(MapBoard.this.path, "sml")), null, false, null);
            if (sml != null) {
                try {
                    MapBoard.this.readScannedMapLayoutFile(sml, g);
                }
                catch (IOException iOException) {}
            } else if (MapBoard.this.getSet().underlay != null) {
                g.drawImage(MapBoard.this.getSet().underlay, null, 0, 0);
            }
            return true;
        }

        @Override
        void writeToArchive() throws IOException {
            this.writeImageToArchive();
            assert (this.imageName != null);
            Board board = MapBoard.this.getBoard();
            board.setAttribute("image", this.imageName);
            board.setConfigureName(MapBoard.this.baseName);
            MapBoard.this.getMainMap().setBoards(Collections.singleton(board));
        }

        @Override
        protected Rectangle getCropRectangle(BufferedImage image) {
            return new Rectangle(MapBoard.this.getLayout().getBoardSize());
        }

        @Override
        protected AlphaComposite getComposite() {
            return AlphaComposite.SrcOver;
        }
    }

    protected abstract class VerticalLayout
    extends Layout {
        @Override
        int getNFaces() {
            return 6;
        }

        VerticalLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        HexGridNumbering getGridNumbering() {
            return new HexGridNumbering();
        }

        @Override
        void initGridNumbering(RegularGridNumbering numbering, MapSheet sheet) {
            boolean stagger = false;
            if (sheet.firstHexDown() && (sheet.getField().x & 1) == 1) {
                stagger = true;
            } else if (sheet.firstHexUp() && sheet.getField().x % 2 == 0) {
                stagger = true;
            }
            numbering.setAttribute("stagger", stagger);
            super.initGridNumbering(numbering, sheet);
        }

        @Override
        Point coordinatesToPosition(int x, int y, boolean nullIfOffBoard) {
            if (nullIfOffBoard && !MapBoard.this.isOnMapBoard(x, y)) {
                return null;
            }
            int xx = this.getDeltaX() * x;
            int yy = this.getDeltaY() * y + x % 2 * this.getDeltaY() / 2;
            return new Point(xx, yy);
        }

        @Override
        Point getNorthEast(int index) {
            int col = this.getCol(index) + 1;
            int row = this.getRow(index) - Math.abs(col) % 2;
            return this.coordinatesToPosition(col, row, false);
        }

        @Override
        Point getNorthWest(int index) {
            int col = this.getCol(index) - 1;
            int row = this.getRow(index) - Math.abs(col) % 2;
            return this.coordinatesToPosition(col, row, false);
        }

        @Override
        Rectangle getRectangle(MapSheet map) {
            Rectangle r = map.getField();
            if (r.width <= 0 || r.height <= 0) {
                return null;
            }
            Point upperLeft = this.coordinatesToPosition(r.x, r.y, false);
            Point lowerRight = this.coordinatesToPosition(r.x + r.width - 1, r.y + r.height - 1, false);
            if (map.firstHexUp()) {
                upperLeft.y -= this.getHexSize() / 2;
            }
            if (r.x % 2 == (r.x + r.width - 1) % 2) {
                if (map.firstHexDown()) {
                    lowerRight.y += this.getHexSize() / 2;
                }
            } else if ((r.x & 1) == 1) {
                lowerRight.y = map.firstHexDown() ? (lowerRight.y += this.getHexSize()) : (lowerRight.y += this.getHexSize() / 2);
            } else if (map.firstHexUp() && r.x % 2 == 0) {
                lowerRight.y -= this.getHexSize() / 2;
            }
            lowerRight.x += this.getHexSize() - 1;
            lowerRight.y += this.getHexSize() - 1;
            upperLeft.y += this.getHexSize() / 5;
            lowerRight.y -= this.getHexSize() / 5;
            this.constrainRectangle(upperLeft, lowerRight);
            return new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x - upperLeft.x + 1, lowerRight.y - upperLeft.y + 1);
        }

        @Override
        Point getSouthEast(int index) {
            int col = this.getCol(index);
            int row = this.getRow(index) + Math.abs(col) % 2;
            return this.coordinatesToPosition(++col, row, false);
        }

        @Override
        Point getSouthWest(int index) {
            int col = this.getCol(index);
            int row = this.getRow(index) + Math.abs(col) % 2;
            return this.coordinatesToPosition(--col, row, false);
        }
    }

    protected abstract class MapDrawable {
        protected final int hexIndex;

        MapDrawable(int index) {
            this.hexIndex = index;
        }

        abstract boolean draw(Graphics2D var1);

        int getHexIndex() {
            return this.hexIndex;
        }

        Point getPosition() {
            return MapBoard.this.indexToPosition(this.hexIndex);
        }

        Rectangle getRectangle() {
            int width;
            Rectangle r = new Rectangle(this.getPosition());
            r.width = width = MapBoard.this.getLayout().getHexSize();
            r.height = width;
            return r;
        }
    }

    protected abstract class Line
    extends MapDrawable {
        private final int line;

        Line(int index, int line) {
            super(index);
            this.line = line;
            if (MapBoard.this.hexes == null) {
                MapBoard.this.hexes = new Hex[MapBoard.this.getNColumns() * MapBoard.this.getNRows()];
            }
            if (MapBoard.this.hexes[index] == null) {
                MapBoard.this.hexes[index] = new Hex();
            }
            this.getLineList(MapBoard.this.hexes[index]).add(this);
        }

        LineDefinition getLine() {
            return MapBoard.this.getLineDefinition(this.line);
        }

        abstract List<Line> getLineList(Hex var1);

        int compare(LineDefinition o1, LineDefinition o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            for (Hex h : MapBoard.this.hexes) {
                if (h == null) continue;
                boolean index1 = false;
                boolean index2 = false;
                for (Line hl : this.getLineList(h)) {
                    if (hl.getLine() == o1) {
                        if (index2) {
                            return 1;
                        }
                        index1 = true;
                        continue;
                    }
                    if (hl.getLine() != o2) continue;
                    if (index1) {
                        return -1;
                    }
                    index2 = true;
                }
            }
            return 0;
        }

        void drawLines(Graphics2D g, int cap) {
            ArrayList<LineDefinition> lds = new ArrayList<LineDefinition>(Arrays.asList(MapBoard.this.lineDefinitions));
            while (!lds.isEmpty()) {
                LineDefinition lowest = null;
                for (LineDefinition ld : lds) {
                    if (ld == null || lowest != null && this.compare(ld, lowest) >= 0) continue;
                    lowest = ld;
                }
                if (lowest == null) break;
                lowest.draw(g, cap);
                lowest.clearPoints();
                lds.remove(lowest);
            }
        }
    }

    protected abstract class HorizontalLayout
    extends Layout {
        HorizontalLayout(int size, int columns, int rows) {
            super(size, columns, rows);
        }

        @Override
        int getNFaces() {
            return 6;
        }

        @Override
        void setGridNumberingOffsets(RegularGridNumbering numbering, MapSheet sheet) {
            Point position = this.coordinatesToPosition(sheet.getField().x, sheet.getField().y, true);
            position.translate(this.getDeltaX() / 2, this.getDeltaY() / 2);
            int rowOffset = numbering.getColumn(position);
            int colOffset = numbering.getRow(position);
            rowOffset = -rowOffset + sheet.getTopLeftRow();
            colOffset = -colOffset + sheet.getTopLeftCol();
            numbering.setAttribute("hOff", rowOffset);
            numbering.setAttribute("vOff", colOffset);
        }

        @Override
        void initGridNumbering(RegularGridNumbering numbering, MapSheet sheet) {
            super.initGridNumbering(numbering, sheet);
            boolean stagger = false;
            if (sheet.firstHexRight() && (sheet.getField().y & 1) == 1) {
                stagger = true;
            } else if (sheet.firstHexLeft() && sheet.getField().y % 2 == 0) {
                stagger = true;
            }
            numbering.setAttribute("stagger", stagger);
            numbering.setAttribute("first", sheet.rowsAndCols() ? "H" : "V");
            numbering.setAttribute("hType", sheet.numericRows() ? "N" : "A");
            numbering.setAttribute("vType", sheet.numericCols() ? "N" : "A");
            numbering.setAttribute("hLeading", sheet.getNRowChars() - 1);
            numbering.setAttribute("vLeading", sheet.getNColChars() - 1);
        }

        @Override
        HexGridNumbering getGridNumbering() {
            return new HexGridNumbering();
        }

        @Override
        Point coordinatesToPosition(int x, int y, boolean nullIfOffBoard) {
            if (!nullIfOffBoard || MapBoard.this.isOnMapBoard(x, y)) {
                int xx = this.getDeltaX() * x + y % 2 * this.getDeltaX() / 2;
                int yy = this.getDeltaY() * y;
                return new Point(xx, yy);
            }
            return null;
        }

        @Override
        Point getNorthEast(int index) {
            int row = this.getRow(index);
            int col = this.getCol(index) + Math.abs(row) % 2;
            return this.coordinatesToPosition(col, --row, false);
        }

        @Override
        Point getNorthWest(int index) {
            int row = this.getRow(index) - 1;
            int col = this.getCol(index) - Math.abs(row) % 2;
            return this.coordinatesToPosition(col, row, false);
        }

        @Override
        Rectangle getRectangle(MapSheet map) {
            Rectangle r = map.getField();
            Point upperLeft = this.coordinatesToPosition(r.x, r.y, false);
            Point lowerRight = this.coordinatesToPosition(r.x + r.width - 1, r.y + r.height - 1, false);
            if (map.firstHexLeft()) {
                upperLeft.x -= this.getHexSize() / 2;
            }
            if (r.y % 2 == (r.y + r.height - 1) % 2) {
                if (map.firstHexRight()) {
                    lowerRight.x += this.getHexSize() / 2;
                }
            } else if ((r.y & 1) == 1) {
                lowerRight.x = map.firstHexLeft() ? (lowerRight.x += this.getHexSize() / 2) : (lowerRight.x += this.getHexSize());
            } else if (map.firstHexLeft() && r.y % 2 == 0) {
                lowerRight.x -= this.getHexSize() / 2;
            }
            lowerRight.x += this.getHexSize() - 1;
            lowerRight.y += this.getHexSize() - 1;
            upperLeft.x += this.getHexSize() / 5;
            lowerRight.x -= this.getHexSize() / 5;
            this.constrainRectangle(upperLeft, lowerRight);
            return new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x - upperLeft.x + 1, lowerRight.y - upperLeft.y + 1);
        }

        @Override
        Point getSouthEast(int index) {
            int row = this.getRow(index);
            int col = this.getCol(index) + Math.abs(row) % 2;
            return this.coordinatesToPosition(col, ++row, false);
        }

        @Override
        Point getSouthWest(int index) {
            int row = this.getRow(index) + 1;
            int col = this.getCol(index) - Math.abs(row) % 2;
            return this.coordinatesToPosition(col, row, false);
        }
    }

    private static class Hex {
        List<Line> hexLines = new ArrayList<Line>();
        List<Line> hexSides = new ArrayList<Line>();

        private Hex() {
        }
    }
}

