/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractParent;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.SeparatorProxy;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JMenu;

public class MenuProxy
extends AbstractParent<JMenu> {
    private String text;
    private char mnemonic = '\u0000';
    private boolean hideIfBlank = false;

    public MenuProxy() {
    }

    public MenuProxy(boolean hideIfBlank) {
        this.hideIfBlank = hideIfBlank;
    }

    public MenuProxy(String text) {
        this.text = text;
    }

    public boolean isHideIfBlank() {
        return this.hideIfBlank;
    }

    public void setHideIfBlank(boolean hideIfBlank) {
        this.hideIfBlank = hideIfBlank;
    }

    public SeparatorProxy addSeparator() {
        SeparatorProxy sep = new SeparatorProxy();
        this.add(sep);
        return sep;
    }

    public SeparatorProxy insertSeparator(int pos) {
        SeparatorProxy sep = new SeparatorProxy();
        this.insert(sep, pos);
        return sep;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.forEachPeer(menu -> menu.setText(text));
        if (this.isHideIfBlank()) {
            this.forEachPeer(menu -> menu.setVisible(text != null && !text.isEmpty()));
        }
    }

    @Override
    public JMenu createPeer() {
        JMenu menu = new JMenu(this.text);
        if (this.mnemonic != '\u0000') {
            menu.setMnemonic(this.mnemonic);
        }
        for (ChildProxy child : this.children) {
            Object peer = child.createPeer();
            if (peer == null) continue;
            menu.add((Component)peer);
        }
        this.peers.add(new WeakReference<JMenu>(menu, this.queue));
        if (this.isHideIfBlank()) {
            this.forEachPeer(m -> m.setVisible(this.text != null && !this.text.isEmpty()));
        }
        return menu;
    }

    public void setMnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
        this.forEachPeer(menu -> menu.setMnemonic(mnemonic));
    }
}

