/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.Attachment;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttachmentManager {
    private final Map<String, HashSet<Attachment>> attachments = new HashMap<String, HashSet<Attachment>>();

    public void clearAll() {
        this.attachments.clear();
    }

    public void pieceAdded(GamePiece piece) {
        if (piece instanceof Stack) {
            for (GamePiece p : ((Stack)piece).asList()) {
                this.addPiece(p);
            }
        } else {
            this.addPiece(piece);
        }
    }

    public void addPiece(GamePiece piece) {
        for (GamePiece gp : Decorator.getDecorators(piece, Attachment.class)) {
            Attachment attach = (Attachment)gp;
            String attachName = attach.getAttachName();
            HashSet currentAttachments = this.attachments.computeIfAbsent(attachName, k -> new HashSet());
            for (Attachment targetAttachment : currentAttachments) {
                if (targetAttachment.equals(attach)) {
                    if (!attach.isAllowSelfAttach()) continue;
                    attach.autoAttach(targetAttachment);
                    continue;
                }
                attach.autoAttach(targetAttachment);
                targetAttachment.autoAttach(attach);
            }
            currentAttachments.add(attach);
            this.attachments.put(attachName, currentAttachments);
        }
    }

    public void pieceRemoved(GamePiece piece) {
        if (!(piece instanceof Stack)) {
            this.removePiece(piece);
        }
    }

    public void removePiece(GamePiece piece) {
        for (GamePiece gp : Decorator.getDecorators(piece, Attachment.class)) {
            Attachment attach = (Attachment)gp;
            String attachName = attach.getAttachName();
            HashSet currentAttachments = this.attachments.computeIfAbsent(attachName, k -> new HashSet());
            for (Attachment attachment : currentAttachments) {
                if (!attachment.isAutoAttach()) continue;
                attachment.removeTarget(piece);
            }
            currentAttachments.remove(attach);
            this.attachments.put(attachName, currentAttachments);
            attach.clearAll();
        }
    }

    public Command removeAttachments(GamePiece piece) {
        Command command = new NullCommand();
        for (GamePiece gp : Decorator.getDecorators(piece, Attachment.class)) {
            Attachment attach = (Attachment)gp;
            if (attach.isAutoAttach()) continue;
            String attachName = attach.getAttachName();
            HashSet currentAttachments = this.attachments.computeIfAbsent(attachName, k -> new HashSet());
            for (Attachment targetAttachment : currentAttachments) {
                if (!targetAttachment.isAutoAttach()) {
                    command = command.append(targetAttachment.makeRemoveTargetCommand(piece));
                }
                command = command.append(attach.makeRemoveTargetCommand(Decorator.getOutermost(targetAttachment)));
            }
            currentAttachments.remove(attach);
            this.attachments.put(attachName, currentAttachments);
        }
        return command;
    }

    public Set<String> getAttachmentList() {
        return this.attachments.keySet();
    }

    public Set<Attachment> getAttachmentList(String attachName) {
        return this.attachments.get(attachName);
    }
}

