/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.SwingUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyNamer
implements Buildable {
    @Override
    public void build(Element e) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void addTo(Buildable b) {
    }

    @Override
    public void add(Buildable b) {
    }

    public static String getKeyString(KeyStroke k) {
        int mods;
        if (k == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int code = k.getKeyCode();
        switch (code) {
            case 107: {
                sb.append(Resources.getString("Keys.numplus"));
                break;
            }
            case 109: {
                sb.append(Resources.getString("Keys.numminus"));
                break;
            }
            case 33: {
                sb.append(Resources.getString("Keys.pgup"));
                break;
            }
            case 34: {
                sb.append(Resources.getString("Keys.pgdn"));
                break;
            }
            case 91: {
                sb.append(Resources.getString("Keys.bropen"));
                break;
            }
            case 93: {
                sb.append(Resources.getString("Keys.brclose"));
                break;
            }
        }
        if (sb.toString().isEmpty() || sb.toString().contains("Keys.")) {
            sb.append(KeyEvent.getKeyText(code));
        }
        if (((mods = SwingUtils.genericToSystem(k).getModifiers()) & 0x40) != 0) {
            sb.insert(0, "+");
            sb.insert(0, Resources.getString("Keys.shift"));
        }
        if ((mods & 0x80) != 0) {
            sb.insert(0, "+");
            sb.insert(0, Resources.getString("Keys.ctrl"));
        }
        if ((mods & 0x100) != 0) {
            sb.insert(0, "+");
            sb.insert(0, Resources.getString("Keys.meta"));
        }
        if ((mods & 0x200) != 0) {
            sb.insert(0, "+");
            sb.insert(0, Resources.getString("Keys.alt"));
        }
        return StringUtils.capitalize((String)sb.toString().replace(' ', '_'));
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }
}

