/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MenuManager;
import java.awt.Container;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Element;

public class PrivateMap
extends Map {
    protected String[] owners = new String[0];
    protected boolean visibleToAll;
    protected Map surrogate;
    public static final String VISIBLE = "visible";
    public static final String SIDE = "side";
    public static final String USE_BOARDS = "useBoards";

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])new String[]{SIDE, VISIBLE, USE_BOARDS}, (Object[])super.getAttributeNames());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])new String[]{Resources.getString("Editor.PrivateMap.belongs_to_one_side"), Resources.getString("Editor.PrivateMap.visible_to_all_player"), Resources.getString("Editor.PrivateMap.use_same_boards_as_this_map")}, (Object[])super.getAttributeDescriptions());
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])new Class[]{String[].class, Boolean.class, String.class}, (Object[])super.getAttributeTypes());
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (VISIBLE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.visibleToAll = (Boolean)value;
        } else if (SIDE.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.owners = value;
        } else if (USE_BOARDS.equals(key)) {
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                this.surrogate = null;
            } else {
                for (Map m : Map.getMapList()) {
                    if (!m.getMapName().equals(value)) continue;
                    this.surrogate = m;
                    break;
                }
            }
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (VISIBLE.equals(key)) {
            return String.valueOf(this.visibleToAll);
        }
        if (SIDE.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.owners);
        }
        if (USE_BOARDS.equals(key)) {
            return this.surrogate == null ? null : this.surrogate.getMapName();
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.setUpView();
        }
        return this.theMap;
    }

    @Override
    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog d = new JDialog(GameModule.getGameModule().getPlayerWindow()){
                private static final long serialVersionUID = 1L;

                @Override
                public void setVisible(boolean show) {
                    super.setVisible(show && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
                }
            };
            d.setDefaultCloseOperation(0);
            d.setTitle(this.getDefaultWindowTitle());
            return d;
        }
        JFrame d = new JFrame(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setVisible(boolean show) {
                super.setVisible(show && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
            }
        };
        d.setDefaultCloseOperation(0);
        d.setTitle(this.getDefaultWindowTitle());
        d.setJMenuBar(MenuManager.getInstance().getMenuBarFor(d));
        return d;
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        super.sideChanged(oldSide, newSide);
        ((View)this.getView()).disableListeners();
        if (this.isAccessibleTo(newSide)) {
            ((View)this.getView()).enableListeners();
        } else if (this.isVisibleTo(newSide)) {
            ((View)this.getView()).enableMotionListeners();
        }
        this.getLaunchButton().setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
        Container tla = this.theMap.getTopLevelAncestor();
        if (tla != null && tla.isVisible() && !this.isVisibleTo(newSide)) {
            tla.setVisible(false);
        }
    }

    @Override
    public boolean shouldDockIntoMainWindow() {
        return false;
    }

    public boolean isAccessibleTo(String playerSide) {
        for (String owner : this.owners) {
            if (!owner.equals(playerSide)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleTo(String playerSide) {
        return this.visibleToAll || this.isAccessibleTo(playerSide);
    }

    @Override
    public void setup(boolean show) {
        super.setup(show);
        if (!show) {
            ((View)this.theMap).disableListeners();
        } else if (this.isAccessibleTo(PlayerRoster.getMySide())) {
            ((View)this.theMap).enableListeners();
        } else if (this.isVisibleTo(PlayerRoster.getMySide())) {
            ((View)this.theMap).enableMotionListeners();
        }
        this.getLaunchButton().setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
    }

    @Override
    public void setBoards(Collection<Board> c) {
        if (this.surrogate != null) {
            c = this.surrogate.getBoards();
            this.edgeBuffer = this.surrogate.getEdgeBuffer();
        }
        super.setBoards(c);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PrivateMap.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PrivateWindow.html");
    }

    @Override
    public void build(Element el) {
        this.validator = new ValidityChecker(){

            @Override
            public void validate(Buildable target, ValidationReport report) {
                if (!PlayerRoster.isActive()) {
                    report.addWarning(Resources.getString("Editor.PrivateMap.warning", ConfigureTree.getConfigureName(PlayerRoster.class), ConfigureTree.getConfigureName(this.getClass())));
                }
            }
        };
        this.surrogate = null;
        super.build(el);
    }

    public static class View
    extends Map.View {
        private static final long serialVersionUID = 1L;
        private boolean listenersActive;
        private boolean motionListenersActive;
        private final List<KeyListener> keyListeners = new ArrayList<KeyListener>();
        private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
        private final List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
        private DropTarget dropTarget;

        public View(PrivateMap m) {
            super(m);
        }

        @Override
        public synchronized void setDropTarget(DropTarget dt) {
            if (dt != null) {
                this.dropTarget = dt;
            }
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
            if (this.listenersActive) {
                super.addKeyListener(l);
            } else {
                this.keyListeners.add(l);
            }
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            if (this.listenersActive) {
                super.addMouseListener(l);
            } else {
                this.mouseListeners.add(l);
            }
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
            if (this.listenersActive || this.motionListenersActive) {
                super.addMouseMotionListener(l);
            } else {
                this.mouseMotionListeners.add(l);
            }
        }

        protected void disableListeners() {
            for (KeyListener keyListener : this.keyListeners) {
                this.removeKeyListener(keyListener);
            }
            for (MouseListener mouseListener : this.mouseListeners) {
                this.removeMouseListener(mouseListener);
            }
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                this.removeMouseMotionListener(mouseMotionListener);
            }
            super.setDropTarget(null);
            this.listenersActive = false;
            this.motionListenersActive = false;
        }

        protected void enableListeners() {
            for (KeyListener keyListener : this.keyListeners) {
                super.addKeyListener(keyListener);
            }
            for (MouseListener mouseListener : this.mouseListeners) {
                super.addMouseListener(mouseListener);
            }
            for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
                super.addMouseMotionListener(mouseMotionListener);
            }
            super.setDropTarget(this.dropTarget);
            this.listenersActive = true;
        }

        protected void enableMotionListeners() {
            for (MouseMotionListener l : this.mouseMotionListeners) {
                super.addMouseMotionListener(l);
            }
            this.motionListenersActive = true;
        }
    }
}

