/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.tools.FormattedString;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ShadowDiceDieServer
extends DieServer {
    public static final String ROLL_MARKER = "VASSAL auto-generated dice roll";

    public ShadowDiceDieServer() {
        this.name = "ShadowDice";
        this.description = "ShadowDice Dice Server";
        this.emailOnly = false;
        this.maxRolls = 0;
        this.maxEmails = 0;
        this.serverURL = "http://www.gamerz.net/shadowdice/shadowdice.cgi";
        this.passwdRequired = false;
        this.canDoSeparateDice = true;
    }

    @Override
    public String[] buildInternetRollString(RollSet toss) {
        DieRoll[] rolls;
        String CRLF = "%0D%0A";
        String LSQUARE = "%5B";
        String RSQUARE = "%5D";
        String HASH = "%23";
        String pEmail = "";
        String sEmail = "";
        if (this.getUseEmail()) {
            pEmail = this.extractEmail(this.getPrimaryEmail());
            sEmail = this.extractEmail(this.getSecondaryEmail());
        }
        String desc = this.hexify(toss.description);
        Object s = "mto=" + pEmail + "&mcc=" + sEmail + "&yem=" + pEmail;
        s = (String)s + "&sbj=" + desc;
        s = (String)s + "&msg=VASSAL auto-generated dice roll%0D%0A" + desc + "%0D%0A";
        int mLen = toss.getMaxDescLength();
        for (DieRoll roll : rolls = toss.getDieRolls()) {
            s = (String)s + this.hexify(roll.getDescription());
            for (int j = 0; j < mLen - roll.getDescription().length(); ++j) {
                s = (String)s + " ";
            }
            s = (String)s + " %23";
            int nd = roll.getNumDice();
            int ns = roll.getNumSides();
            for (int j = 0; j < nd; ++j) {
                s = (String)s + "%5B1d" + ns + "%5D";
            }
            s = (String)s + "%0D%0A";
        }
        s = (String)s + "&todo=Action%21&hid=1";
        s = ((String)s).replace(' ', '+');
        return new String[]{s};
    }

    public String hexify(String s) {
        String hexyChars = "~!$%^&()+`={}[]|:;'<>,?/\\\"";
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '#') {
                b.append('.');
                continue;
            }
            if ("~!$%^&()+`={}[]|:;'<>,?/\\\"".indexOf(c) >= 0) {
                b.append('%').append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    @Override
    public void parseInternetRollString(RollSet rollSet, Vector<String> results) {
        Enumeration<String> e = results.elements();
        String line = e.nextElement();
        while (e.hasMoreElements() && !line.startsWith("! VASSAL auto-generated dice roll")) {
            line = e.nextElement();
        }
        line = e.nextElement();
        DieRoll[] rolls = rollSet.getDieRolls();
        for (int i = 0; i < rolls.length; ++i) {
            line = e.nextElement();
            int firsthash = line.indexOf(35) - 1;
            StringTokenizer st = new StringTokenizer(line.substring(firsthash), " ");
            for (int j = 0; j < rollSet.dieRolls[i].getNumDice(); ++j) {
                st.nextToken();
                String result = st.nextToken();
                int res = Integer.parseInt(result);
                rollSet.dieRolls[i].setResult(j, res);
            }
        }
    }

    @Override
    public void roll(RollSet mr, FormattedString format) {
        super.doInternetRoll(mr, format);
    }
}

