/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.TranslatableStringContainer;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface TranslatableString {
    public String getPropertyValue();

    public TranslatableStringContainer getParent();

    public void setPropertyValue(String var1);

    public static class Impl
    implements TranslatableString {
        private final PropertyChangeSupport propSupport;
        private String value = "";
        private String propertyName;
        private TranslatableStringContainer parent;
        private static final List<Impl> allProperties = new ArrayList<Impl>();

        public static List<Impl> getAllProperties() {
            return allProperties;
        }

        public Impl(String propertyName, Object source) {
            this.propertyName = propertyName;
            this.propSupport = new PropertyChangeSupport(this);
        }

        public void addTo(TranslatableStringContainer c) {
            this.parent = c;
            this.parent.addTranslatableString(this.propertyName, this);
            allProperties.add(this);
        }

        public void setPropertyName(String name) {
            if (this.parent != null) {
                this.parent.removeTranslatableString(this.propertyName);
                this.parent.addTranslatableString(name, this);
            }
            this.propertyName = name;
        }

        public void removeFromContainer() {
            if (this.parent != null) {
                this.parent.removeTranslatableString(this.propertyName);
                allProperties.remove(this);
            }
        }

        @Override
        public String getPropertyValue() {
            return this.value;
        }

        public String getName() {
            return this.propertyName;
        }

        @Override
        public TranslatableStringContainer getParent() {
            return this.parent;
        }

        @Override
        public void setPropertyValue(String newValue) {
            if (newValue == null) {
                newValue = "";
            }
            String oldValue = this.value;
            this.value = newValue;
            this.propSupport.firePropertyChange(this.propertyName, oldValue, newValue);
        }
    }

    public static class Util {
        public static TranslatableString findTranslatableString(String propertyName, List<TranslatableStringContainer> propertyContainers) {
            TranslatableStringContainer c;
            TranslatableString p = null;
            Iterator<TranslatableStringContainer> iterator = propertyContainers.iterator();
            while (iterator.hasNext() && (p = (c = iterator.next()) == null ? null : c.getTranslatableString(propertyName)) == null) {
            }
            return p;
        }
    }
}

