/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.ServerNode;
import VASSAL.chat.node.StatusReporter;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class AsynchronousServerNode
extends ServerNode {
    private static final Logger logger = Logger.getLogger(AsynchronousServerNode.class.getName());
    private StatusReporter statusReporter;
    private ReportContentsThread contentsReporter;

    public AsynchronousServerNode(String url) {
        this.init(url);
    }

    protected void init(String url) {
        this.statusReporter = new StatusReporter(url == null ? null : new HttpRequestWrapper(url), this);
        this.contentsReporter = new ReportContentsThread(this);
    }

    @Override
    protected synchronized void sendContents(Node node) {
        this.contentsReporter.markChanged(node);
    }

    public static class ReportContentsThread
    extends Thread {
        private final AsynchronousServerNode server;
        private final Set<Node> changed;
        private long lastGlobalUpdate;
        private static final long GLOBAL_UPDATE_INTERVAL = 120000L;

        public ReportContentsThread(AsynchronousServerNode server) {
            this.server = server;
            this.changed = new HashSet<Node>();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ReportContentsThread reportContentsThread = this;
                        synchronized (reportContentsThread) {
                            this.wait();
                            this.sendContents();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private synchronized void sendContents() {
            Iterator<Node> modules;
            this.server.statusReporter.updateContents(this.server.getLeafDescendants());
            long time = System.currentTimeMillis();
            if (time - this.lastGlobalUpdate < 120000L) {
                modules = Arrays.asList(this.server.getChildren()).iterator();
                this.lastGlobalUpdate = time;
            } else {
                modules = this.changed.iterator();
            }
            while (modules.hasNext()) {
                Node module = modules.next();
                logger.fine("Sending contents of " + module.getId());
                Node[] players = module.getLeafDescendants();
                Node[] rooms = module.getChildren();
                for (int i = 1; i < rooms.length; ++i) {
                    Node[] c = rooms[i].getChildren();
                    if (c.length <= 0) continue;
                    try {
                        Properties roomProps = new PropertiesEncoder(rooms[i].getInfo()).getProperties();
                        String roomOwner = roomProps.getProperty("owner");
                        String playerId = new PropertiesEncoder(c[0].getInfo()).getProperties().getProperty("id");
                        if (roomOwner != null && roomOwner.equals(playerId)) continue;
                        roomProps.setProperty("owner", playerId);
                        rooms[i].setInfo(new PropertiesEncoder(roomProps).toString());
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String listCommand = Protocol.encodeListCommand(players);
                logger.finer(listCommand);
                module.send(listCommand);
                String roomInfo = Protocol.encodeRoomsInfo(rooms);
                module.send(roomInfo);
            }
            this.changed.clear();
        }

        public synchronized void markChanged(Node module) {
            logger.fine(String.valueOf(module) + " has changed");
            this.changed.add(module);
            this.notifyAll();
        }
    }
}

