/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class GlobalHotKey
extends Decorator
implements TranslatablePiece {
    public static final String ID = "globalhotkey;";
    protected NamedKeyStroke commandKey;
    protected NamedKeyStroke globalHotKey;
    protected String commandName;
    protected KeyCommand[] commands;
    protected KeyCommand command;
    protected String description = "";

    public GlobalHotKey() {
        this(ID, null);
    }

    public GlobalHotKey(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.commandName, this.commandKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command.setEnabled(this.getMap() != null);
            this.commands = this.commandName != null && this.commandName.length() > 0 && this.commandKey != null && !this.commandKey.isNull() ? new KeyCommand[]{this.command} : KeyCommand.NONE;
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.commandKey).append(this.globalHotKey).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.command.matches(stroke)) {
            GameModule gm = GameModule.getGameModule();
            boolean loggingPausedByMe = gm.pauseLogging();
            GameModule.getGameModule().fireKeyStroke(this.globalHotKey);
            if (loggingPausedByMe) {
                return gm.resumeLogging();
            }
        }
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.GlobalHotKey.trait_description", this.description) + this.getCommandDesc(this.commandName, this.commandKey) + " => " + this.getCommandDesc("", this.globalHotKey);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.GlobalHotKey.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalHotKey.html");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(type.substring(ID.length()), ';');
        this.commandName = sd.nextToken();
        this.commandKey = sd.nextNamedKeyStroke('H');
        this.globalHotKey = sd.nextNamedKeyStroke(null);
        this.description = sd.nextToken("");
        this.commands = null;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, Resources.getString("Editor.GlobalHoyKey.global_hotkey_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof GlobalHotKey)) {
            return false;
        }
        GlobalHotKey c = (GlobalHotKey)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        if (!Objects.equals(this.commandKey, c.commandKey)) {
            return false;
        }
        if (!Objects.equals(this.globalHotKey, c.globalHotKey)) {
            return false;
        }
        return Objects.equals(this.description, c.description);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.commandKey, this.globalHotKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer commandConfig;
        private final NamedHotKeyConfigurer commandKeyConfig;
        private final NamedHotKeyConfigurer hotKeyConfig;
        protected StringConfigurer descConfig;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(GlobalHotKey k) {
            this.descConfig = new StringConfigurer(k.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descConfig);
            this.commandConfig = new StringConfigurer(k.commandName);
            this.commandConfig.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.commandConfig);
            this.commandKeyConfig = new NamedHotKeyConfigurer(k.commandKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.commandKeyConfig);
            this.hotKeyConfig = new NamedHotKeyConfigurer(k.globalHotKey);
            this.controls.add("Editor.GlobalHotKey.global_hotkey", (Configurer)this.hotKeyConfig);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.commandConfig.getValueString()).append(this.commandKeyConfig.getValueString()).append(this.hotKeyConfig.getValueString()).append(this.descConfig.getValueString());
            return GlobalHotKey.ID + se.getValue();
        }
    }
}

