/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.GameModule;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrivateMap;
import VASSAL.script.BeanShell;
import VASSAL.script.proxy.Map;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.swing.DialogCloser;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.UtilEvalError;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class AbstractInterpreter
extends Interpreter {
    protected static final String THIS = "_interp";
    protected static final String SOURCE = "_source";
    private static final long serialVersionUID = 1L;
    protected NameSpace myNameSpace;

    protected void setVar(String name, Object value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    protected void setVar(String name, int value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    protected void setVar(String name, float value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    protected void setVar(String name, boolean value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    protected void setVar(String name, Class<?> cl, Object value) {
        try {
            this.getNameSpace().setTypedVariable(name, cl, value, null);
        }
        catch (UtilEvalError e) {
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    public Object alert(Object message) {
        return this.alert(message, "0");
    }

    public Object alert(Object message, Object closeAfterDelay) {
        int ms;
        try {
            ms = closeAfterDelay instanceof Integer ? (Integer)closeAfterDelay : Integer.parseInt((String)closeAfterDelay);
        }
        catch (Exception ex) {
            ms = 0;
        }
        JDialog dialog = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
        JOptionPane pane = new JOptionPane(message.toString(), 1);
        dialog.setContentPane(pane);
        dialog.setTitle("Alert Message");
        dialog.pack();
        dialog.setLocationRelativeTo(GameModule.getGameModule().getPlayerWindow());
        dialog.setDefaultCloseOperation(2);
        pane.addPropertyChangeListener(e -> dialog.setVisible(false));
        if (ms > 0) {
            SwingUtilities.invokeLater(new DialogCloser(dialog, ms));
        }
        dialog.setVisible(true);
        return "";
    }

    public Object getModuleProperty(String name) {
        return BeanShell.wrap(GameModule.getGameModule().getProperty(name).toString());
    }

    public void setModuleProperty(String name, String value) {
        GameModule.getGameModule().getMutableProperty(name).setPropertyValue(value);
    }

    public Map findMap(String mapName) {
        VASSAL.build.module.Map map = null;
        for (VASSAL.build.module.Map m : GameModule.getGameModule().getAllDescendantComponentsOf(VASSAL.build.module.Map.class)) {
            if (!m.getMapName().equals(mapName) || !this.isAccessible(m)) continue;
            map = m;
            break;
        }
        return map == null ? null : new Map(map);
    }

    protected boolean isAccessible(VASSAL.build.module.Map m) {
        if (m instanceof PrivateMap) {
            String mySide = PlayerRoster.getMySide();
            if (mySide == null) {
                return true;
            }
            return ((PrivateMap)m).isAccessibleTo(mySide);
        }
        return true;
    }

    public void globalHotKey(KeyStroke stroke) {
        GameModule.getGameModule().fireKeyStroke(NamedKeyStroke.of(stroke));
    }
}

