/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.Attachment;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.ReportState;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.AbstractInterpreter;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.swing.DialogCloser;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionInterpreter
extends AbstractInterpreter
implements RecursionLimiter.Loopable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionInterpreter.class);
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_expression.bsh";
    protected static final String THIS = "_interp";
    protected static final String SOURCE = "_source";
    protected static final String MAGIC1 = "_xyzzy";
    protected static final String MAGIC2 = "_plugh";
    protected static final String MAGIC3 = "_plover";
    protected static final String ERROR_PREFIX = " inline evaluation of: ``_xyzzy=_plugh();''";
    protected static NameSpace topLevelNameSpace;
    protected NameSpace expressionNameSpace;
    protected String expression;
    protected List<String> variables;
    protected List<String> stringVariables;
    protected PropertySource source;
    protected AuditTrail currentAudit;
    protected Auditable currentOwner;

    @Override
    public String getComponentTypeName() {
        return Resources.getString("Editor.ExpressionInterpreter.component_type");
    }

    @Override
    public String getComponentName() {
        return Resources.getString("Editor.ExpressionInterpreter.component_type");
    }

    protected static String strip(String expr) {
        String s = expr.trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return expr;
    }

    public ExpressionInterpreter(String expr) throws ExpressionException {
        this.expression = expr == null ? "" : ExpressionInterpreter.strip(expr);
        this.setClassLoader(this.getClass().getClassLoader());
        if (topLevelNameSpace == null) {
            this.initialiseStatic();
        }
        this.expressionNameSpace = new NameSpace(topLevelNameSpace, "expression");
        BeanShellExpressionValidator validator = new BeanShellExpressionValidator(this.expression);
        this.variables = validator.getVariables();
        this.stringVariables = validator.getStringVariables();
        this.setNameSpace(this.expressionNameSpace);
        if (this.expression.length() > 0) {
            try {
                StringBuilder argList = new StringBuilder();
                for (String variable : this.stringVariables) {
                    if (argList.length() > 0) {
                        argList.append(',');
                    }
                    argList.append("String ").append(variable);
                }
                String ex = "String _plugh(" + argList.toString() + ") { _plover=" + this.expression + "; return _plover.toString();}";
                this.eval(ex);
            }
            catch (EvalError e) {
                throw new ExpressionException(this.getExpression());
            }
        }
        this.setVar(THIS, this);
    }

    protected void initialiseStatic() {
        topLevelNameSpace = new NameSpace(null, this.getClassManager(), "topLevel");
        this.setNameSpace(topLevelNameSpace);
        this.getNameSpace().importClass("VASSAL.build.module.properties.PropertySource");
        this.getNameSpace().importClass("VASSAL.script.ExpressionInterpreter");
        URL ini = this.getClass().getResource(INIT_SCRIPT);
        try (InputStream is = ini.openStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            try {
                this.eval(in);
            }
            catch (EvalError e) {
                logger.error("Error trying to read init script: " + String.valueOf(ini));
                WarningDialog.show(e, "", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error trying to read init script: " + String.valueOf(ini));
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, false);
    }

    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        return this.evaluate(ps, localized, null, null);
    }

    public String evaluate(PropertySource ps, boolean localized, Auditable owner, AuditTrail audit) throws ExpressionException {
        return this.evaluate(ps, null, localized, owner, audit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(PropertySource ps, java.util.Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) throws ExpressionException {
        String result;
        if (this.getExpression().length() == 0) {
            return "";
        }
        try {
            RecursionLimiter.startExecution(this);
            this.source = ps == null ? GameModule.getGameModule() : ps;
            this.currentAudit = audit;
            this.currentOwner = owner;
            this.setNameSpace(this.expressionNameSpace);
            Iterator<String> iterator = this.variables.iterator();
            while (iterator.hasNext()) {
                String value;
                String prop;
                String string;
                String name;
                String origName = name = (string = iterator.next());
                if (name.length() > 2 && name.startsWith("$") && name.endsWith("$")) {
                    name = name.substring(1, name.length() - 1);
                }
                String string2 = prop = properties == null ? null : properties.get(name);
                if (prop == null) {
                    prop = this.source == null ? "" : (localized ? this.source.getLocalizedProperty(name) : this.source.getProperty(name));
                }
                String string3 = value = prop == null ? "" : prop.toString();
                if (audit != null) {
                    audit.addMessage(" " + origName + "=" + (value == null ? "" : value));
                }
                if (value == null) {
                    this.setVar(string, "");
                    continue;
                }
                if ("true".equals(value)) {
                    this.setVar(string, true);
                    continue;
                }
                if ("false".equals(value)) {
                    this.setVar(string, false);
                    continue;
                }
                if (!StringUtils.containsOnly((CharSequence)value, (String)"+-.0123456789")) {
                    this.setVar(string, value);
                    continue;
                }
                if (GlobalOptions.getInstance() != null && GlobalOptions.getInstance().isStoreLeadingZeroIntegersAsStrings() && value.length() > 1 && value.startsWith("0") && StringUtils.containsOnly((CharSequence)value, (String)"0123456789")) {
                    this.setVar(string, value);
                    continue;
                }
                try {
                    this.setVar(string, Integer.parseInt(value));
                }
                catch (NumberFormatException ex1) {
                    try {
                        NumberUtils.createBigInteger((String)value);
                        this.setVar(string, value);
                    }
                    catch (NumberFormatException ex3) {
                        try {
                            this.setVar(string, Float.parseFloat(value));
                        }
                        catch (NumberFormatException ex2) {
                            this.setVar(string, value);
                        }
                    }
                }
            }
            StringBuilder argList = new StringBuilder();
            Iterator<String> iterator2 = this.stringVariables.iterator();
            while (iterator2.hasNext()) {
                String value;
                String prop;
                String var3;
                String name;
                String origName = name = (var3 = iterator2.next());
                if (name.length() > 2 && name.startsWith("$") && name.endsWith("$")) {
                    name = name.substring(1, name.length() - 1);
                }
                String string = prop = properties == null ? null : properties.get(name);
                if (prop == null) {
                    prop = this.source == null ? "" : (localized ? this.source.getLocalizedProperty(name) : this.source.getProperty(name));
                }
                String string4 = value = prop == null ? "" : prop.toString();
                if (audit != null) {
                    audit.addMessage(" " + origName + "=" + (value == null ? "" : value));
                }
                if (argList.length() > 0) {
                    argList.append(',');
                }
                argList.append('\"').append(value == null ? "" : value.replace("\"", "\\\"")).append('\"');
            }
            this.setVar(THIS, this);
            this.setVar(SOURCE, this.source);
            try {
                this.eval("_xyzzy=_plugh(" + argList.toString() + ")");
                Object object = this.get(MAGIC1);
                result = object == null ? "" : object.toString();
            }
            catch (EvalError evalError) {
                String s = evalError.getRawMessage();
                String search = "_plugh();'' ";
                int pos = s.indexOf("_plugh();'' ");
                String m = s.substring(pos + "_plugh();'' ".length());
                if (m.startsWith(ERROR_PREFIX)) {
                    m = m.substring(ERROR_PREFIX.length() + 1);
                }
                if (audit != null) {
                    audit.addMessage(Resources.getString("Audit.error_trail", m));
                }
                throw new ExpressionException(this.getExpression(), s.substring(pos + "_plugh();'' ".length()), owner, audit);
            }
        }
        catch (RecursionLimitException e) {
            result = "";
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.possible_infinite_expression_loop"), this.getExpression(), e));
        }
        finally {
            RecursionLimiter.endExecution();
            this.source = null;
        }
        return result;
    }

    public String evaluate() throws ExpressionException {
        return this.getExpression().length() == 0 ? "" : this.evaluate(GameModule.getGameModule());
    }

    public Object wrap(String value) {
        if (value == null) {
            return "";
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public Object wrap(Object value) {
        return value instanceof String ? this.wrap((String)value) : value;
    }

    public Object getProperty(Object name) {
        Object value = this.source.getProperty(name.toString());
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object getLocalizedProperty(Object name) {
        Object value = this.source.getLocalizedProperty(name.toString());
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object getString(Object name) {
        Object value = this.source.getProperty(name.toString());
        return value == null ? "" : value.toString();
    }

    public Object getZoneProperty(Object propertyName, Object zoneName) {
        Zone zone;
        Map map;
        if (this.source instanceof GamePiece && (map = ((GamePiece)this.source).getMap()) != null && (zone = map.findZone(zoneName.toString())) != null) {
            return this.wrap((String)zone.getProperty(propertyName.toString()));
        }
        return this.wrap("");
    }

    public Object getZoneProperty(Object propertyName, Object zoneName, Object mapName) {
        Zone zone;
        Map map = this.findVassalMap(mapName.toString());
        if (map != null && (zone = map.findZone(zoneName.toString())) != null) {
            return this.wrap((String)zone.getProperty(propertyName.toString()));
        }
        return this.wrap("");
    }

    public Object getMapProperty(Object propertyName, Object mapName) {
        Map map = this.findVassalMap(mapName.toString());
        return map == null ? this.wrap("") : this.wrap((String)map.getProperty(propertyName.toString()));
    }

    public Object getAttachmentProperty(Object attachment, Object property, Object indexOrNameOrexpression, PropertySource ps) {
        String attach = attachment.toString();
        String prop = property.toString();
        if (attach.isEmpty() || prop.isEmpty()) {
            return "";
        }
        int index = -1;
        String pieceName = "";
        PieceFilter filter = null;
        if (indexOrNameOrexpression instanceof Integer) {
            index = (Integer)indexOrNameOrexpression;
        } else {
            String s = indexOrNameOrexpression.toString();
            if (NumberUtils.isDigits((String)s)) {
                index = Integer.parseInt(s);
            } else if (s.startsWith("{")) {
                filter = this.createFilter(s, ps);
            } else {
                pieceName = s;
            }
        }
        return this.getAttachmentProperty(attach, prop, index, pieceName, filter, ps);
    }

    private Object getAttachmentProperty(String attachment, String property, Integer index, String pieceName, PieceFilter filter, PropertySource ps) {
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece p = Decorator.getOutermost((Decorator)ps);
            for (GamePiece gp : Decorator.getDecorators(p, Attachment.class)) {
                Attachment attach = (Attachment)gp;
                if (!attachment.equals(attach.getAttachName())) continue;
                if (index > 0) {
                    GamePiece target = attach.getAttachedPieceAt(index - 1);
                    if (target == null) {
                        return "";
                    }
                    return this.wrap(target.getProperty(property));
                }
                for (GamePiece target : attach.getAttachList()) {
                    if (!pieceName.isEmpty() && pieceName.equals(target.getProperty("BasicName"))) {
                        return this.wrap(target.getProperty(property));
                    }
                    if (filter == null || !filter.accept(target)) continue;
                    return this.wrap(target.getProperty(property));
                }
            }
        }
        return "";
    }

    private PropertySource translatePiece(PropertySource ps) {
        if (ps instanceof ReportState.OldAndNewPieceProperties) {
            ps = ((ReportState.OldAndNewPieceProperties)ps).getNewPiece();
        }
        return ps;
    }

    private static int IntPropValue(Object prop) {
        if (prop != null) {
            if (prop instanceof Integer) {
                return (Integer)prop;
            }
            String s1 = prop.toString();
            return NumberUtils.toInt((String)s1, (int)0);
        }
        return 0;
    }

    public Object sumStack(Object property, PropertySource ps) {
        return this.sumStack(property, "", ps);
    }

    private PieceFilter createFilter(String expression, PropertySource ps, String comment) {
        if (expression == null) {
            return null;
        }
        String matchString = this.replaceDollarVariables(expression, ps);
        return matchString == null || matchString.isEmpty() ? null : new PropertyExpression(this.unescape(matchString)).getFilter(ps, this.currentOwner, AuditTrail.create((Auditable)ps, expression, comment));
    }

    private PieceFilter createFilter(String expression, PropertySource ps) {
        return this.createFilter(expression, ps, "");
    }

    private PieceFilter createFilter(Object expression, PropertySource ps, String comment) {
        return this.createFilter(expression == null ? "" : expression.toString(), ps, comment);
    }

    private PieceFilter createFilter(Object expression, PropertySource ps) {
        return this.createFilter(expression, ps, "");
    }

    public Object sumStack(Object property, Object expression, PropertySource ps) {
        return this.sumStack(property.toString(), this.createFilter(expression, ps), ps);
    }

    private Object sumStack(String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece piece = (GamePiece)ps;
            Stack s = ((GamePiece)ps).getParent();
            if (s == null) {
                result = this.updateTotal(result, piece, property, filter, true);
            } else {
                for (GamePiece gamePiece : s.asList()) {
                    result = this.updateTotal(result, gamePiece, property, filter, true);
                }
            }
        }
        return result;
    }

    public Object countStack(Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countStack((Object)"", propertyOrExpression, ps);
        }
        return this.countStack(propertyOrExpression.toString(), null, ps);
    }

    public Object countStack(Object property, Object expression, PropertySource ps) {
        return this.countStack(property.toString(), this.createFilter(expression, ps), ps);
    }

    private Object countStack(String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece piece = (GamePiece)ps;
            Stack s = ((GamePiece)ps).getParent();
            if (s == null) {
                result = this.updateTotal(result, piece, property, filter, false);
            } else if (filter == null && (property == null || property.isEmpty())) {
                result = s.nVisible();
            } else {
                for (GamePiece gamePiece : s.asList()) {
                    result = this.updateTotal(result, gamePiece, property, filter, false);
                }
            }
        }
        return result;
    }

    public Object maxAttachment(Object attachment, Object property, PropertySource ps) {
        int result = Integer.MIN_VALUE;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece p = Decorator.getOutermost((Decorator)ps);
            for (GamePiece decorator : Decorator.getDecorators(p, Attachment.class)) {
                Attachment a = (Attachment)decorator;
                if (!a.getAttachName().equals(attachment)) continue;
                for (GamePiece target : a.getAttachList()) {
                    Object prop = target.getProperty(property);
                    int value = ExpressionInterpreter.IntPropValue(prop);
                    if (value <= result) continue;
                    result = value;
                }
            }
        }
        return result == Integer.MIN_VALUE ? 0 : result;
    }

    public Object minAttachment(Object attachment, Object property, PropertySource ps) {
        int result = Integer.MAX_VALUE;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece p = Decorator.getOutermost((Decorator)ps);
            for (GamePiece decorator : Decorator.getDecorators(p, Attachment.class)) {
                Attachment a = (Attachment)decorator;
                if (!a.getAttachName().equals(attachment)) continue;
                for (GamePiece target : a.getAttachList()) {
                    Object prop = target.getProperty(property);
                    int value = ExpressionInterpreter.IntPropValue(prop);
                    if (value >= result) continue;
                    result = value;
                }
            }
        }
        return result == Integer.MAX_VALUE ? 0 : result;
    }

    public Object sumAttachment(Object attachment, Object property, PropertySource ps) {
        return this.sumAttachment(attachment, property, "", ps);
    }

    public Object sumAttachment(Object attachment, Object property, Object expression, PropertySource ps) {
        return this.sumAttachment(attachment.toString(), property.toString(), this.createFilter(expression, ps), ps);
    }

    private Object sumAttachment(String attachment, String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece p = Decorator.getOutermost((Decorator)ps);
            for (GamePiece decorator : Decorator.getDecorators(p, Attachment.class)) {
                Attachment a = (Attachment)decorator;
                if (!a.getAttachName().equals(attachment)) continue;
                for (GamePiece target : a.getAttachList()) {
                    result = this.updateTotal(result, target, property, filter, true);
                }
            }
        }
        return result;
    }

    public Object countAttachment(Object attachment, Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countAttachment(attachment, (Object)"", propertyOrExpression, ps);
        }
        return this.countAttachment(attachment, (Object)propertyOrExpression.toString(), "", ps);
    }

    public Object countAttachment(Object attachment, Object property, Object expression, PropertySource ps) {
        return this.countAttachment(attachment.toString(), property.toString(), this.createFilter(expression, ps), ps);
    }

    private Object countAttachment(String attachment, String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            for (GamePiece target : Attachment.getAttachList((GamePiece)ps, attachment)) {
                result = this.updateTotal(result, target, property, filter, false);
            }
        }
        return result;
    }

    public Object sumMat(Object propertyOrExpression, PropertySource ps) {
        String s = propertyOrExpression.toString();
        if (s.startsWith("{")) {
            return this.sumMat((Object)"", propertyOrExpression, ps);
        }
        return this.sumMat(propertyOrExpression.toString(), null, ps);
    }

    public Object sumMat(Object property, Object expression, PropertySource ps) {
        PieceFilter filter = this.createFilter(expression, ps);
        return this.sumMat(property.toString(), filter, ps);
    }

    private Object sumMat(String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece mat;
            GamePiece gp = (GamePiece)ps;
            if (gp instanceof Decorator) {
                MatCargo cargo;
                mat = Decorator.getDecorator(gp = Decorator.getOutermost(gp), Mat.class);
                if (mat == null && (cargo = (MatCargo)Decorator.getDecorator(gp, MatCargo.class)) != null) {
                    mat = cargo.getMat();
                }
            } else {
                mat = null;
            }
            if (mat != null) {
                mat = Decorator.getOutermost(mat);
                Mat actualMat = (Mat)Decorator.getDecorator(mat, Mat.class);
                result = this.updateTotal(result, actualMat, property, filter, true);
                for (GamePiece cargo : actualMat.getContents()) {
                    result = this.updateTotal(result, cargo, property, filter, true);
                }
            } else {
                result = this.updateTotal(result, (GamePiece)ps, property, filter, true);
            }
        }
        return result;
    }

    public Object countMat(Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countMat((Object)"", propertyOrExpression, ps);
        }
        return this.countMat(propertyOrExpression.toString(), null, ps);
    }

    public Object countMat(PropertySource ps) {
        return this.countMat("", null, ps);
    }

    public Object countMat(Object property, Object expression, PropertySource ps) {
        PieceFilter filter = this.createFilter(expression, ps);
        return this.countMat(property.toString(), filter, ps);
    }

    private Object countMat(String property, PieceFilter filter, PropertySource ps) {
        int result = 0;
        if ((ps = this.translatePiece(ps)) instanceof GamePiece) {
            GamePiece mat;
            GamePiece gp = (GamePiece)ps;
            if (gp instanceof Decorator) {
                MatCargo cargo;
                mat = Decorator.getDecorator(gp = Decorator.getOutermost(gp), Mat.class);
                if (mat == null && (cargo = (MatCargo)Decorator.getDecorator(gp, MatCargo.class)) != null) {
                    mat = cargo.getMat();
                }
            } else {
                mat = null;
            }
            if (mat != null) {
                mat = Decorator.getOutermost(mat);
                Mat actualMat = (Mat)Decorator.getDecorator(mat, Mat.class);
                result = this.updateTotal(result, actualMat, property, filter, false);
                for (GamePiece cargo : actualMat.getContents()) {
                    result = this.updateTotal(result, cargo, property, filter, false);
                }
            } else {
                result = this.updateTotal(result, (GamePiece)ps, property, filter, false);
            }
        }
        return result;
    }

    public Object sumLocation(Object property, PropertySource ps) {
        return this.sumLocation(property, "", ps);
    }

    public Object sumLocation(Object property, Object expression, PropertySource ps) {
        GamePiece p;
        Map m;
        if (ps instanceof GamePiece && (m = (p = (GamePiece)ps).getMap()) != null) {
            String here = m.locationName(p.getPosition());
            return this.sumLocation(property, here, m.getConfigureName(), expression, ps);
        }
        return 0;
    }

    public Object sumLocation(Object property, Object location, Object map, PropertySource ps) {
        return this.sumLocation(property, location, map, "", ps);
    }

    public Object sumLocation(Object property, Object location, Object map, Object expression, PropertySource ps) {
        ps = this.translatePiece(ps);
        PieceFilter filter = this.createFilter(expression, ps, "SumLocation");
        Map targetMap = this.findVassalMap(map.toString());
        return targetMap == null ? Integer.valueOf(0) : this.sumLocation(property.toString(), location.toString(), targetMap, filter);
    }

    private Object sumLocation(String property, String locationName, Map map, PieceFilter filter) {
        int result = 0;
        for (GamePiece piece : GameModule.getGameModule().getIndexManager().getPieces(map, "LocationName", locationName)) {
            result = this.updateTotal(result, piece, property, filter, true);
        }
        return result;
    }

    public Object countLocation(PropertySource ps) {
        return this.countLocation("", ps);
    }

    public Object countLocation(Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countCurrentLocation("", propertyOrExpression, ps);
        }
        return this.countCurrentLocation(propertyOrExpression, "", ps);
    }

    public Object countLocation(Object propertyOrLocation, Object expressionOrMap, PropertySource ps) {
        if (expressionOrMap != null && expressionOrMap.toString().trim().startsWith("{")) {
            return this.countCurrentLocation(propertyOrLocation, expressionOrMap, ps);
        }
        return this.countMapLocation(propertyOrLocation, expressionOrMap, "", ps);
    }

    private Object countCurrentLocation(Object property, Object expression, PropertySource ps) {
        GamePiece p;
        Map m;
        if (ps instanceof GamePiece && (m = (p = (GamePiece)ps).getMap()) != null) {
            String here = m.locationName(p.getPosition());
            return this.countMapLocation(here, m.getConfigureName(), property, expression, ps);
        }
        return 0;
    }

    public Object countMapLocation(Object locationName, Object mapName, Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countMapLocation(locationName, mapName, "", propertyOrExpression, ps);
        }
        return this.countMapLocation(locationName, mapName, propertyOrExpression, "", ps);
    }

    public Object countMapLocation(Object locationName, Object mapName, Object property, Object expression, PropertySource ps) {
        ps = this.translatePiece(ps);
        PieceFilter filter = this.createFilter(expression, ps);
        Map targetMap = this.findVassalMap(mapName.toString());
        String propValue = property == null || property.toString().isEmpty() ? null : property.toString();
        return targetMap == null ? Integer.valueOf(0) : this.countLocation(locationName.toString(), targetMap, propValue, filter);
    }

    private Object countLocation(Object locationName, Map map, String property, PieceFilter filter) {
        int result = 0;
        for (GamePiece piece : GameModule.getGameModule().getIndexManager().getPieces(map, "LocationName", locationName.toString())) {
            result = this.updateTotal(result, piece, property, filter, false);
        }
        return result;
    }

    public Object sumZone(Object property, Object zone, Object map, Object expression, PropertySource ps) {
        String expr;
        ps = this.translatePiece(ps);
        String mapName = map == null ? "" : map.toString();
        String zoneName = zone == null ? "" : zone.toString();
        String string = expr = expression == null ? "" : expression.toString();
        if (ps instanceof GamePiece && mapName.isEmpty()) {
            mapName = (String)ps.getProperty("CurrentMap");
            zoneName = (String)ps.getProperty("CurrentZone");
        }
        PieceFilter filter = this.createFilter(expr, ps);
        Map targetMap = this.findVassalMap(mapName);
        return targetMap == null ? Integer.valueOf(0) : this.sumZone(property.toString(), zoneName, targetMap, filter);
    }

    private Object sumZone(String property, String zoneName, Map map, PieceFilter filter) {
        int result = 0;
        for (GamePiece piece : GameModule.getGameModule().getIndexManager().getPieces(map, "CurrentZone", zoneName)) {
            result = this.updateTotal(result, piece, property, filter, true);
        }
        return result;
    }

    public Object countZone(PropertySource ps) {
        return this.countCurrentZone("", "", ps);
    }

    public Object countZone(Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countCurrentZone("", propertyOrExpression, ps);
        }
        return this.countCurrentZone(propertyOrExpression, "", ps);
    }

    public Object countZone(Object propertyOrZone, Object expressionOrMap, PropertySource ps) {
        if (expressionOrMap != null && expressionOrMap.toString().trim().startsWith("{")) {
            return this.countCurrentZone(propertyOrZone, expressionOrMap, ps);
        }
        return this.countZone(propertyOrZone, expressionOrMap, (Object)"", ps);
    }

    public Object countCurrentZone(Object propertyName, Object expression, PropertySource ps) {
        if (ps instanceof GamePiece) {
            String mapName = (String)ps.getProperty("CurrentMap");
            String zoneName = (String)ps.getProperty("CurrentZone");
            return this.countZone(zoneName, mapName, propertyName, expression, ps);
        }
        return 0;
    }

    public Object countZone(Object zoneName, Object mapName, Object propertyOrExpression, PropertySource ps) {
        if (propertyOrExpression != null && propertyOrExpression.toString().trim().startsWith("{")) {
            return this.countZone(zoneName, mapName, "", propertyOrExpression, ps);
        }
        return this.countZone(zoneName, mapName, propertyOrExpression, "", ps);
    }

    public Object countZone(Object zoneName, Object mapName, Object property, Object expression, PropertySource ps) {
        ps = this.translatePiece(ps);
        PieceFilter filter = this.createFilter(expression, ps);
        Map targetMap = this.findVassalMap(mapName.toString());
        String propValue = property == null || property.toString().isEmpty() ? null : property.toString();
        return targetMap == null ? Integer.valueOf(0) : this.countZone(zoneName.toString(), targetMap, propValue, filter);
    }

    private Object countZone(String zoneName, Map map, String property, PieceFilter filter) {
        int result = 0;
        for (GamePiece piece : GameModule.getGameModule().getIndexManager().getPieces(map, "CurrentZone", zoneName)) {
            result = this.updateTotal(result, piece, property, filter, false);
        }
        return result;
    }

    public Object sumMap(Object property, PropertySource ps) {
        return this.sumMap(property, "", "", ps);
    }

    public Object sumMap(Object property, Object mapOrExpression, PropertySource ps) {
        if (mapOrExpression != null && mapOrExpression.toString().trim().startsWith("{")) {
            return this.sumMap(property, "", mapOrExpression, ps);
        }
        return this.sumMap(property, mapOrExpression, "", ps);
    }

    public Object sumMap(Object property, Object map, Object expression, PropertySource ps) {
        String mapName;
        String propertyName;
        ps = this.translatePiece(ps);
        String string = propertyName = property == null ? "" : property.toString();
        if (propertyName.isEmpty()) {
            return 0;
        }
        String string2 = mapName = map == null ? "" : map.toString();
        if (ps instanceof GamePiece && mapName.isEmpty()) {
            mapName = (String)ps.getProperty("CurrentMap");
        }
        PieceFilter filter = this.createFilter(expression, ps);
        Map targetMap = this.findVassalMap(mapName);
        return this.sumMap(propertyName, targetMap, filter);
    }

    private Object sumMap(String propertyName, Map map, PieceFilter filter) {
        int result = 0;
        if (map != null) {
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        result = this.updateTotal(result, p, propertyName, filter, true);
                    }
                    continue;
                }
                result = this.updateTotal(result, piece, propertyName, filter, true);
            }
        }
        return result;
    }

    public Object countMap(PropertySource ps) {
        return this.countMap("", "", "", ps);
    }

    public Object countMap(Object propertyOrExpressionOrMap, PropertySource ps) {
        if (propertyOrExpressionOrMap != null && propertyOrExpressionOrMap.toString().trim().startsWith("{")) {
            return this.countMap("", "", propertyOrExpressionOrMap, ps);
        }
        Map map = this.findVassalMap((String)propertyOrExpressionOrMap);
        if (map == null) {
            return this.countMap("", propertyOrExpressionOrMap, "", ps);
        }
        return this.countMap(propertyOrExpressionOrMap, "", "", ps);
    }

    public Object countMap(Object propertyOrMap, Object expressionOrProperty, PropertySource ps) {
        Object map = null;
        Object property = null;
        Object expression = null;
        if (expressionOrProperty != null && expressionOrProperty.toString().trim().startsWith("{")) {
            expression = expressionOrProperty;
            Map targetMap = this.findVassalMap((String)propertyOrMap);
            if (targetMap == null) {
                property = propertyOrMap;
            } else {
                map = propertyOrMap;
            }
        } else {
            map = propertyOrMap;
            property = expressionOrProperty;
        }
        return this.countMap(map, property, expression, ps);
    }

    public Object countMap(Object map, Object property, Object expression, PropertySource ps) {
        String mapName = map == null ? "" : map.toString();
        String propertyName = property == null ? "" : property.toString();
        Map targetMap = null;
        targetMap = ps instanceof GamePiece && mapName.isEmpty() ? ((GamePiece)ps).getMap() : this.findVassalMap(mapName);
        PieceFilter filter = this.createFilter(expression, ps);
        return this.countMap(targetMap, propertyName, filter);
    }

    private Object countMap(Map map, String propertyName, PieceFilter filter) {
        int result = 0;
        if (map != null) {
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        result = this.updateTotal(result, p, propertyName, filter, false);
                    }
                    continue;
                }
                result = this.updateTotal(result, piece, propertyName, filter, false);
            }
        }
        return result;
    }

    public Object rangeAttach(Object attachmentName, Object expression, boolean asPixels, PropertySource ps) {
        if (!(attachmentName instanceof String)) {
            return 0;
        }
        if (!(expression instanceof String)) {
            return 0;
        }
        PieceFilter filter = this.createFilter((String)expression, ps);
        return this.rangeAttach((String)attachmentName, filter, asPixels, ps);
    }

    private Object rangeAttach(String attachmentName, PieceFilter filter, boolean asPixels, PropertySource ps) {
        if (ps instanceof GamePiece) {
            Map map = ((GamePiece)ps).getMap();
            Point from = ((GamePiece)ps).getPosition();
            for (GamePiece target : Attachment.getAttachList((GamePiece)ps, attachmentName)) {
                if (target == ps || filter != null && !filter.accept(target)) continue;
                Map toMap = target.getMap();
                Point to = target.getPosition();
                if (map == null || !map.equals(toMap)) continue;
                return this.range(from, to, map, asPixels);
            }
        }
        return 0;
    }

    public Object rangeInPixels(Object x, Object y, PropertySource ps) {
        return this.rangeXY(x, y, ps, true);
    }

    public Object rangeInCells(Object x, Object y, PropertySource ps) {
        return this.rangeXY(x, y, ps, false);
    }

    private Object rangeXY(Object x, Object y, PropertySource ps, boolean asPixels) {
        if (ps instanceof GamePiece) {
            Map map = ((GamePiece)ps).getMap();
            Point from = ((GamePiece)ps).getPosition();
            return this.range(from, new Point(ExpressionInterpreter.IntPropValue(x), ExpressionInterpreter.IntPropValue(y)), map, asPixels);
        }
        return 0;
    }

    public Object rangeInPixels(Object x1, Object y1, Object x2, Object y2, PropertySource ps) {
        return this.rangeMap(x1, y1, x2, y2, (String)ps.getProperty("CurrentMap"), true);
    }

    public Object rangeInCells(Object x1, Object y1, Object x2, Object y2, PropertySource ps) {
        return this.rangeMap(x1, y1, x2, y2, (String)ps.getProperty("CurrentMap"), false);
    }

    public Object rangeInPixels(Object x1, Object y1, Object x2, Object y2, Object mapName, PropertySource ps) {
        return this.rangeMap(x1, y1, x2, y2, mapName, true);
    }

    public Object rangeInCells(Object x1, Object y1, Object x2, Object y2, Object mapName, PropertySource ps) {
        return this.rangeMap(x1, y1, x2, y2, mapName, false);
    }

    private Object rangeMap(Object x1, Object y1, Object x2, Object y2, Object mapName, boolean asPixels) {
        Point from = new Point(ExpressionInterpreter.IntPropValue(x1), ExpressionInterpreter.IntPropValue(y1));
        Point to = new Point(ExpressionInterpreter.IntPropValue(x2), ExpressionInterpreter.IntPropValue(y2));
        Map map = Map.getMapById(mapName.toString());
        return this.range(from, to, map, asPixels);
    }

    private int range(Point from, Point to, Map map, boolean asPixels) {
        if (from == null || to == null) {
            return 0;
        }
        if (asPixels || map == null || map.findBoard(from) == null || map.findBoard(from).getGrid() == null) {
            return (int)Math.round(from.distance(to));
        }
        return map.findBoard(from).getGrid().range(from, to);
    }

    public Object sumRange(Object propertyName, Object expression, Object minRange, Object maxRange, Boolean asPixels, PropertySource ps) {
        String property = propertyName == null ? null : propertyName.toString();
        return this.sumOrCountRange(property, expression, minRange, maxRange, asPixels, true, ps);
    }

    public Object countRange(Object propertyOrExpression, Object expression, Object minRange, Object maxRange, Boolean asPixels, PropertySource ps) {
        String prop = propertyOrExpression.toString();
        String expr = expression.toString();
        if (prop.startsWith("{")) {
            expr = prop;
            prop = "";
        }
        return this.sumOrCountRange(prop, expr, minRange, maxRange, asPixels, false, ps);
    }

    private Object sumOrCountRange(String propertyName, Object expression, Object minRange, Object maxRange, boolean asPixels, boolean doSum, PropertySource ps) {
        int max;
        PieceFilter filter = this.createFilter(expression, ps);
        if (!(ps instanceof GamePiece)) {
            return 0;
        }
        int result = 0;
        GamePiece sourcePiece = (GamePiece)ps;
        if (sourcePiece == null || sourcePiece.getMap() == null) {
            return result;
        }
        int min = ExpressionInterpreter.IntPropValue(minRange);
        if (min < 0) {
            min = 0;
        }
        if ((max = ExpressionInterpreter.IntPropValue(maxRange)) < min) {
            max = min;
        }
        Point position = sourcePiece.getPosition();
        for (GamePiece piece : GameModule.getGameModule().getIndexManager().getPieces(sourcePiece, max, asPixels)) {
            int range;
            if (min > 0 && (range = this.range(position, piece.getPosition(), sourcePiece.getMap(), asPixels)) < min) continue;
            result = this.updateTotal(result, piece, propertyName, filter, doSum);
        }
        if (min == 0) {
            result = this.updateTotal(result, sourcePiece, propertyName, filter, doSum);
        }
        return result;
    }

    private int updateTotal(int currentTotal, GamePiece piece, String propertyName, PieceFilter filter, boolean doSum) {
        int newTotal = currentTotal;
        if (filter != null && !filter.accept(piece)) {
            return newTotal;
        }
        String value = "";
        if (propertyName != null && !propertyName.isEmpty() && (value = (String)piece.getProperty(propertyName)) == null) {
            value = "";
        }
        if (doSum) {
            newTotal += ExpressionInterpreter.IntPropValue(value);
        } else if (propertyName == null || propertyName.isEmpty() || !value.isEmpty()) {
            ++newTotal;
        }
        return newTotal;
    }

    public Object random(Object src, Object minString, Object maxString) {
        int min = this.parseInt(src, "Random", minString, 1);
        int max = this.parseInt(src, "Random", maxString, 1);
        if (max < min) {
            max = min;
        }
        if (min == max) {
            return min;
        }
        int range = max - min + 1;
        return GameModule.getGameModule().getRNG().nextInt(range) + min;
    }

    public Object isRandom(Object src, Object percentString) {
        int r;
        int percent = this.parseInt(src, "IsRandom", percentString, 50);
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        return (r = GameModule.getGameModule().getRNG().nextInt(100) + 1) <= percent;
    }

    private int parseInt(Object src, String function, Object value, int dflt) {
        int result = dflt;
        try {
            result = Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            String message = "Illegal number in call to Beanshell function " + function + ". " + (String)(src instanceof Decorator ? "Piece= [" + String.valueOf(((Decorator)src).getProperty("BasicName")) + "]. " : "");
            String data = "Data=[" + value.toString() + "].";
            ErrorDialog.dataWarning(new BadDataReport(message, data, e));
        }
        return result;
    }

    public Object sum(Object src, Object propertyName, Object propertyMatch) {
        return this.sum(src, propertyName, propertyMatch, null);
    }

    public Object sum(Object src, Object propertyName, Object propertyMatch, Object mapName) {
        int result = 0;
        List<Object> mapList = new ArrayList();
        if (!(src instanceof PropertySource)) {
            return 0;
        }
        if (!(propertyName instanceof String)) {
            return 0;
        }
        if (propertyMatch != null && !(propertyMatch instanceof String)) {
            return 0;
        }
        if (mapName != null && !(mapName instanceof String)) {
            return 0;
        }
        PieceFilter filter = this.createFilter((String)propertyMatch, (PropertySource)src);
        if (src instanceof GamePiece) {
            mapList = this.getMapList(mapName, (GamePiece)src);
        } else if (mapName != null && !((String)mapName).isEmpty()) {
            mapList.add(this.findVassalMap((String)mapName));
        } else if (src instanceof GameModule) {
            mapList = Map.getMapList();
        } else if (src instanceof Map) {
            mapList.add((Map)src);
        } else if (src instanceof ReportState.OldAndNewPieceProperties) {
            mapList.add(((ReportState.OldAndNewPieceProperties)src).getNewPiece().getMap());
        } else {
            return 0;
        }
        for (Map map : mapList) {
            if (map == null) continue;
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        result += this.getIntPropertyValue(p, filter, (String)propertyName);
                    }
                    continue;
                }
                result += this.getIntPropertyValue(piece, filter, (String)propertyName);
            }
        }
        return result;
    }

    private int getIntPropertyValue(GamePiece piece, PieceFilter filter, String propertyName) {
        if (filter == null || filter.accept(piece)) {
            try {
                return Integer.parseInt((String)piece.getProperty(propertyName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public Object count(Object src, Object propertyMatch) {
        return this.count(src, propertyMatch, null);
    }

    public Object count(Object src, Object propertyMatch, Object mapName) {
        PieceFilter filter;
        int result = 0;
        List<Object> mapList = new ArrayList();
        if (!(src instanceof PropertySource)) {
            return 0;
        }
        if (propertyMatch != null && !(propertyMatch instanceof String)) {
            return 0;
        }
        if (mapName != null && !(mapName instanceof String)) {
            return 0;
        }
        String matchString = this.replaceDollarVariables((String)propertyMatch, (PropertySource)src);
        PieceFilter pieceFilter = filter = matchString == null ? null : new PropertyExpression(this.unescape(matchString)).getFilter((PropertySource)src);
        if (src instanceof GamePiece) {
            mapList = this.getMapList(mapName, (GamePiece)src);
        } else if (mapName != null && !((String)mapName).isEmpty()) {
            mapList.add(this.findVassalMap((String)mapName));
        } else if (src instanceof GameModule) {
            mapList = Map.getMapList();
        } else if (src instanceof Map) {
            mapList.add((Map)src);
        } else if (src instanceof ReportState.OldAndNewPieceProperties) {
            mapList.add(((ReportState.OldAndNewPieceProperties)src).getNewPiece().getMap());
        } else {
            return 0;
        }
        for (Map map : mapList) {
            if (map == null) continue;
            for (GamePiece piece : map.getAllPieces()) {
                if (piece instanceof Stack) {
                    for (GamePiece p : ((Stack)piece).asList()) {
                        if (filter != null && !filter.accept(p)) continue;
                        ++result;
                    }
                    continue;
                }
                if (filter != null && !filter.accept(piece)) continue;
                ++result;
            }
        }
        return result;
    }

    private String unescape(String expr) {
        return expr.replace("\\\"", "\"");
    }

    private List<Map> getMapList(Object mapName, GamePiece sourcePiece) {
        if (mapName == null) {
            return Map.getMapList();
        }
        if (sourcePiece != null && sourcePiece.getMap() != null && sourcePiece.getMap().getMapName().equals(mapName)) {
            return List.of(sourcePiece.getMap());
        }
        for (Map map : Map.getMapList()) {
            if (!map.getMapName().equals(mapName)) continue;
            return List.of(map);
        }
        return new ArrayList<Map>();
    }

    private Map findVassalMap(String mapName) {
        for (Map map : Map.getMapList()) {
            if (!map.getMapName().equals(mapName)) continue;
            return map;
        }
        return null;
    }

    private String replaceDollarVariables(String expression, GamePiece src) {
        return this.replaceDollarVariables(expression, (PropertySource)src);
    }

    private String replaceDollarVariables(String expression, PropertySource src) {
        if (expression == null || !expression.contains("$")) {
            return expression;
        }
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        StringBuilder propertyName = new StringBuilder();
        block4: for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '$') {
                        state = 1;
                        propertyName.setLength(0);
                        continue block4;
                    }
                    buffer.append(c);
                    continue block4;
                }
                case 1: {
                    if (c == '$') {
                        String propertyValue;
                        String propName = propertyName.toString();
                        Object prop = src == null ? null : src.getLocalizedProperty(propName);
                        String string = propertyValue = prop == null ? null : prop.toString();
                        if (propertyValue == null) {
                            buffer.append('$');
                            buffer.append((CharSequence)propertyName);
                            propertyName.setLength(0);
                            state = 1;
                            continue block4;
                        }
                        buffer.append(propertyValue);
                        state = 0;
                        continue block4;
                    }
                    propertyName.append(c);
                }
            }
        }
        if (state == 1) {
            buffer.append('$');
            buffer.append((CharSequence)propertyName);
        }
        return buffer.toString();
    }

    public Object audit(Object message, Object conditionOrOptionList, Object optionList, PropertySource ps) {
        Expression expr;
        String result;
        String combined;
        if (ps instanceof GamePiece && ((GamePiece)ps).getMap() == null) {
            return "";
        }
        String condition = "";
        String options = optionList == null ? "" : optionList.toString();
        String string = combined = conditionOrOptionList == null ? "" : conditionOrOptionList.toString();
        if (!combined.isEmpty()) {
            if (combined.startsWith("{")) {
                condition = combined;
            } else {
                options = combined;
            }
        }
        if (!condition.isEmpty() && !"true".equals(result = (expr = BeanShellExpression.createExpression(condition)).quietEvaluate(ps, null, ""))) {
            return "";
        }
        Object mess = "Audit: " + message.toString();
        if (((String)mess).startsWith("{")) {
            Expression expr2 = BeanShellExpression.createExpression((String)mess);
            mess = expr2.quietEvaluate(ps, null, "");
        }
        if (options.indexOf(70) >= 0) {
            mess = (String)mess + "\n" + this.currentAudit.toString();
        }
        if (options.indexOf(83) < 0) {
            logger.warn((String)mess);
        }
        if (options.indexOf(67) >= 0) {
            GameModule.getGameModule().warn((String)mess);
        }
        return "";
    }

    public Object sleep(Object ms, PropertySource ps) {
        int milliSeconds = ExpressionInterpreter.IntPropValue(ms);
        JDialog dialog = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
        dialog.setLocation(-5000, -5000);
        SwingUtilities.invokeLater(new DialogCloser(dialog, milliSeconds));
        dialog.setVisible(true);
        return "";
    }
}

