/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public class NamedKeyManager {
    protected static final NamedKeyManager instance = new NamedKeyManager();
    protected static final int NAMED_START = 57344;
    protected static final int NAMED_END = 63742;
    protected static int nextNamedKey = 57344;
    protected static final Map<String, KeyStroke> strokes = new HashMap<String, KeyStroke>();

    public static NamedKeyManager getInstance() {
        return instance;
    }

    public static boolean isNamed(KeyStroke k) {
        if (k == null) {
            return false;
        }
        int code = k.getKeyCode();
        return code >= 57344 && code <= 63742;
    }

    public KeyStroke getKeyStroke(String name, KeyStroke ks) {
        if (name == null || name.isEmpty()) {
            return ks;
        }
        return strokes.computeIfAbsent(name, k -> KeyStroke.getKeyStroke(this.getNextStroke(), 0));
    }

    public int getNextStroke() {
        if (nextNamedKey == 63742) {
            throw new IllegalStateException("Too many Named Keys");
        }
        return nextNamedKey++;
    }
}

