/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceTileOpBitmapImpl;
import VASSAL.tools.io.FileArchive;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;

public class SourceOpBitmapImpl
extends AbstractTiledOpImpl
implements SourceOp {
    protected final String name;
    protected final int hash;
    protected final DataArchive darch;
    protected final FileArchive farch;

    public SourceOpBitmapImpl(String name) {
        this(name, GameModule.getGameModule().getDataArchive());
    }

    public SourceOpBitmapImpl(String name, DataArchive archive) {
        this(name, archive, null);
    }

    public SourceOpBitmapImpl(String name, FileArchive archive) {
        this(name, null, archive);
    }

    protected SourceOpBitmapImpl(String name, DataArchive da, FileArchive fa) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (da == null && fa == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.darch = da;
        this.farch = fa;
        this.hash = name.hashCode() ^ (this.darch != null ? this.darch.hashCode() : this.farch.hashCode());
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    protected InputStream getInputStream() throws IOException {
        return this.darch != null ? this.darch.getInputStream(this.name) : this.farch.getInputStream(this.name);
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        BufferedImage bufferedImage;
        block10: {
            InputStream in = this.getInputStream();
            try {
                bufferedImage = ImageUtils.getImage(this.name, in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ImageIOException e) {
                    throw e;
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    throw new ImageNotFoundException(this.name, (Throwable)e);
                }
                catch (IOException e) {
                    throw new ImageIOException(this.name, (Throwable)e);
                }
            }
            in.close();
        }
        return bufferedImage;
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    protected Dimension getImageSize() {
        Dimension dimension;
        block13: {
            InputStream in = this.getInputStream();
            try {
                dimension = ImageUtils.getImageSize(this.name, in);
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ImageIOException e) {
                        throw e;
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        throw new ImageNotFoundException(this.name, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new ImageIOException(this.name, (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!Op.handleException(e)) {
                        ErrorDialog.bug(e);
                    }
                    return new Dimension();
                }
            }
            in.close();
        }
        return dimension;
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new SourceTileOpBitmapImpl(this, tileX, tileY);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceOpBitmapImpl s = (SourceOpBitmapImpl)o;
        return this.darch == s.darch && this.farch == s.farch && this.name.equals(s.name);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + "]";
    }
}

