/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.GridOp;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SolidColorOp;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.imageop.FixedScaleOpBitmapImpl;
import VASSAL.tools.imageop.FixedScaleOpTiledBitmapImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.Repainter;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceOpTiledBitmapImpl;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.w3c.dom.Element;

public class Board
extends AbstractConfigurable
implements GridContainer {
    public static final String NAME = "name";
    public static final String IMAGE = "image";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String COLOR = "color";
    public static final String REVERSIBLE = "reversible";
    protected Point pos = new Point(0, 0);
    protected Rectangle boundaries = new Rectangle(0, 0, 500, 500);
    protected String imageFile;
    protected boolean reversible = false;
    protected boolean reversed = false;
    protected boolean fixedBoundaries = false;
    protected Color color = null;
    protected MapGrid grid = null;
    protected Map map;
    protected double magnification = 1.0;
    protected boolean cacheGrid = true;
    protected SourceOp boardImageOp;
    protected ScaleOp scaledImageOp;
    private static final Color CLEAR = new Color(0, 0, 0, 0);
    private final ConcurrentMap<Point, Future<BufferedImage>> requested = new ConcurrentHashMap<Point, Future<BufferedImage>>();
    private final java.util.Map<Point, Float> alpha = new ConcurrentHashMap<Point, Float>();
    private final ConcurrentMap<Point, Future<BufferedImage>> o_requested = new ConcurrentHashMap<Point, Future<BufferedImage>>();
    private static final Comparator<Point> tileOrdering = (t1, t2) -> {
        if (t1.y < t2.y) {
            return -1;
        }
        if (t1.y > t2.y) {
            return 1;
        }
        return t1.x - t2.x;
    };

    public Map getMap() {
        return this.map;
    }

    public void setCacheGrid(boolean cg) {
        this.cacheGrid = cg;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public String getLocalizedName() {
        String s = this.getLocalizedConfigureName();
        return s != null ? s : "";
    }

    public String getName() {
        String s = this.getConfigureName();
        return s != null ? s : "";
    }

    @Override
    public void build(Element e) {
        super.build(e);
        if (e == null) {
            this.setConfigureName(Resources.getString("Editor.Board.component_type"));
        }
    }

    @Override
    public void addTo(Buildable b) {
        this.validator = new SingleChildInstance(this, MapGrid.class);
    }

    @Override
    public void removeFrom(Buildable b) {
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, IMAGE, REVERSIBLE, WIDTH, HEIGHT, COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.Board.image"), Resources.getString("Editor.Board.reverse"), Resources.getString("Editor.Board.width"), Resources.getString("Editor.Board.height"), Resources.getString("Editor.color_label")};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Board.component_type");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class, Boolean.class, Integer.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (REVERSIBLE.equals(name)) {
            return () -> this.imageFile != null;
        }
        if (List.of(WIDTH, HEIGHT, COLOR).contains(name)) {
            return () -> this.imageFile == null;
        }
        return null;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (IMAGE.equals(key)) {
            return this.imageFile;
        }
        if (WIDTH.equals(key)) {
            return this.imageFile == null ? String.valueOf(this.boundaries.width) : null;
        }
        if (HEIGHT.equals(key)) {
            return this.imageFile == null ? String.valueOf(this.boundaries.height) : null;
        }
        if (COLOR.equals(key)) {
            return this.imageFile == null ? ColorConfigurer.colorToString(this.color) : null;
        }
        if (REVERSIBLE.equals(key)) {
            return String.valueOf(this.reversible);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
        } else if (IMAGE.equals(key)) {
            if (val instanceof File) {
                val = ((File)val).getName();
            }
            this.imageFile = (String)val;
            if (this.imageFile == null || this.imageFile.isBlank()) {
                this.boardImageOp = null;
            } else {
                ImageTileSource ts = GameModule.getGameModule().getImageTileSource();
                boolean tiled = false;
                try {
                    tiled = ts.tileExists("images/" + this.imageFile, 0, 0, 1.0);
                }
                catch (ImageIOException imageIOException) {
                    // empty catch block
                }
                this.boardImageOp = tiled ? Op.loadLarge(this.imageFile) : Op.load(this.imageFile);
            }
        } else if (WIDTH.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            if (val != null) {
                this.boundaries.setSize((Integer)val, this.boundaries.height);
            }
        } else if (HEIGHT.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            if (val != null) {
                this.boundaries.setSize(this.boundaries.width, (Integer)val);
            }
        } else if (COLOR.equals(key)) {
            if (val instanceof String) {
                val = ColorConfigurer.stringToColor((String)val);
            }
            this.color = (Color)val;
        } else if (REVERSIBLE.equals(key)) {
            if (val instanceof String) {
                val = Boolean.valueOf((String)val);
            }
            this.reversible = (Boolean)val;
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{HexGrid.class, SquareGrid.class, RegionGrid.class, ZonedGrid.class};
    }

    public void draw(Graphics g, int x, int y, double zoom, Component obs) {
        this.drawRegion(g, new Point(x, y), new Rectangle(x, y, Math.round((float)zoom * (float)this.boundaries.width), Math.round((float)zoom * (float)this.boundaries.height)), zoom, obs);
    }

    protected void drawTile(Graphics g, Future<BufferedImage> fim, int tx, int ty, Component obs) {
        block4: {
            try {
                g.drawImage(fim.get(), tx, ty, obs);
            }
            catch (CancellationException e) {
                ErrorDialog.bug(e);
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                if (Op.handleException(e)) break block4;
                ErrorDialog.bug(e);
            }
        }
    }

    public void drawRegion(Graphics g, Point location, Rectangle visibleRect, double zoom, Component obs) {
        this.drawRegion2D(g, location, visibleRect, zoom, obs);
    }

    public void drawRegion2D(Graphics g, Point2D location, Rectangle visibleRect, double zoom, final Component obs) {
        Point[] tiles;
        ImageOp op;
        int ly;
        int lx = (int)Math.floor(location.getX());
        Rectangle bounds = new Rectangle(lx, ly = (int)Math.floor(location.getY()), (int)Math.floor(location.getX() + (double)this.boundaries.width * zoom) - lx, (int)Math.floor(location.getY() + (double)this.boundaries.height * zoom) - ly);
        if (!visibleRect.intersects(bounds)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        visibleRect = visibleRect.intersection(bounds);
        zoom *= this.magnification;
        if (this.boardImageOp != null) {
            if (zoom == 1.0 && !this.reversed) {
                op = this.boardImageOp;
            } else {
                if (this.scaledImageOp == null || this.scaledImageOp.getScale() != zoom) {
                    this.scaledImageOp = this.boardImageOp instanceof SVGOp ? Op.scale(this.boardImageOp, zoom) : (this.boardImageOp instanceof SourceOpTiledBitmapImpl ? new FixedScaleOpTiledBitmapImpl(this.boardImageOp, zoom, bounds.width, bounds.height) : new FixedScaleOpBitmapImpl(this.boardImageOp, zoom, bounds.width, bounds.height));
                }
                op = this.reversed ? Op.rotate(this.scaledImageOp, 180.0) : this.scaledImageOp;
            }
        } else {
            op = new SolidColorOp(this.color == null ? CLEAR : this.color, bounds.width, bounds.height);
        }
        if (this.cacheGrid && this.grid != null) {
            op = new GridOp(op, this.grid, zoom, this.reversed, g2d.getRenderingHints());
        }
        Rectangle r = new Rectangle(visibleRect.x - lx, visibleRect.y - ly, visibleRect.width, visibleRect.height);
        int ow = op.getTileWidth();
        int oh = op.getTileHeight();
        for (Point tile : tiles = op.getTileIndices(r)) {
            int tx = lx + tile.x * ow;
            int ty = ly + tile.y * oh;
            int tw = Math.min(ow, lx + bounds.width - tx);
            int th = Math.min(oh, ly + bounds.height - ty);
            final int cx = (int)((double)tx / os_scale);
            final int cy = (int)((double)ty / os_scale);
            final int cw = (int)Math.ceil((double)tw / os_scale);
            final int ch = (int)Math.ceil((double)th / os_scale);
            Repainter rep = obs == null ? null : new Repainter(obs, cx, cy, cw, ch);
            try {
                Future<BufferedImage> fim = op.getFutureTile(tile.x, tile.y, rep);
                if (obs == null) {
                    this.drawTile(g, fim, tx, ty, obs);
                    continue;
                }
                if (fim.isDone()) {
                    if (this.map != null && obs == this.map.getView()) {
                        if (this.requested.containsKey(tile)) {
                            this.requested.remove(tile);
                            final Point t = tile;
                            Animator a = new Animator(100, (TimingTarget)new TimingTargetAdapter(){

                                public void timingEvent(float fraction) {
                                    Board.this.alpha.put(t, Float.valueOf(fraction));
                                    obs.repaint(cx, cy, cw, ch);
                                }
                            });
                            a.setResolution(20);
                            a.start();
                            continue;
                        }
                        Float a = this.alpha.get(tile);
                        if (a != null && a.floatValue() < 1.0f) {
                            Composite oldComp = g2d.getComposite();
                            g2d.setComposite(AlphaComposite.getInstance(3, a.floatValue()));
                            this.drawTile(g2d, fim, tx, ty, obs);
                            g2d.setComposite(oldComp);
                            continue;
                        }
                        this.alpha.remove(tile);
                        this.drawTile(g, fim, tx, ty, obs);
                        continue;
                    }
                    if (this.o_requested.containsKey(tile)) {
                        this.o_requested.remove(tile);
                        obs.repaint(cx, cy, cw, ch);
                        continue;
                    }
                    this.drawTile(g, fim, tx, ty, obs);
                    continue;
                }
                if (this.map != null && obs == this.map.getView()) {
                    this.requested.putIfAbsent(tile, fim);
                    continue;
                }
                this.o_requested.putIfAbsent(tile, fim);
            }
            catch (CancellationException | ExecutionException e) {
                ErrorDialog.bug(e);
            }
        }
        if (this.map != null && obs == this.map.getView()) {
            for (Point tile : this.requested.keySet().toArray(new Point[0])) {
                if (Arrays.binarySearch(tiles, tile, tileOrdering) >= 0) continue;
                this.requested.remove(tile);
            }
        } else {
            for (Point tile : this.o_requested.keySet().toArray(new Point[0])) {
                if (Arrays.binarySearch(tiles, tile, tileOrdering) >= 0) continue;
                this.o_requested.remove(tile);
            }
        }
        if (!this.cacheGrid && this.grid != null) {
            this.grid.draw(g, bounds, visibleRect, zoom, this.reversed);
        }
    }

    public void setReversed(boolean val) {
        if (this.reversible && this.reversed != val) {
            this.reversed = val;
            this.scaledImageOp = null;
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Point localCoordinates(Point p) {
        if (this.reversed) {
            p.x = this.bounds().width - p.x;
            p.y = this.bounds().height - p.y;
        }
        if (this.magnification != 1.0) {
            p.x = (int)Math.round((double)p.x / this.magnification);
            p.y = (int)Math.round((double)p.y / this.magnification);
        }
        return p;
    }

    public Point globalCoordinates(Point p) {
        if (this.magnification != 1.0) {
            p.x = (int)Math.round((double)p.x * this.magnification);
            p.y = (int)Math.round((double)p.y * this.magnification);
        }
        if (this.reversed) {
            p.x = this.bounds().width - p.x;
            p.y = this.bounds().height - p.y;
        }
        return p;
    }

    @Override
    public void setGrid(MapGrid mg) {
        this.grid = mg;
    }

    @Override
    public void removeGrid(MapGrid grid) {
        if (this.grid == grid) {
            this.grid = null;
        }
    }

    @Override
    public Board getBoard() {
        return this;
    }

    @Override
    public Dimension getSize() {
        return this.bounds().getSize();
    }

    @Override
    public boolean contains(Point p) {
        return this.bounds().contains(p);
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public Board copy() {
        Board b = new Board();
        b.build(this.getBuildElement(Builder.createNewDocument()));
        return b;
    }

    public String locationName(Point p) {
        return this.grid == null ? null : this.grid.locationName(this.localCoordinates(p));
    }

    public String localizedLocationName(Point p) {
        return this.grid == null ? null : this.grid.localizedLocationName(this.localCoordinates(p));
    }

    public Point snapTo(Point p, boolean force, boolean onlyCenter) {
        return this.grid == null ? p : this.globalCoordinates(this.grid.snapTo(this.localCoordinates(p), force, onlyCenter));
    }

    public Point snapTo(Point p, boolean force) {
        return this.snapTo(p, force, false);
    }

    public Point snapTo(Point p) {
        return this.snapTo(p, false, false);
    }

    public boolean isLocationRestricted(Point p) {
        return this.grid != null && this.grid.isLocationRestricted(this.localCoordinates(p));
    }

    public String fileName() {
        return this.imageFile;
    }

    public Point relativePosition() {
        return this.pos;
    }

    public Rectangle bounds() {
        if (this.imageFile != null && this.boardImageOp != null && !this.fixedBoundaries) {
            this.boundaries.setSize(this.boardImageOp.getSize());
            if (this.magnification != 1.0) {
                this.boundaries.setSize((int)Math.round(this.magnification * (double)this.boundaries.width), (int)Math.round(this.magnification * (double)this.boundaries.height));
            }
            this.fixedBoundaries = true;
        }
        return new Rectangle(this.boundaries);
    }

    public void translate(int x, int y) {
        this.boundaries.translate(x, y);
    }

    public void setLocation(int x, int y) {
        this.boundaries.setLocation(x, y);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Board.html");
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
        this.fixedBoundaries = false;
        this.bounds();
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.imageFile != null) {
            s.add(this.imageFile);
        }
    }
}

