/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.PrivateChatter;
import VASSAL.command.Command;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class PrivMsgCommand
extends Command {
    private final PrivateChatManager mgr;
    private final String msg;
    private final Player p;

    public PrivMsgCommand(PrivateChatManager mgr, Player sender, String msg) {
        this.mgr = mgr;
        this.msg = msg;
        this.p = sender;
    }

    @Override
    public void executeCommand() {
        PrivateChatter chat = this.mgr.getChatterFor(this.p);
        if (chat == null) {
            return;
        }
        Window f = SwingUtilities.getWindowAncestor(chat);
        f.setAutoRequestFocus(false);
        if (!f.isVisible()) {
            f.setVisible(true);
            Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (c == null || !SwingUtilities.isDescendingFrom(c, f)) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            f.toFront();
        }
        chat.show(this.msg);
    }

    @Override
    public Command myUndoCommand() {
        return null;
    }

    @Override
    public boolean isLoggable() {
        return false;
    }

    public Player getSender() {
        return this.p;
    }

    public String getMessage() {
        return this.msg;
    }
}

