/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.Node;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.Properties;

public class Protocol {
    public static final String REGISTER = "REG\t";
    public static final String REG_REQUEST = "REG_REQUEST\t";
    public static final String JOIN = "JOIN\t";
    public static final String FORWARD = "FWD\t";
    public static final String STATS = "STATS\t";
    public static final String LIST = "LIST\t";
    public static final String CONTENTS = "SERVER_CONTENTS\t";
    public static final String NODE_INFO = "NODE_INFO\t";
    public static final String ROOM_INFO = "ROOM_INFO\t";
    public static final String LOGIN = "LOGIN\t";
    public static final String KICK = "KICK\t";

    public static String encodeRegisterCommand(String id, String initialPath, String info) {
        String msg = new SequenceEncoder(id, '\t').append(initialPath).append(info).getValue();
        return REGISTER + msg;
    }

    public static String[] decodeRegisterCommand(String cmd) {
        String[] info = null;
        if (cmd.startsWith(REGISTER)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cmd.substring(REGISTER.length()), '\t');
            info = new String[]{st.nextToken(), st.nextToken(), st.nextToken()};
        }
        return info;
    }

    public static String encodeJoinCommand(String newParentPath) {
        return JOIN + newParentPath;
    }

    public static String encodeJoinCommand(String newParentPath, String password) {
        return JOIN + newParentPath + "\t" + password;
    }

    public static String[] decodeJoinCommand(String cmd) {
        String[] info = null;
        if (cmd.startsWith(JOIN)) {
            String[] parts = cmd.split("\\t");
            if (parts.length == 2) {
                info = new String[]{parts[1]};
            } else if (parts.length == 3) {
                info = new String[]{parts[1], parts[2]};
            }
        }
        return info;
    }

    public static String encodeForwardCommand(String recipientPath, String message) {
        String msg = new SequenceEncoder(recipientPath, '\t').append(message).getValue();
        return FORWARD + msg;
    }

    public static String[] decodeForwardCommand(String cmd) {
        String[] info = null;
        if (cmd.startsWith(FORWARD)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cmd.substring(FORWARD.length()), '\t');
            info = new String[]{st.nextToken(), st.nextToken()};
        }
        return info;
    }

    public static String encodeStatsCommand(String info) {
        return STATS + info;
    }

    public static String[] decodeStatsCommand(String cmd) {
        String[] info = null;
        if (cmd.startsWith(STATS)) {
            info = new String[]{cmd.substring(STATS.length())};
        }
        return info;
    }

    public static String encodeNodeInfoCommand(Node n) {
        String info = n.getInfo();
        if (info == null) {
            info = "";
        }
        return NODE_INFO + new SequenceEncoder(n.getPath(), '=').append(info).getValue();
    }

    public static String[] decodeNodeInfoCommand(String cmd) {
        String[] s = null;
        if (cmd.startsWith(NODE_INFO)) {
            s = new String[2];
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cmd.substring(NODE_INFO.length()), '=');
            s[0] = st.nextToken();
            s[1] = st.nextToken();
        }
        return s;
    }

    public static String encodeRoomsInfo(Node[] rooms) {
        Properties p = new Properties();
        for (Node room : rooms) {
            if (room.getInfo() == null || room.getInfo().length() <= 0) continue;
            p.setProperty(room.getId(), room.getInfo());
        }
        String value = new PropertiesEncoder(p).getStringValue();
        return value == null ? ROOM_INFO : ROOM_INFO + value;
    }

    public static Properties decodeRoomsInfo(String cmd) {
        Properties p = null;
        if (cmd.startsWith(ROOM_INFO)) {
            try {
                p = new PropertiesEncoder(cmd.substring(ROOM_INFO.length())).getProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public static String encodeListCommand(Node[] nodes) {
        SequenceEncoder list = new SequenceEncoder('\t');
        for (Node node : nodes) {
            if (node.getPath() == null || node.getInfo() == null) continue;
            SequenceEncoder info = new SequenceEncoder('=');
            info.append(node.getPath()).append(node.getInfo());
            list.append(info.getValue());
        }
        String value = list.getValue();
        return value == null ? LIST : LIST + value;
    }

    public static Node decodeListCommand(String cmd) {
        Node node = null;
        if (cmd.startsWith(LIST)) {
            Node root = new Node(null, null, null);
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cmd.substring(LIST.length()), '\t');
            while (st.hasMoreTokens()) {
                String nodeInfo = st.nextToken();
                SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(nodeInfo, '=');
                String path = st2.nextToken();
                String info = st2.nextToken();
                Node.build(root, path).setInfo(info);
            }
            node = root;
        }
        return node;
    }

    public static boolean decodeRegisterRequest(String cmd) {
        return cmd.startsWith(REG_REQUEST);
    }

    public static String encodeRegisterRequest() {
        return REG_REQUEST;
    }

    public static String encodeLoginCommand(String username) {
        return LOGIN + username;
    }

    public static String decodeLoginCommand(String cmd) {
        String username = null;
        if (cmd.startsWith(LOGIN)) {
            username = cmd.substring(LOGIN.length());
        }
        return username;
    }

    public static String encodeKickCommand(String kickeeId) {
        return KICK + kickeeId;
    }

    public static String[] decodeKickCommand(String cmd) {
        String[] player = null;
        if (cmd.startsWith(KICK)) {
            player = new String[]{cmd.substring(KICK.length())};
        }
        return player;
    }
}

