/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.KeyNamer;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.folder.GlobalPropertyFolder;
import VASSAL.build.module.folder.PrototypeFolder;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.properties.ChangePropertyButton;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.GlobalTranslatableMessage;
import VASSAL.build.module.properties.ZoneProperty;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.EditContainedPiecesAction;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.ExtensionTree;
import VASSAL.configure.HintTextField;
import VASSAL.configure.OpenContainedPiecesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.MassPieceLoader;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateAction;
import VASSAL.launch.EditorWindow;
import VASSAL.preferences.Prefs;
import VASSAL.search.SearchTarget;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ConfigureTree
extends JTree
implements PropertyChangeListener,
MouseListener,
MouseMotionListener,
TreeSelectionListener,
TreeExpansionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ConfigureTree.class);
    protected Map<Configurable, DefaultMutableTreeNode> nodes = new HashMap<Configurable, DefaultMutableTreeNode>();
    protected DefaultMutableTreeNode copyData;
    protected DefaultMutableTreeNode cutData;
    protected HelpWindow helpWindow;
    protected EditorWindow editorWindow;
    protected Configurable selected;
    protected int selectedRow;
    protected String searchCmd;
    protected String moveCmd;
    protected String deleteCmd;
    protected String pasteCmd;
    protected String copyCmd;
    protected String cutCmd;
    protected String helpCmd;
    protected String propertiesCmd;
    protected String translateCmd;
    protected String duplicateCmd;
    protected KeyStroke cutKey;
    protected KeyStroke copyKey;
    protected KeyStroke pasteKey;
    protected KeyStroke deleteKey;
    protected KeyStroke moveKey;
    protected KeyStroke searchKey;
    protected KeyStroke helpKey;
    protected KeyStroke propertiesKey;
    protected KeyStroke translateKey;
    protected KeyStroke duplicateKey;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action deleteAction;
    protected Action moveAction;
    protected Action searchAction;
    protected Action propertiesAction;
    protected Action translateAction;
    protected Action helpAction;
    protected Action duplicateAction;
    protected JDialog searchDialog;
    protected JTextField searchField;
    protected JRadioButton searchFiltered;
    @Deprecated(since="2023-10-17", forRemoval=true)
    protected JCheckBox searchAdvanced;
    private final SearchParameters searchParameters;
    protected static Chatter chatter;
    @Deprecated(since="2022-08-08", forRemoval=true)
    public static final Font POPUP_MENU_FONT;
    protected static final List<AdditionalComponent> additionalComponents;
    private static final String CLASS_MODULE = "Module";
    private static final String CLASS_HELP_MENU = "Help Menu";
    public static final String defaultExportExtension = ".xml";
    protected static boolean newNodeSelected;
    protected static DefaultMutableTreeNode lastFoundNode;
    protected static int selectedNodeIndex;

    public ConfigureTree(Configurable root, HelpWindow helpWindow) {
        this(root, helpWindow, null, false);
    }

    public ConfigureTree(Configurable root, HelpWindow helpWindow, EditorWindow editorWindow) {
        this(root, helpWindow, editorWindow, false);
    }

    public ConfigureTree(Configurable root, HelpWindow helpWindow, EditorWindow editorWindow, boolean disableDragAndDrop) {
        this.toggleClickCount = 3;
        this.helpWindow = helpWindow;
        this.editorWindow = editorWindow;
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.buildTreeNode(root)));
        this.setCellRenderer(this.buildRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.searchCmd = Resources.getString("Editor.search");
        this.moveCmd = Resources.getString("Editor.move");
        this.deleteCmd = Resources.getString("Editor.delete");
        this.pasteCmd = Resources.getString("Editor.paste");
        this.copyCmd = Resources.getString("Editor.copy");
        this.cutCmd = Resources.getString("Editor.cut");
        this.propertiesCmd = Resources.getString("Editor.properties");
        this.translateCmd = Resources.getString("Editor.ModuleEditor.translate");
        this.helpCmd = Resources.getString("Editor.ModuleEditor.component_help");
        this.duplicateCmd = Resources.getString("Editor.duplicate");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.cutKey = KeyStroke.getKeyStroke(88, mask);
        this.copyKey = KeyStroke.getKeyStroke(67, mask);
        this.pasteKey = KeyStroke.getKeyStroke(86, mask);
        this.deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.moveKey = KeyStroke.getKeyStroke(77, mask);
        this.searchKey = KeyStroke.getKeyStroke(70, mask);
        this.propertiesKey = KeyStroke.getKeyStroke(80, mask);
        this.translateKey = KeyStroke.getKeyStroke(84, mask);
        this.helpKey = KeyStroke.getKeyStroke(112, 0);
        this.duplicateKey = KeyStroke.getKeyStroke(68, mask);
        this.copyAction = new KeyAction(this.copyCmd, this.copyKey);
        this.pasteAction = new KeyAction(this.pasteCmd, this.pasteKey);
        this.cutAction = new KeyAction(this.cutCmd, this.cutKey);
        this.deleteAction = new KeyAction(this.deleteCmd, this.deleteKey);
        this.moveAction = new KeyAction(this.moveCmd, this.moveKey);
        this.searchAction = new KeyAction(this.searchCmd, this.searchKey);
        this.propertiesAction = new KeyAction(this.propertiesCmd, this.propertiesKey);
        this.translateAction = new KeyAction(this.translateCmd, this.translateKey);
        this.helpAction = new KeyAction(this.helpCmd, this.helpKey);
        this.duplicateAction = new KeyAction(this.duplicateCmd, this.duplicateKey);
        this.getInputMap().put(this.cutKey, this.cutCmd);
        this.getInputMap().put(this.copyKey, this.copyCmd);
        this.getInputMap().put(this.pasteKey, this.pasteCmd);
        this.getInputMap().put(this.deleteKey, this.deleteCmd);
        this.getInputMap().put(this.duplicateKey, this.duplicateCmd);
        this.getActionMap().put(this.cutCmd, this.cutAction);
        this.getActionMap().put(this.copyCmd, this.copyAction);
        this.getActionMap().put(this.pasteCmd, this.pasteAction);
        this.getActionMap().put(this.deleteCmd, this.deleteAction);
        this.getActionMap().put(this.duplicateCmd, this.duplicateAction);
        this.getSelectionModel().setSelectionMode(1);
        this.searchParameters = new SearchParameters();
        TreePath path = new TreePath(((DefaultMutableTreeNode)this.getModel().getRoot()).getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        chatter = GameModule.getGameModule().getChatter();
        this.createKeyBindings();
        if (!disableDragAndDrop) {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.ON_OR_INSERT);
            this.setTransferHandler(new TreeTransferHandler());
        }
    }

    public static String noHTML(String text) {
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected static void chat(String text) {
        if (chatter != null) {
            chatter.show("- " + text);
        }
    }

    protected JDialog getSearchDialog() {
        return this.searchDialog;
    }

    protected void setSearchDialog(JDialog searchDialog) {
        this.searchDialog = searchDialog;
    }

    protected JTextField getSearchField() {
        return this.searchField;
    }

    protected void setSearchField(JTextField searchField) {
        this.searchField = searchField;
    }

    protected void setSearchAdvanced(JRadioButton searchFiltered) {
        this.searchFiltered = searchFiltered;
    }

    @Deprecated(since="2023-10-17", forRemoval=true)
    protected void setSearchAdvanced(JCheckBox searchAdvanced) {
    }

    @Deprecated(since="2023-10-17", forRemoval=true)
    protected JCheckBox getSearchAdvanced() {
        return this.searchAdvanced;
    }

    public JFrame getFrame() {
        return this.editorWindow;
    }

    private void createKeyBindings() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreePath path = ConfigureTree.this.getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (ConfigureTree.this.isExpanded(path) || node.getChildCount() == 0) {
                    Action a;
                    Configurable target = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (target != null && target.getConfigurer() != null && (a = ConfigureTree.this.buildEditAction(target)) != null) {
                        a.actionPerformed(new ActionEvent(ae.getSource(), 1001, "Edit"));
                    }
                } else {
                    ConfigureTree.this.setExpandedState(path, true);
                }
            }
        });
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        ConfigureTreeNode node = (ConfigureTreeNode)event.getPath().getLastPathComponent();
        node.resetChildEditFlags();
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected void notifyStateChanged(boolean changed) {
        if (this.editorWindow != null) {
            this.editorWindow.treeStateChanged(changed);
        }
    }

    protected Configurable getTarget(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        Configurable target = null;
        if (path != null) {
            target = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return target;
    }

    protected DefaultMutableTreeNode buildTreeNode(Configurable c) {
        Configurable[] children;
        c.addPropertyChangeListener(this);
        ConfigureTreeNode node = new ConfigureTreeNode(c);
        for (Configurable child : children = c.getConfigureComponents()) {
            if (child instanceof Plugin) continue;
            node.add(this.buildTreeNode(child));
        }
        this.nodes.put(c, node);
        return node;
    }

    protected void addAction(JPopupMenu menu, Action a) {
        if (a != null) {
            menu.add(a);
        }
    }

    protected void addSubMenu(JPopupMenu menu, String name, List<Action> l) {
        if (l != null && !l.isEmpty()) {
            JMenu subMenu = new JMenu(name);
            for (Action a : l) {
                subMenu.add(a);
            }
            menu.add(subMenu);
            l.clear();
        }
    }

    private void addActionGroup(JPopupMenu menu, List<Action> l) {
        boolean empty = true;
        for (Action a : l) {
            if (a == null) continue;
            menu.add(a);
            empty = false;
        }
        if (!empty) {
            menu.addSeparator();
        }
        l.clear();
    }

    protected JPopupMenu buildPopupMenu(Configurable target) {
        boolean canImport;
        JPopupMenu popup = new JPopupMenu();
        ArrayList<Action> l = new ArrayList<Action>();
        l.add(this.buildEditAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildTranslateAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildHelpAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildSearchAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildDeleteAction(target));
        l.add(this.buildCutAction(target));
        l.add(this.buildCopyAction(target));
        l.add(this.buildPasteAction(target));
        l.add(this.buildMoveAction(target));
        this.addActionGroup(popup, l);
        ArrayList<Action> inserts = new ArrayList<Action>();
        List<Action> adds = this.buildAddActionsFor(target, inserts);
        for (Action a : adds) {
            this.addAction(popup, a);
        }
        this.addSubMenu(popup, Resources.getString("Editor.ConfigureTree.insert"), inserts);
        if (this.hasChild(target, PieceSlot.class) || this.hasChild(target, CardSlot.class)) {
            this.addAction(popup, this.buildMassPieceLoaderAction(target));
        }
        this.addAction(popup, this.buildImportAction(target));
        boolean canExport = this.getTreeNode(target).getParent() != null;
        boolean bl = canImport = target.getAllowableConfigureComponents().length > 0;
        if (canImport || canExport || target instanceof DrawPile) {
            popup.addSeparator();
        }
        if (canExport) {
            this.addAction(popup, this.buildExportTreeAction(target));
        }
        if (canImport) {
            this.addAction(popup, this.buildImportTreeAction(target));
        }
        if (target instanceof DrawPile) {
            this.addAction(popup, this.buildImportDeckAction(target));
        }
        Action aOpen = this.buildOpenPiecesAction(target);
        Action aEdit = this.buildEditPiecesAction(target);
        if (aOpen != null || aEdit != null) {
            popup.addSeparator();
        }
        this.addAction(popup, aOpen);
        this.addAction(popup, aEdit);
        return popup;
    }

    protected boolean exportTreeBranch(AbstractBuildable target) {
        FileChooser fc = FileChooser.createFileChooser(GameModule.getGameModule().getPlayerWindow(), (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        if (fc.showSaveDialog() != 0) {
            return false;
        }
        Object filename = fc.getSelectedFile().getPath();
        if (!StringUtils.isEmpty((CharSequence)defaultExportExtension) && ((String)filename).lastIndexOf(46) < 0 && new File((String)(filename = (String)filename + defaultExportExtension)).exists() && 1 == JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Editor.ConfigureTree.export_overwrite", filename), Resources.getString("Editor.ConfigureTree.export_exists"), 0)) {
            return false;
        }
        try (BufferedWriter w = Files.newBufferedWriter(Path.of((String)filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            w.write(target.buildString());
        }
        catch (IOException e) {
            WriteErrorDialog.error((Throwable)e, e, (String)filename);
            return false;
        }
        return true;
    }

    protected boolean importTreeBranch(Configurable target) {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        if (fc.showOpenDialog() != 0) {
            return false;
        }
        Object filename = fc.getSelectedFile().getPath();
        if (fc.getSelectedFile().getName().indexOf(46) < 0) {
            filename = (String)filename + defaultExportExtension;
        }
        try {
            Buildable b = Builder.create(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File((String)filename)).getDocumentElement(), target);
            if (!(b instanceof Configurable)) {
                GameModule.getGameModule().warn(Resources.getString("Editor.ConfigureTree.import_invalid_file"));
                ErrorDialog.show("Error.import_invalid_file", b.toString());
                return false;
            }
            b = this.convertChild(target, (Configurable)b);
            boolean allowed = false;
            for (Class c : target.getAllowableConfigureComponents()) {
                if (!c.isInstance(b)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                GameModule.getGameModule().warn(Resources.getString("Editor.ConfigureTree.import_not_allowed", b.toString()));
                ErrorDialog.show("Error.import_not_allowed", b.toString());
                return false;
            }
            this.insert(target, (Configurable)b, this.getTreeNode(target).getChildCount());
        }
        catch (IllegalBuildException | SAXException e) {
            GameModule.getGameModule().warn(Resources.getString("Editor.ConfigureTree.import_failed_message", filename, target.getConfigureName()));
            ErrorDialog.show("Editor.ConfigureTree.import_failed", filename, target.getConfigureName());
            return false;
        }
        catch (ParserConfigurationException e) {
            ErrorDialog.bug(e);
            return false;
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, (String)filename);
            return false;
        }
        GameModule.getGameModule().warn(Resources.getString("Editor.ConfigureTree.import_successful"));
        return true;
    }

    private List<DefaultMutableTreeNode> getSearchNodes(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> searchNodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            searchNodes.add((DefaultMutableTreeNode)e.nextElement());
        }
        return searchNodes;
    }

    private static int getBookmark(List<DefaultMutableTreeNode> searchNodes, DefaultMutableTreeNode targetNode) {
        return IntStream.range(0, searchNodes.size()).filter(i -> searchNodes.get(i) == targetNode).findFirst().orElse(-1);
    }

    private void notifyUpdate(Configurable target) {
        if (this.editorWindow != null && target instanceof AbstractConfigurable && this.editorWindow.getListKeyCommands() != null) {
            this.editorWindow.getListKeyCommands().updateConfigurable((AbstractConfigurable)target);
        }
    }

    private void notifyDelete(Configurable target) {
        if (this.editorWindow != null && target instanceof AbstractConfigurable && this.editorWindow.getListKeyCommands() != null) {
            this.editorWindow.getListKeyCommands().deleteConfigurable((AbstractConfigurable)target);
        }
    }

    protected Action buildSearchAction(Configurable target) {
        SearchAction a = new SearchAction(this, this.searchParameters);
        a.setEnabled(true);
        return a;
    }

    protected Action buildExportTreeAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(Resources.getString("Editor.ConfigureTree.export_object")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (target instanceof AbstractBuildable) {
                        ConfigureTree.this.exportTreeBranch((AbstractBuildable)((Object)target));
                    }
                }
            };
        }
        return a;
    }

    protected Action buildImportTreeAction(final Configurable target) {
        return new AbstractAction(Resources.getString("Editor.ConfigureTree.import_object")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureTree.this.importTreeBranch(target);
            }
        };
    }

    protected Action buildMoveAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.moveCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), true);
                    d.setTitle((String)(target.getConfigureName() == null ? ConfigureTree.this.moveCmd : ConfigureTree.this.moveCmd + " " + target.getConfigureName()));
                    d.setLayout(new BoxLayout(d.getContentPane(), 1));
                    Box box = Box.createHorizontalBox();
                    box.add(new JLabel(Resources.getString("Editor.ConfigureTree.move_to_position")));
                    box.add(Box.createHorizontalStrut(10));
                    JComboBox<CallSite> select = new JComboBox<CallSite>();
                    TreeNode parentNode = ConfigureTree.this.getTreeNode(target).getParent();
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        Configurable c = (Configurable)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
                        String name = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
                        select.addItem((CallSite)((Object)(i + 1 + ":  " + name)));
                    }
                    DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    int currentIndex = targetNode.getParent().getIndex(targetNode);
                    select.setSelectedIndex(currentIndex);
                    box.add(select);
                    JButton ok = new JButton(Resources.getString("General.ok"));
                    ok.addActionListener(e1 -> {
                        Configurable parent;
                        int index = select.getSelectedIndex();
                        if (currentIndex != index && ConfigureTree.this.remove(parent = ConfigureTree.this.getParent(targetNode), target)) {
                            ConfigureTree.this.insert(parent, target, index);
                        }
                        d.dispose();
                    });
                    d.add(box);
                    d.add(ok);
                    SwingUtils.setDefaultButtons(d.getRootPane(), ok, ok);
                    SwingUtils.repack(d);
                    d.setLocationRelativeTo(d.getParent());
                    d.setVisible(true);
                }
            };
            a.setEnabled(this.isMoveAllowed(target));
        }
        return a;
    }

    protected Action buildCutAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.cutCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.cutData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.copyData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
            a.setEnabled(this.isDeleteAllowed(target));
        }
        return a;
    }

    protected Action buildCopyAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.copyCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.cutData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
            a.setEnabled(true);
        }
        return a;
    }

    protected void postPasteFixups(Configurable target) {
        CounterDetailViewer cdv;
        Object folder;
        Buildable ancestor;
        SetupStack ss;
        String owning;
        if (target instanceof SetupStack && (owning = (ss = (SetupStack)target).getOwningBoardName()) != null && !ss.getValidOwningBoards().contains(owning)) {
            ConfigureTree.chat(Resources.getString("Editor.convert_setupstack_or_deck", target instanceof DrawPile ? DrawPile.getConfigureTypeName() : SetupStack.getConfigureTypeName(), ss.getConfigureName(), owning));
            ss.setOwningBoardName(null);
        }
        if (target instanceof PrototypeFolder && (ancestor = ((AbstractBuildable)(folder = (PrototypeFolder)target)).getNonFolderAncestor()) instanceof PrototypesContainer) {
            PrototypesContainer protos = (PrototypesContainer)ancestor;
            for (PrototypeDefinition child : ((AbstractBuildable)folder).getAllDescendantComponentsOf(PrototypeDefinition.class)) {
                protos.addDefinition(child);
            }
        }
        if (target instanceof GlobalPropertyFolder) {
            for (GlobalProperty child : ((GlobalPropertyFolder)target).getAllDescendantComponentsOf(GlobalProperty.class)) {
                child.addTo(child.getAncestor());
            }
        }
        if (target instanceof CounterDetailViewer && (cdv = (CounterDetailViewer)target).getMap() == null) {
            cdv.addTo(cdv.getAncestor());
        }
    }

    protected Action buildPasteAction(final Configurable target) {
        AbstractAction a = new AbstractAction(this.pasteCmd){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureTree.this.cutData != null) {
                    DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    if (targetNode.isNodeAncestor(ConfigureTree.this.cutData)) {
                        ConfigureTree.chat(Resources.getString("Editor.cant_cut_ancestor_to_child"));
                        return;
                    }
                    Configurable cutObj = (Configurable)ConfigureTree.this.cutData.getUserObject();
                    Configurable convertedCutObj = ConfigureTree.this.convertChild(target, cutObj);
                    if (ConfigureTree.this.getParent(ConfigureTree.this.cutData) == null || ConfigureTree.this.remove(ConfigureTree.this.getParent(ConfigureTree.this.cutData), cutObj)) {
                        ConfigureTree.this.insert(target, convertedCutObj, targetNode.getChildCount());
                        ConfigureTree.this.postPasteFixups(convertedCutObj);
                    }
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(convertedCutObj);
                } else if (ConfigureTree.this.copyData != null) {
                    Configurable copyBase = (Configurable)ConfigureTree.this.copyData.getUserObject();
                    Buildable clone = null;
                    try {
                        clone = ConfigureTree.this.convertChild(target, (Configurable)copyBase.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, copyBase.getClass());
                    }
                    if (clone != null) {
                        clone.build(copyBase.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(target, (Configurable)clone, ConfigureTree.this.getTreeNode(target).getChildCount());
                        ConfigureTree.this.updateGpIds((Configurable)clone);
                        ConfigureTree.this.postPasteFixups((Configurable)clone);
                    }
                }
                ConfigureTree.this.cutData = null;
                ConfigureTree.this.updateEditMenu();
            }
        };
        a.setEnabled(this.isValidPasteTarget(target));
        return a;
    }

    protected boolean isValidPasteTarget(Configurable target, DefaultMutableTreeNode sourceNode) {
        if (sourceNode == null) {
            return false;
        }
        Configurable pasteComponent = (Configurable)sourceNode.getUserObject();
        if (!pasteComponent.isMovable()) {
            return false;
        }
        if (pasteComponent.isUnique() && target instanceof AbstractBuildable && !((AbstractBuildable)((Object)target)).getComponentsOf(pasteComponent.getClass()).isEmpty()) {
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)sourceNode.getParent();
        if (parent != null && parent.getUserObject().equals(target)) {
            return true;
        }
        return this.isValidParent(target, (Configurable)sourceNode.getUserObject());
    }

    protected boolean isValidPasteTarget(Configurable target) {
        return this.isValidPasteTarget(target, this.cutData) || this.isValidPasteTarget(target, this.copyData);
    }

    protected Configurable convertChild(Configurable parent, Configurable child) {
        if (child.getClass() == PieceSlot.class && this.isAllowedChildClass(parent, CardSlot.class)) {
            return new CardSlot((PieceSlot)child);
        }
        if (child.getClass() == CardSlot.class && this.isAllowedChildClass(parent, PieceSlot.class)) {
            return new PieceSlot((CardSlot)child);
        }
        if (child.getClass() == ZoneProperty.class && this.isAllowedChildClass(parent, GlobalProperty.class)) {
            return new GlobalProperty((GlobalProperty)child);
        }
        if (child.getClass() == GlobalProperty.class && this.isAllowedChildClass(parent, ZoneProperty.class)) {
            return new ZoneProperty((GlobalProperty)child);
        }
        if (MassKeyCommand.class.isAssignableFrom(child.getClass())) {
            if (this.isAllowedChildClass(parent, DeckGlobalKeyCommand.class)) {
                return child instanceof DeckGlobalKeyCommand ? child : new DeckGlobalKeyCommand((MassKeyCommand)child);
            }
            if (this.isAllowedChildClass(parent, GlobalKeyCommand.class)) {
                return child instanceof GlobalKeyCommand ? child : new GlobalKeyCommand((MassKeyCommand)child);
            }
            if (this.isAllowedChildClass(parent, MassKeyCommand.class)) {
                return child.getClass().equals(MassKeyCommand.class) ? child : new MassKeyCommand((MassKeyCommand)child);
            }
        }
        return child;
    }

    protected boolean isAllowedChildClass(Configurable parent, Class<?> childClass) {
        Class[] allowableClasses;
        for (Class allowableClass : allowableClasses = parent.getAllowableConfigureComponents()) {
            if (allowableClass != childClass) continue;
            return true;
        }
        return false;
    }

    public void updateGpIds(Configurable c) {
        if (c instanceof PieceSlot) {
            ((PieceSlot)c).updateGpId(GameModule.getGameModule());
        } else {
            for (Configurable comp : c.getConfigureComponents()) {
                this.updateGpIds(comp);
            }
        }
    }

    protected Action buildImportAction(Configurable target) {
        return new ImportAction(target, Resources.getString("Editor.ConfigureTree.add_imported_class"));
    }

    protected Action buildImportDeckAction(final Configurable target) {
        final ConfigureTree tree = this;
        return new AbstractAction(Resources.getString("Editor.ConfigureTree.import_deck_file")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((DrawPile)target).importDeck(tree);
            }
        };
    }

    protected Action buildMassPieceLoaderAction(final Configurable target) {
        AbstractAction a = null;
        final ConfigureTree tree = this;
        if (this.getTreeNode(target).getParent() != null) {
            Resources.getString("Editor.ConfigureTree.add_cards");
            String desc = this.hasChild(target, CardSlot.class) ? Resources.getString("Editor.ConfigureTree.add_cards") : Resources.getString("Editor.ConfigureTree.add_pieces");
            a = new AbstractAction(desc){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new MassPieceLoader(tree, target).load();
                }
            };
        }
        return a;
    }

    protected boolean hasChild(Configurable parent, Class<?> childClass) {
        for (Class c : parent.getAllowableConfigureComponents()) {
            if (!c.equals(childClass)) continue;
            return true;
        }
        return false;
    }

    protected List<Action> buildAddActionsFor(Configurable target) {
        return this.buildAddActionsFor(target, null);
    }

    protected List<Action> buildAddActionsFor(Configurable target, List<Action> peerInserts) {
        DefaultMutableTreeNode parentNode;
        DefaultMutableTreeNode targetNode;
        ArrayList<Action> l = new ArrayList<Action>();
        if (target instanceof AbstractConfigurable && (targetNode = this.getTreeNode(target)) != null && (parentNode = (DefaultMutableTreeNode)targetNode.getParent()) != null) {
            if (this.isDuplicateAllowed(target)) {
                l.add(this.buildAddAction((Configurable)parentNode.getUserObject(), target.getClass(), "Editor.ConfigureTree.add_duplicate", parentNode.getIndex(targetNode) + 1, target));
            }
            if (peerInserts != null) {
                Configurable parent = (Configurable)parentNode.getUserObject();
                for (Class newConfig : parent.getAllowableConfigureComponents()) {
                    peerInserts.add(this.buildAddAction(parent, newConfig, "Editor.ConfigureTree.add_peer", parentNode.getIndex(targetNode), null));
                }
            }
        }
        for (Class newConfig : target.getAllowableConfigureComponents()) {
            l.add(this.buildAddAction(target, newConfig));
        }
        for (AdditionalComponent add : additionalComponents) {
            if (!target.getClass().equals(add.getParent())) continue;
            Class<? extends Buildable> newConfig = add.getChild();
            l.add(this.buildAddAction(target, newConfig));
        }
        return l;
    }

    protected Action buildAddAction(Configurable target, Class<? extends Buildable> newConfig) {
        return this.buildAddAction(target, newConfig, "Editor.ConfigureTree.add_component", -1, null);
    }

    protected Action buildAddAction(Configurable target, Class<? extends Buildable> newConfig, String key, int index, Configurable duplicate) {
        return new AddAction(target, newConfig, Resources.getString(key, ConfigureTree.getConfigureName(newConfig)), index, duplicate);
    }

    protected Action buildHelpAction(Configurable target) {
        ShowHelpAction showHelp;
        HelpFile helpFile = target.getHelpFile();
        if (helpFile == null) {
            showHelp = new ShowHelpAction(null, null);
            showHelp.setEnabled(false);
        } else {
            showHelp = new ShowHelpAction(helpFile.getContents(), null);
        }
        return showHelp;
    }

    protected Action buildCloneAction(final Configurable target) {
        final DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null) {
            return new AbstractAction(Resources.getString("Editor.ConfigureTree.clone")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Configurable clone = null;
                    try {
                        clone = (Configurable)target.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, target.getClass());
                    }
                    if (clone != null) {
                        clone.build(target.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(ConfigureTree.this.getParent(targetNode), clone, targetNode.getParent().getIndex(targetNode) + 1);
                    }
                }
            };
        }
        return null;
    }

    protected Configurable getParent(DefaultMutableTreeNode targetNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        return parentNode == null ? null : (Configurable)parentNode.getUserObject();
    }

    protected Action buildDeleteAction(final Configurable target) {
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null) {
            AbstractAction a = new AbstractAction(this.deleteCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = ConfigureTree.this.selectedRow;
                    ConfigureTree.this.delete(target);
                    if (row < ConfigureTree.this.getRowCount()) {
                        ConfigureTree.this.setSelectionRow(row);
                    } else {
                        ConfigureTree.this.setSelectionRow(row - 1);
                    }
                }
            };
            a.setEnabled(this.isDeleteAllowed(target));
            return a;
        }
        return null;
    }

    protected Action buildEditPiecesAction(Configurable target) {
        if (this.canContainGamePiece(target)) {
            return new EditContainedPiecesAction(target, this);
        }
        return null;
    }

    protected Action buildOpenPiecesAction(Configurable target) {
        if (this.canContainGamePiece(target)) {
            return new OpenContainedPiecesAction(target, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this);
        }
        return null;
    }

    protected Action buildEditAction(Configurable target) {
        return new EditPropertiesAction(target, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this);
    }

    protected Action buildTranslateAction(Configurable target) {
        TranslateAction a = new TranslateAction(target, this.helpWindow, this);
        a.setEnabled(target.getI18nData().isTranslatable());
        return a;
    }

    public boolean canContainGamePiece(Configurable target) {
        boolean canContainPiece = false;
        for (Class c : target.getAllowableConfigureComponents()) {
            if (!PieceSlot.class.isAssignableFrom(c)) continue;
            canContainPiece = true;
            break;
        }
        return canContainPiece;
    }

    protected boolean delete(Configurable target) {
        boolean result = true;
        Enumeration<TreeNode> e = this.getTreeNode(target).postorderEnumeration();
        ArrayList<DefaultMutableTreeNode> victims = new ArrayList<DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            victims.add((DefaultMutableTreeNode)e.nextElement());
        }
        for (DefaultMutableTreeNode victim : victims) {
            result &= this.remove((Configurable)((DefaultMutableTreeNode)victim.getParent()).getUserObject(), (Configurable)victim.getUserObject());
        }
        return result;
    }

    protected boolean remove(Configurable parent, Configurable child) {
        try {
            child.removeFrom(parent);
            parent.remove(child);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this.getTreeNode(child));
            this.notifyDelete(child);
            this.notifyStateChanged(true);
            return true;
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Cannot delete " + ConfigureTree.getConfigureName(child) + " from " + ConfigureTree.getConfigureName(parent) + "\n" + err.getMessage(), "Illegal configuration", 0);
            return false;
        }
    }

    protected boolean insert(Configurable parent, Configurable child, int index) {
        Configurable theChild = this.convertChild(parent, child);
        DefaultMutableTreeNode childNode = this.buildTreeNode(theChild);
        DefaultMutableTreeNode parentNode = this.getTreeNode(parent);
        Configurable[] oldContents = parent.getConfigureComponents();
        ArrayList<Configurable> moveToBack = new ArrayList<Configurable>();
        for (int i = index; i < oldContents.length; ++i) {
            try {
                parent.remove(oldContents[i]);
            }
            catch (IllegalBuildException err) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't insert " + ConfigureTree.getConfigureName(theChild) + " before " + ConfigureTree.getConfigureName(oldContents[i]), "Illegal configuration", 0);
                for (int j = index; j < i; ++j) {
                    parent.add(oldContents[j]);
                }
                return false;
            }
            moveToBack.add(oldContents[i]);
        }
        boolean succeeded = true;
        try {
            theChild.addTo(parent);
            parent.add(theChild);
            if (theChild instanceof AbstractBuildable) {
                ((AbstractBuildable)((Object)theChild)).setAncestor(parent);
            }
            parentNode.insert(childNode, index);
            int[] childI = new int[]{index};
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(parentNode, childI);
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't add " + ConfigureTree.getConfigureName(child) + "\n" + err.getMessage(), "Illegal configuration", 0);
            succeeded = false;
        }
        for (Configurable c : moveToBack) {
            parent.add(c);
        }
        this.notifyStateChanged(true);
        this.notifyUpdate(child);
        return succeeded;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DefaultMutableTreeNode newValue = this.getTreeNode((Configurable)evt.getSource());
        ((DefaultTreeModel)this.getModel()).nodeChanged(newValue);
    }

    public static String getConfigureName(Class<?> c) {
        try {
            return (String)c.getMethod("getConfigureTypeName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String getConfigureName(Configurable c) {
        if (c.getConfigureName() != null && c.getConfigureName().length() > 0) {
            return c.getConfigureName();
        }
        return ConfigureTree.getConfigureName(c.getClass());
    }

    protected Configurable importConfigurable() {
        String className = JOptionPane.showInputDialog(this.getTopLevelAncestor(), (Object)Resources.getString("Editor.ConfigureTree.java_name"));
        if (className == null) {
            return null;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Configurable) {
            return o;
        }
        ErrorDialog.show("Error.not_a_configurable", className);
        return null;
    }

    protected void maybePopup(MouseEvent e) {
        Configurable target = this.getTarget(e.getX(), e.getY());
        if (target == null) {
            return;
        }
        this.setSelectionRow(this.getClosestRowForLocation(e.getX(), e.getY()));
        JPopupMenu popup = this.buildPopupMenu(target);
        popup.show(this, e.getX(), e.getY());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        } else if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e)) {
            Action a;
            Configurable target = this.getTarget(e.getX(), e.getY());
            if (target == null) {
                return;
            }
            if (target.getConfigurer() != null && (a = this.buildEditAction(target)) != null) {
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit", e.getModifiersEx()));
            }
        }
    }

    public DefaultMutableTreeNode getTreeNode(Configurable target) {
        return this.nodes.get(target);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    public boolean isMoveAllowed(Configurable target) {
        return target.isMovable();
    }

    protected boolean isDeleteAllowed(Configurable target) {
        Buildable parent;
        if (!target.isMandatory()) {
            return true;
        }
        if (target instanceof AbstractBuildable && (parent = ((AbstractBuildable)((Object)target)).getAncestor()) instanceof AbstractBuildable) {
            int count = ((AbstractBuildable)parent).getComponentsOf(target.getClass()).size();
            return count > 1;
        }
        return false;
    }

    protected boolean isDuplicateAllowed(Configurable target) {
        return !target.isUnique();
    }

    protected boolean isValidParent(Configurable parent, Configurable child) {
        if (parent != null && child != null) {
            Class[] c;
            for (Class aClass : c = parent.getAllowableConfigureComponents()) {
                if (!(aClass.isAssignableFrom(child.getClass()) || aClass == CardSlot.class && child.getClass() == PieceSlot.class || aClass == ZoneProperty.class && child.getClass() == GlobalProperty.class) && (!MassKeyCommand.class.isAssignableFrom(aClass) || !MassKeyCommand.class.isAssignableFrom(child.getClass()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void nodeUpdated(Configurable target) {
        DefaultMutableTreeNode node = this.getTreeNode(target);
        Configurable parent = this.getParent(node);
        if (this.remove(parent, target)) {
            this.insert(parent, target, 0);
        }
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public void jumpToTarget(Configurable target) {
        DefaultMutableTreeNode node = this.getTreeNode(target);
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void externalInsert(Configurable parent, Configurable child) {
        this.insert(parent, child, this.getTreeNode(parent).getChildCount());
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public void populateEditMenu(EditorWindow ew) {
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("Editor.delete", this.deleteAction);
        mm.addAction("Editor.cut", this.cutAction);
        mm.addAction("Editor.copy", this.copyAction);
        mm.addAction("Editor.paste", this.pasteAction);
        mm.addAction("Editor.move", this.moveAction);
        mm.addAction("Editor.search", this.searchAction);
        mm.addAction("Editor.properties", this.propertiesAction);
        mm.addAction("Editor.ModuleEditor.translate", this.translateAction);
        mm.addAction("Editor.duplicate", this.duplicateAction);
        this.updateEditMenu();
    }

    protected void doKeyAction(String action) {
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (targetNode != null) {
            DefaultMutableTreeNode parentNode;
            DefaultMutableTreeNode targetNode2;
            Configurable target = (Configurable)targetNode.getUserObject();
            Action a = null;
            if (this.cutCmd.equals(action)) {
                a = this.buildCutAction(target);
            } else if (this.copyCmd.equals(action)) {
                a = this.buildCopyAction(target);
            } else if (this.pasteCmd.equals(action) || action.equals(String.valueOf(this.pasteKey.getKeyChar()))) {
                a = this.buildPasteAction(target);
            } else if (this.deleteCmd.equals(action)) {
                a = this.buildDeleteAction(target);
            } else if (this.moveCmd.equals(action)) {
                a = this.buildMoveAction(target);
            } else if (this.searchCmd.equals(action)) {
                a = this.buildSearchAction(target);
            } else if (this.propertiesCmd.equals(action)) {
                a = this.buildEditAction(target);
            } else if (this.translateCmd.equals(action)) {
                a = this.buildTranslateAction(target);
            } else if (this.helpCmd.equals(action)) {
                a = this.buildHelpAction(target);
            } else if (this.duplicateCmd.equals(action) && (targetNode2 = this.getTreeNode(target)) != null && (parentNode = (DefaultMutableTreeNode)targetNode2.getParent()) != null) {
                a = this.buildAddAction((Configurable)parentNode.getUserObject(), target.getClass(), Resources.getString("Editor.duplicate"), parentNode.getIndex(targetNode2) + 1, target);
            }
            if (a != null) {
                a.actionPerformed(null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selected = null;
        TreePath path = e.getPath();
        if (path != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.selected = (Configurable)selectedNode.getUserObject();
            this.selectedRow = this.getRowForPath(path);
            this.updateEditMenu();
            ((DefaultTreeModel)this.getModel()).nodeChanged(selectedNode);
            boolean bl = newNodeSelected = selectedNode != lastFoundNode;
            if (newNodeSelected) {
                selectedNodeIndex = ConfigureTree.getBookmark(this.getSearchNodes((DefaultMutableTreeNode)selectedNode.getRoot()), selectedNode);
            }
        }
    }

    protected void updateEditMenu() {
        this.deleteAction.setEnabled(this.selected != null && this.isDeleteAllowed(this.selected));
        this.cutAction.setEnabled(this.selected != null && this.isDeleteAllowed(this.selected));
        this.copyAction.setEnabled(this.selected != null);
        this.pasteAction.setEnabled(this.selected != null && this.isValidPasteTarget(this.selected));
        this.moveAction.setEnabled(this.selected != null && this.isMoveAllowed(this.selected));
        this.duplicateAction.setEnabled(this.selected != null && this.isDuplicateAllowed(this.selected));
        this.searchAction.setEnabled(true);
        this.propertiesAction.setEnabled(this.selected != null && this.selected.getConfigurer() != null);
        this.translateAction.setEnabled(this.selected != null);
    }

    protected Configurable getParent(Configurable target) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getTreeNode(target).getParent();
        return (Configurable)parentNode.getUserObject();
    }

    public String getSearchCmd() {
        return this.searchCmd;
    }

    public static void addAdditionalComponent(Class<? extends Buildable> parent, Class<? extends Buildable> child) {
        additionalComponents.add(new AdditionalComponent(parent, child));
    }

    public void nodeEdited(Configurable target) {
        ConfigureTreeNode node = (ConfigureTreeNode)this.getTreeNode(target);
        node.setEdited(true);
        this.notifyUpdate(target);
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public int checkMinimumIndex(DefaultMutableTreeNode targetNode, int index) {
        return index;
    }

    protected void postInsertProcessing(Configurable parent, Configurable child) {
    }

    protected void postRemoveProcessing(Configurable parent, Configurable child) {
    }

    static {
        POPUP_MENU_FONT = new Font("Dialog", 0, 11);
        additionalComponents = new ArrayList<AdditionalComponent>();
        newNodeSelected = false;
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font plainFont;
        private Font italicFont;

        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.plainFont == null) {
                this.plainFont = label.getFont();
            }
            if (value instanceof ConfigureTreeNode) {
                ConfigureTreeNode c = (ConfigureTreeNode)value;
                if (c.isEdited()) {
                    if (this.italicFont == null) {
                        Font f = label.getFont();
                        this.italicFont = new Font(f.getFontName(), 2, f.getSize());
                    }
                    label.setFont(this.italicFont);
                } else {
                    label.setFont(this.plainFont);
                }
            }
            return label;
        }
    }

    class KeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected String actionName;

        public KeyAction(String name, KeyStroke key) {
            super(name);
            this.actionName = name;
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigureTree.this.doKeyAction(this.actionName);
        }
    }

    private static class SearchParameters {
        public static final String SEARCH_STRING = "searchString";
        public static final String SEARCH_NORMAL = "optNormal";
        public static final String SEARCH_WORD = "optWord";
        public static final String SEARCH_REGEX = "optRegex";
        public static final String MATCH_CASE = "matchCase";
        public static final String MATCH_MODULE = "matchModule";
        public static final String MATCH_NAMES = "matchNames";
        public static final String MATCH_TYPES = "matchTypes";
        public static final String MATCH_SIMPLE = "matchSimple";
        public static final String MATCH_FULL = "matchFull";
        public static final String MATCH_ADVANCED = "matchAdvanced";
        public static final String MATCH_TRAITS = "matchTraits";
        public static final String MATCH_EXPRESSIONS = "matchExpressions";
        public static final String MATCH_PROPERTIES = "matchProperties";
        public static final String MATCH_KEYS = "matchKeys";
        public static final String MATCH_MENUS = "matchMenus";
        public static final String MATCH_MESSAGES = "matchMessages";
        private String searchString;
        private boolean optNormal;
        private boolean optWord;
        private boolean optRegex;
        private boolean matchCase;
        private boolean matchModule;
        private boolean matchNames;
        private boolean matchTypes;
        private boolean matchSimple;
        private boolean matchFull;
        private boolean matchAdvanced;
        private boolean matchTraits;
        private boolean matchExpressions;
        private boolean matchProperties;
        private boolean matchKeys;
        private boolean matchMenus;
        private boolean matchMessages;
        private static Prefs prefs;

        public SearchParameters() {
            prefs = GameModule.getGameModule().getPrefs();
            prefs.addOption(null, new StringConfigurer(SEARCH_STRING, null, ""));
            prefs.addOption(null, new BooleanConfigurer(SEARCH_NORMAL, null, true));
            prefs.addOption(null, new BooleanConfigurer(SEARCH_WORD, null, false));
            prefs.addOption(null, new BooleanConfigurer(SEARCH_REGEX, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_CASE, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_MODULE, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_NAMES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_TYPES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_SIMPLE, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_FULL, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_ADVANCED, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_TRAITS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_EXPRESSIONS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_PROPERTIES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_KEYS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_MENUS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_MESSAGES, null, true));
            this.searchString = "";
            this.optNormal = true;
            this.optWord = false;
            this.optRegex = false;
            this.matchCase = false;
            this.matchModule = false;
            this.matchSimple = (Boolean)prefs.getValue(MATCH_SIMPLE);
            this.matchFull = (Boolean)prefs.getValue(MATCH_FULL) != false && !this.matchSimple;
            this.matchAdvanced = (Boolean)prefs.getValue(MATCH_ADVANCED) != false && !this.matchFull && !this.matchSimple;
            this.matchNames = (Boolean)prefs.getValue(MATCH_NAMES);
            this.matchTypes = (Boolean)prefs.getValue(MATCH_TYPES);
            this.matchTraits = (Boolean)prefs.getValue(MATCH_TRAITS);
            this.matchExpressions = (Boolean)prefs.getValue(MATCH_EXPRESSIONS);
            this.matchProperties = (Boolean)prefs.getValue(MATCH_PROPERTIES);
            this.matchKeys = (Boolean)prefs.getValue(MATCH_KEYS);
            this.matchMenus = (Boolean)prefs.getValue(MATCH_MENUS);
            this.matchMessages = (Boolean)prefs.getValue(MATCH_MESSAGES);
        }

        public SearchParameters(String searchString, boolean optNormal, boolean optWord, boolean optRegex, boolean matchCase, boolean matchModule, boolean matchNames, boolean matchTypes, boolean matchSimple, boolean matchFull, boolean matchAdvanced, boolean matchTraits, boolean matchExpressions, boolean matchProperties, boolean matchKeys, boolean matchMenus, boolean matchMessages) {
            this.searchString = searchString;
            this.optNormal = optNormal;
            this.optWord = optWord;
            this.optRegex = optRegex;
            this.matchCase = matchCase;
            this.matchModule = matchModule;
            this.matchNames = matchNames;
            this.matchTypes = matchTypes;
            this.matchSimple = matchSimple;
            this.matchFull = matchFull;
            this.matchAdvanced = matchAdvanced;
            this.matchTraits = matchTraits;
            this.matchExpressions = matchExpressions;
            this.matchProperties = matchProperties;
            this.matchKeys = matchKeys;
            this.matchMenus = matchMenus;
            this.matchMessages = matchMessages;
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
            this.writePrefs();
        }

        public boolean isOptNormal() {
            return this.optNormal;
        }

        public boolean isOptWord() {
            return this.optWord;
        }

        public boolean isOptRegex() {
            return this.optRegex;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public void setMatchCase(boolean matchCase) {
            this.matchCase = matchCase;
            this.writePrefs();
        }

        public boolean isMatchModule() {
            return this.matchModule;
        }

        public void setMatchModule(boolean matchModule) {
            this.matchModule = matchModule;
            this.writePrefs();
        }

        public boolean isMatchNames() {
            return this.matchNames;
        }

        public void setMatchNames(boolean matchNames) {
            this.matchNames = matchNames;
            this.writePrefs();
        }

        public boolean isMatchTypes() {
            return this.matchTypes;
        }

        public void setMatchTypes(boolean matchTypes) {
            this.matchTypes = matchTypes;
            this.writePrefs();
        }

        public boolean isMatchSimple() {
            return this.matchSimple;
        }

        public void setMatchSimple(boolean matchSimple) {
            this.matchFull = matchSimple;
            this.writePrefs();
        }

        public boolean isMatchFull() {
            return this.matchFull;
        }

        public void setMatchFull(boolean matchFull) {
            this.matchFull = matchFull;
            this.writePrefs();
        }

        public boolean isMatchAdvanced() {
            return this.matchAdvanced;
        }

        public void setMatchAdvanced(boolean matchAdvanced) {
            this.matchAdvanced = matchAdvanced;
            this.writePrefs();
        }

        public boolean isMatchTraits() {
            return this.matchTraits;
        }

        public void setMatchTraits(boolean matchTraits) {
            this.matchTraits = matchTraits;
            this.writePrefs();
        }

        public boolean isMatchExpressions() {
            return this.matchExpressions;
        }

        public void setMatchExpressions(boolean matchExpressions) {
            this.matchExpressions = matchExpressions;
            this.writePrefs();
        }

        public boolean isMatchProperties() {
            return this.matchProperties;
        }

        public void setMatchProperties(boolean matchProperties) {
            this.matchProperties = matchProperties;
            this.writePrefs();
        }

        public boolean isMatchKeys() {
            return this.matchKeys;
        }

        public void setMatchKeys(boolean matchKeys) {
            this.matchKeys = matchKeys;
            this.writePrefs();
        }

        public boolean isMatchMenus() {
            return this.matchMenus;
        }

        public void setMatchMenus(boolean matchMenus) {
            this.matchMenus = matchMenus;
            this.writePrefs();
        }

        public boolean isMatchMessages() {
            return this.matchMessages;
        }

        public void setMatchMessages(boolean matchMessages) {
            this.matchMessages = matchMessages;
            this.writePrefs();
        }

        public void setFrom(SearchParameters searchParameters) {
            this.searchString = searchParameters.getSearchString();
            this.optNormal = searchParameters.isOptNormal();
            this.optWord = searchParameters.isOptWord();
            this.optRegex = searchParameters.isOptRegex();
            this.matchCase = searchParameters.isMatchCase();
            this.matchModule = searchParameters.isMatchModule();
            this.matchNames = searchParameters.isMatchNames();
            this.matchTypes = searchParameters.isMatchTypes();
            this.matchSimple = searchParameters.isMatchSimple();
            this.matchFull = searchParameters.isMatchFull();
            this.matchAdvanced = searchParameters.isMatchAdvanced();
            this.matchTraits = searchParameters.isMatchTraits();
            this.matchExpressions = searchParameters.isMatchExpressions();
            this.matchProperties = searchParameters.isMatchProperties();
            this.matchKeys = searchParameters.isMatchKeys();
            this.matchMenus = searchParameters.isMatchMenus();
            this.matchMessages = searchParameters.isMatchMessages();
            this.writePrefs();
        }

        public void writePrefs() {
            if (prefs != null) {
                prefs.setValue(SEARCH_STRING, this.searchString);
                prefs.setValue(SEARCH_NORMAL, this.optNormal);
                prefs.setValue(SEARCH_WORD, this.optWord);
                prefs.setValue(SEARCH_REGEX, this.optRegex);
                prefs.setValue(MATCH_CASE, this.matchCase);
                prefs.setValue(MATCH_MODULE, this.matchModule);
                prefs.setValue(MATCH_NAMES, this.matchNames);
                prefs.setValue(MATCH_TYPES, this.matchTypes);
                prefs.setValue(MATCH_SIMPLE, this.matchSimple);
                prefs.setValue(MATCH_FULL, this.matchFull);
                prefs.setValue(MATCH_ADVANCED, this.matchAdvanced);
                prefs.setValue(MATCH_TRAITS, this.matchTraits);
                prefs.setValue(MATCH_EXPRESSIONS, this.matchExpressions);
                prefs.setValue(MATCH_PROPERTIES, this.matchProperties);
                prefs.setValue(MATCH_KEYS, this.matchKeys);
                prefs.setValue(MATCH_MENUS, this.matchMenus);
                prefs.setValue(MATCH_MESSAGES, this.matchMessages);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            return this.isMatchCase() == that.isMatchCase() && this.isMatchModule() == that.isMatchModule() && this.isMatchNames() == that.isMatchNames() && this.isMatchTypes() == that.isMatchTypes() && this.isMatchTraits() == that.isMatchTraits() && this.isMatchSimple() == that.isMatchSimple() && this.isMatchFull() == that.isMatchFull() && this.isMatchAdvanced() == that.isMatchAdvanced() && this.isMatchExpressions() == that.isMatchExpressions() && this.isMatchProperties() == that.isMatchProperties() && this.isMatchKeys() == that.isMatchKeys() && this.isMatchMenus() == that.isMatchMenus() && this.isMatchMessages() == that.isMatchMessages() && this.getSearchString().equals(that.getSearchString()) && this.isOptNormal() == that.isOptNormal() && this.isOptWord() == that.isOptWord() && this.isOptRegex() == that.isOptRegex();
        }

        public int hashCode() {
            return Objects.hash(this.getSearchString(), this.isOptNormal(), this.isOptWord(), this.isOptRegex(), this.isMatchCase(), this.isMatchModule(), this.isMatchNames(), this.isMatchTypes(), this.isMatchSimple(), this.isMatchFull(), this.isMatchAdvanced(), this.isMatchTraits(), this.isMatchExpressions(), this.isMatchProperties(), this.isMatchKeys(), this.isMatchMenus(), this.isMatchMessages());
        }
    }

    class TreeTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        DataFlavor nodesFlavor;
        DataFlavor[] flavors = new DataFlavor[1];

        public TreeTransferHandler() {
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
                this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException e) {
                logger.error("Class Not Found: " + e.getMessage());
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            ExtensionTree xTree;
            if (!support.isDrop()) {
                return false;
            }
            support.setShowDropLocation(true);
            if (!support.isDataFlavorSupported(this.nodesFlavor)) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            JTree tree = (JTree)support.getComponent();
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            if (selRows == null) {
                return false;
            }
            for (int selRow : selRows) {
                if (selRow != dropRow) continue;
                return false;
            }
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)dest.getLastPathComponent();
            TreePath path = tree.getPathForRow(selRows[0]);
            DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Configurable target = (Configurable)targetNode.getUserObject();
            if (!ConfigureTree.this.isValidPasteTarget(target, firstNode)) {
                return false;
            }
            if (tree instanceof ExtensionTree && !(xTree = (ExtensionTree)tree).isEditable(firstNode)) {
                return false;
            }
            int action = support.getDropAction();
            if (action == 2) {
                return !targetNode.isNodeAncestor(firstNode);
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[]{node};
                return new NodesTransferable(nodes);
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            DefaultMutableTreeNode[] nodes = null;
            try {
                Transferable t = support.getTransferable();
                nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                logger.error("Unsupported Flavor: " + ufe.getMessage());
            }
            catch (IOException ioe) {
                logger.error("I/O error: " + ioe.getMessage());
            }
            catch (InvalidDnDOperationException id) {
                logger.error("Invalid DND Operation: " + id.getMessage());
            }
            if (nodes == null) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)dest.getLastPathComponent();
            Configurable target = (Configurable)targetNode.getUserObject();
            DefaultMutableTreeNode sourceNode = nodes[0];
            int childIndex = dl.getChildIndex();
            if (childIndex < 0) {
                childIndex = sourceNode.getParent() == targetNode ? 0 : targetNode.getChildCount();
            }
            if ((childIndex = ConfigureTree.this.checkMinimumIndex(targetNode, childIndex)) > targetNode.getChildCount()) {
                childIndex = targetNode.getChildCount();
            }
            if ((support.getDropAction() & 2) == 2) {
                if (!targetNode.isNodeAncestor(sourceNode)) {
                    Configurable cutObj = (Configurable)sourceNode.getUserObject();
                    Configurable convertedCutObj = ConfigureTree.this.convertChild(target, cutObj);
                    if (sourceNode.getParent() == targetNode) {
                        int oldIndex = targetNode.getIndex(sourceNode);
                        if (childIndex > oldIndex) {
                            --childIndex;
                        }
                        if (childIndex == oldIndex) {
                            return true;
                        }
                    }
                    if (ConfigureTree.this.remove(ConfigureTree.this.getParent(sourceNode), cutObj)) {
                        ConfigureTree.this.postRemoveProcessing(ConfigureTree.this.getParent(sourceNode), cutObj);
                        ConfigureTree.this.insert(target, convertedCutObj, childIndex);
                        ConfigureTree.this.postInsertProcessing(target, convertedCutObj);
                        ConfigureTree.this.postPasteFixups(convertedCutObj);
                    }
                }
            } else {
                Configurable copyBase = (Configurable)sourceNode.getUserObject();
                Buildable clone = null;
                try {
                    clone = ConfigureTree.this.convertChild(target, (Configurable)copyBase.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, copyBase.getClass());
                }
                if (clone != null) {
                    clone.build(copyBase.getBuildElement(Builder.createNewDocument()));
                    ConfigureTree.this.insert(target, (Configurable)clone, childIndex);
                    ConfigureTree.this.postInsertProcessing(target, (Configurable)clone);
                    ConfigureTree.this.updateGpIds((Configurable)clone);
                }
            }
            return true;
        }

        public String toString() {
            return this.getClass().getName();
        }

        public class NodesTransferable
        implements Transferable {
            DefaultMutableTreeNode[] nodes;

            public NodesTransferable(DefaultMutableTreeNode[] nodes) {
                this.nodes = nodes;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.nodes;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TreeTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return TreeTransferHandler.this.nodesFlavor.equals(flavor);
            }
        }
    }

    private static class ConfigureTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private boolean edited = false;

        public ConfigureTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public String toString() {
            Object description = "";
            Configurable c = (Configurable)this.getUserObject();
            if (c != null) {
                ChangePropertyButton cpb;
                String desc;
                String basicName;
                GamePiece p;
                String desc2;
                Object object = description = c.getConfigureName() != null ? c.getConfigureName() : "";
                if (c instanceof GlobalProperty && !(desc2 = ((GlobalProperty)c).getDescription()).isEmpty()) {
                    description = (String)description + " - " + desc2;
                }
                if (c instanceof GlobalTranslatableMessage && !(desc2 = ((GlobalTranslatableMessage)c).getDescription()).isEmpty()) {
                    description = (String)description + " - " + desc2;
                }
                description = (String)description + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
                if (c instanceof ComponentDescription && (desc2 = ((ComponentDescription)((Object)c)).getDescription()) != null && !desc2.isEmpty()) {
                    description = (String)description + " - " + desc2;
                }
                if (c instanceof PrototypeDefinition && (p = ((PrototypeDefinition)c).getPiece()) != null && (basicName = (String)p.getProperty("BasicName")) != null && !basicName.isEmpty()) {
                    description = (String)description + " - " + basicName;
                }
                if (c instanceof ChangePropertyButton && (desc = (cpb = (ChangePropertyButton)c).getAttributeValueString("desc")) != null && !desc.isEmpty()) {
                    description = (String)description + " - " + desc;
                }
            }
            return description;
        }

        public boolean isEdited() {
            return this.edited;
        }

        public void setEdited(boolean edited) {
            this.edited = edited;
        }

        private void resetEditFlags() {
            this.setEdited(false);
            this.resetChildEditFlags();
        }

        public void resetChildEditFlags() {
            if (this.getChildCount() > 0) {
                for (TreeNode node : this.children) {
                    ((ConfigureTreeNode)node).resetEditFlags();
                }
            }
        }
    }

    private static class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ConfigureTree configureTree;
        private final SearchParameters searchParameters;
        private Pattern regexPattern;
        private int nodeListIndex;
        private int traitIndex;
        private final List<Integer> breadCrumbs = new ArrayList<Integer>();

        public SearchAction(ConfigureTree configureTree, SearchParameters searchParameters) {
            super(configureTree.getSearchCmd());
            this.configureTree = configureTree;
            this.searchParameters = searchParameters;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField search;
            JDialog d = this.configureTree.getSearchDialog();
            if (d != null) {
                search = this.configureTree.getSearchField();
                search.selectAll();
            } else {
                d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.configureTree), false);
                this.configureTree.setSearchDialog(d);
                d.setTitle(this.configureTree.getSearchCmd());
                search = new HintTextField(32, Resources.getString("Editor.search_string"));
                search.setText(this.searchParameters.getSearchString());
                this.configureTree.setSearchField(search);
                search.selectAll();
                JRadioButton normal = new JRadioButton(Resources.getString("Editor.search_optNormal"), this.searchParameters.isOptNormal());
                JRadioButton word = new JRadioButton(Resources.getString("Editor.search_optWord"), this.searchParameters.isOptWord());
                JRadioButton regex = new JRadioButton(Resources.getString("Editor.search_optRegex"), this.searchParameters.isOptRegex());
                JCheckBox sensitive = new JCheckBox(Resources.getString("Editor.search_case"), this.searchParameters.isMatchCase());
                JCheckBox includeModule = new JCheckBox(Resources.getString("Editor.search_module_tree"), !(this.configureTree instanceof ExtensionTree) || this.searchParameters.isMatchModule());
                JRadioButton simple = new JRadioButton(Resources.getString("Editor.search_simple"), this.searchParameters.isMatchSimple());
                JRadioButton full = new JRadioButton(Resources.getString("Editor.search_full"), this.searchParameters.isMatchFull());
                JRadioButton filters = new JRadioButton(Resources.getString("Editor.search_advanced"), this.searchParameters.isMatchAdvanced());
                JLabel filtersPrompt = new JLabel(Resources.getString("Editor.search_filters"));
                JCheckBox names = new JCheckBox(Resources.getString("Editor.search_names"), this.searchParameters.isMatchNames());
                JCheckBox types = new JCheckBox(Resources.getString("Editor.search_types"), this.searchParameters.isMatchTypes());
                JCheckBox traits = new JCheckBox(Resources.getString("Editor.search_traits"), this.searchParameters.isMatchTraits());
                JCheckBox expressions = new JCheckBox(Resources.getString("Editor.search_expressions"), this.searchParameters.isMatchExpressions());
                JCheckBox properties = new JCheckBox(Resources.getString("Editor.search_properties"), this.searchParameters.isMatchProperties());
                JCheckBox keys = new JCheckBox(Resources.getString("Editor.search_keys"), this.searchParameters.isMatchKeys());
                JCheckBox menus = new JCheckBox(Resources.getString("Editor.search_menus"), this.searchParameters.isMatchMenus());
                JCheckBox messages = new JCheckBox(Resources.getString("Editor.search_messages"), this.searchParameters.isMatchMessages());
                Consumer<Boolean> visSetter = visible -> {
                    filtersPrompt.setVisible((boolean)visible);
                    names.setVisible((boolean)visible);
                    types.setVisible((boolean)visible);
                    traits.setVisible((boolean)visible);
                    expressions.setVisible((boolean)visible);
                    properties.setVisible((boolean)visible);
                    keys.setVisible((boolean)visible);
                    menus.setVisible((boolean)visible);
                    messages.setVisible((boolean)visible);
                };
                visSetter.accept(filters.isSelected());
                this.configureTree.setSearchAdvanced(filters);
                final JButton prev = new JButton(Resources.getString("Editor.search_prev"));
                prev.setToolTipText(Resources.getString("Editor.search_prevTip"));
                prev.setEnabled(false);
                InputMap prevMap = prev.getInputMap(2);
                prevMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "PgUp");
                prev.getActionMap().put("PgUp", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e21) {
                        for (ActionListener a : prev.getActionListeners()) {
                            a.actionPerformed(new ActionEvent(this, 1001, null));
                        }
                    }
                });
                prev.addActionListener(ePrev -> {
                    SearchParameters parametersSetInDialog = new SearchParameters(search.getText(), normal.isSelected(), word.isSelected(), regex.isSelected(), sensitive.isSelected(), includeModule.isSelected(), names.isSelected(), types.isSelected(), simple.isSelected(), full.isSelected(), filters.isSelected(), traits.isSelected(), expressions.isSelected(), properties.isSelected(), keys.isSelected(), menus.isSelected(), messages.isSelected());
                    if (!this.searchParameters.equals(parametersSetInDialog)) {
                        prev.setEnabled(false);
                        ConfigureTree.chat("~" + Resources.getString("Editor.search_prev_invalid"));
                    } else {
                        DefaultMutableTreeNode node;
                        if (newNodeSelected && !this.breadCrumbs.isEmpty()) {
                            while (this.nodeListIndex > 0 && this.breadCrumbs.get(this.nodeListIndex - 1) >= selectedNodeIndex) {
                                this.breadCrumbs.remove(--this.nodeListIndex);
                            }
                        } else if (this.nodeListIndex > 0) {
                            this.breadCrumbs.remove(--this.nodeListIndex);
                        }
                        if (this.nodeListIndex > 0 && (node = this.setNode(this.breadCrumbs.get(this.nodeListIndex - 1))) != null) {
                            this.selectPath(node);
                            this.showHitList(node, this.regexPattern);
                        }
                        prev.setEnabled(this.nodeListIndex > 1);
                    }
                });
                ActionListener checkChanges = e12 -> {
                    SearchParameters parametersSetInDialog = new SearchParameters(search.getText(), normal.isSelected(), word.isSelected(), regex.isSelected(), sensitive.isSelected(), includeModule.isSelected(), names.isSelected(), types.isSelected(), simple.isSelected(), full.isSelected(), filters.isSelected(), traits.isSelected(), expressions.isSelected(), properties.isSelected(), keys.isSelected(), menus.isSelected(), messages.isSelected());
                    prev.setEnabled(this.searchParameters.equals(parametersSetInDialog));
                };
                normal.addActionListener(checkChanges);
                word.addActionListener(checkChanges);
                regex.addActionListener(checkChanges);
                sensitive.addActionListener(checkChanges);
                includeModule.addActionListener(checkChanges);
                simple.addActionListener(checkChanges);
                full.addActionListener(checkChanges);
                filters.addActionListener(checkChanges);
                names.addActionListener(checkChanges);
                types.addActionListener(checkChanges);
                traits.addActionListener(checkChanges);
                expressions.addActionListener(checkChanges);
                properties.addActionListener(checkChanges);
                keys.addActionListener(checkChanges);
                menus.addActionListener(checkChanges);
                messages.addActionListener(checkChanges);
                filters.addChangeListener(l -> {
                    visSetter.accept(filters.isSelected());
                    SwingUtils.repack(this.configureTree.getSearchDialog());
                });
                final JButton find = new JButton(Resources.getString("Editor.search_next"));
                find.setToolTipText(Resources.getString("Editor.search_nextTip"));
                InputMap findMap = find.getInputMap(2);
                findMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "PgDn");
                find.getActionMap().put("PgDn", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e22) {
                        for (ActionListener a : find.getActionListeners()) {
                            a.actionPerformed(new ActionEvent(this, 1001, null));
                        }
                    }
                });
                find.addActionListener(eNext -> {
                    boolean anyChanges;
                    SearchParameters parametersSetInDialog = new SearchParameters(search.getText(), normal.isSelected(), word.isSelected(), regex.isSelected(), sensitive.isSelected(), includeModule.isSelected(), names.isSelected(), types.isSelected(), simple.isSelected(), full.isSelected(), filters.isSelected(), traits.isSelected(), expressions.isSelected(), properties.isSelected(), keys.isSelected(), menus.isSelected(), messages.isSelected());
                    boolean bl = anyChanges = !this.searchParameters.equals(parametersSetInDialog);
                    if (anyChanges) {
                        this.searchParameters.setFrom(parametersSetInDialog);
                        if (!(!this.searchParameters.isMatchAdvanced() || this.searchParameters.isMatchNames() || this.searchParameters.isMatchTypes() || this.searchParameters.isMatchTraits() || this.searchParameters.isMatchExpressions() || this.searchParameters.isMatchProperties() || this.searchParameters.isMatchKeys() || this.searchParameters.isMatchMenus() || this.searchParameters.isMatchMessages())) {
                            this.searchParameters.setMatchNames(true);
                            names.setSelected(true);
                            ConfigureTree.chat(Resources.getString("Editor.search_all_off"));
                        }
                    }
                    if (this.searchParameters.getSearchString().isEmpty()) {
                        prev.setEnabled(false);
                    } else {
                        if (anyChanges || newNodeSelected) {
                            DefaultMutableTreeNode node;
                            if (anyChanges) {
                                int matches;
                                this.regexPattern = this.setupRegexSearch(this.searchParameters.getSearchString());
                                chatter.show("");
                                int n = matches = this.regexPattern == null ? 0 : this.getNumMatches(this.regexPattern);
                                chatter.show(!this.searchParameters.isOptRegex() ? Resources.getString(this.searchParameters.isOptNormal() ? "Editor.search_count" : "Editor.search_countWord", matches, ConfigureTree.noHTML(this.searchParameters.getSearchString())) : (this.regexPattern == null ? "" : Resources.getString("Editor.search_countRegex", matches, ConfigureTree.noHTML(this.regexPattern.toString()))));
                                if (matches > 0) {
                                    this.resetPath();
                                }
                            }
                            if ((node = this.findNode(this.regexPattern)) != null) {
                                this.selectPath(node);
                                this.nodeListIndex = this.initSearchPosition(this.regexPattern);
                                this.showHitList(node, this.regexPattern);
                            }
                        } else if (this.breadCrumbs.isEmpty()) {
                            ConfigureTree.chat(Resources.getString(this.searchParameters.optNormal ? "Editor.search_none_found" : (this.searchParameters.optWord ? "Editor.search_noWord_match" : "Editor.search_noRegex_match"), ConfigureTree.noHTML(!this.searchParameters.optRegex ? this.searchParameters.getSearchString() : this.regexPattern.toString())));
                        } else {
                            DefaultMutableTreeNode node = this.findNode(this.regexPattern);
                            if (node != null) {
                                this.selectPath(node);
                                this.showHitList(node, this.regexPattern);
                            }
                        }
                        prev.setEnabled(this.nodeListIndex > 1);
                    }
                });
                JButton cancel = new JButton(Resources.getString("General.cancel"));
                cancel.addActionListener(e1 -> this.configureTree.getSearchDialog().setVisible(false));
                JButton help = new JButton(Resources.getString("General.help"));
                help.addActionListener(e2 -> this.showSearchHelp());
                d.setLayout((LayoutManager)new MigLayout("", "[fill]"));
                JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1, gapy 4", "[fill]"));
                panel.setBorder(BorderFactory.createEtchedBorder());
                panel.add((Component)search, "grow");
                ButtonGroup searchType = new ButtonGroup();
                searchType.add(normal);
                searchType.add(word);
                searchType.add(regex);
                JPanel optLine1 = new JPanel((LayoutManager)new MigLayout("gapy 4, ins 0", "[]rel[]rel[]rel[]push"));
                optLine1.add(new JLabel(Resources.getString("Editor.search_optLabel")));
                optLine1.add(normal);
                optLine1.add(word);
                optLine1.add(regex);
                panel.add((Component)optLine1, "grow");
                JPanel optLine2 = new JPanel((LayoutManager)new MigLayout("gapy 4, ins 0", "[]rel[]rel[]push"));
                optLine2.add(sensitive);
                panel.add((Component)optLine2, "grow");
                JSeparator sep = new JSeparator();
                sep.setOrientation(0);
                panel.add(sep);
                ButtonGroup searchScope = new ButtonGroup();
                searchScope.add(simple);
                searchScope.add(full);
                searchScope.add(filters);
                JPanel scopePanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[]rel[]rel[]push"));
                scopePanel.add(new JLabel(Resources.getString("Editor.search_scopeLabel")));
                scopePanel.add(simple);
                scopePanel.add(full);
                scopePanel.add(filters);
                scopePanel.add(includeModule);
                includeModule.setVisible(this.configureTree instanceof ExtensionTree);
                panel.add((Component)scopePanel, "grow");
                JPanel filtersTop = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,ins 0,gapy 4", "[]rel[]"));
                filtersTop.add(filtersPrompt);
                filtersTop.add(names);
                JPanel filterList = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,ins 0,gapy 4", "push[]"));
                filterList.add(filtersTop);
                filterList.add(types);
                filterList.add(traits);
                filterList.add(expressions);
                filterList.add(properties);
                filterList.add(keys);
                filterList.add(menus);
                filterList.add(messages);
                panel.add((Component)filterList, "grow");
                JPanel bPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]rel[]push"));
                bPanel.add((Component)prev, "tag prev,sg 1");
                bPanel.add((Component)find, "tag next,sg 1");
                bPanel.add((Component)cancel, "tag cancel,sg 1");
                bPanel.add((Component)help, "tag help,sg 1");
                panel.add((Component)bPanel, "grow");
                d.add((Component)panel, "grow");
                d.getRootPane().setDefaultButton(find);
                KeyStroke k = KeyStroke.getKeyStroke(27, 0);
                d.getRootPane().registerKeyboardAction(ee -> this.configureTree.getSearchDialog().setVisible(false), k, 2);
            }
            search.requestFocus();
            if (!d.isVisible()) {
                d.setLocationRelativeTo(d.getParent());
                SwingUtils.repack(d);
                d.setVisible(true);
            }
        }

        private void selectPath(DefaultMutableTreeNode node) {
            TreePath path = new TreePath(node.getPath());
            this.configureTree.setSelectionPath(path);
            this.configureTree.scrollPathToVisible(path);
        }

        private void resetPath() {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.configureTree.getLastSelectedPathComponent();
            int bookmark = 0;
            if (currentNode != null) {
                bookmark = IntStream.range(0, searchNodes.size()).filter(i -> searchNodes.get(i) == currentNode).findFirst().orElse(-1);
            }
            if (--bookmark < 0) {
                bookmark = searchNodes.size() - 1;
            }
            TreePath path = new TreePath(this.setNode(bookmark).getPath());
            this.configureTree.setSelectionPath(path);
        }

        private void showSearchHelp() {
            File dir = Documentation.getDocumentationBaseDir();
            dir = new File(dir, "ReferenceManual");
            File theFile = new File(dir, "Search.html");
            HelpFile h = null;
            try {
                h = new HelpFile(null, theFile, "#top");
            }
            catch (MalformedURLException e) {
                ErrorDialog.bug(e);
            }
            BrowserSupport.openURL(h.getContents().toString());
        }

        private DefaultMutableTreeNode findNode(Pattern regexPattern) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.configureTree.getLastSelectedPathComponent();
            int bookmark = -1;
            if (currentNode != null) {
                bookmark = ConfigureTree.getBookmark(searchNodes, currentNode);
            }
            Predicate<DefaultMutableTreeNode> nodeMatchesSearchString = node -> this.checkNode((DefaultMutableTreeNode)node, regexPattern);
            lastFoundNode = searchNodes.stream().skip(bookmark + 1).filter(nodeMatchesSearchString).findFirst().orElse(null);
            if (lastFoundNode == null) {
                lastFoundNode = searchNodes.stream().limit(bookmark + 1).filter(nodeMatchesSearchString).findFirst().orElse(null);
                this.breadCrumbs.clear();
                this.nodeListIndex = 0;
            }
            if (lastFoundNode != null) {
                bookmark = ConfigureTree.getBookmark(searchNodes, lastFoundNode);
            }
            selectedNodeIndex = bookmark;
            this.breadCrumbs.add(bookmark);
            ++this.nodeListIndex;
            return lastFoundNode;
        }

        private DefaultMutableTreeNode setNode(int bookmark) {
            selectedNodeIndex = bookmark;
            lastFoundNode = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot()).get(bookmark);
            return lastFoundNode;
        }

        private int getNumMatches(Pattern regexPattern) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            return (int)searchNodes.stream().filter(node -> this.checkNode((DefaultMutableTreeNode)node, regexPattern)).count();
        }

        private int initSearchPosition(Pattern regexPattern) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.configureTree.getLastSelectedPathComponent();
            this.breadCrumbs.clear();
            int i = 0;
            do {
                if (!this.checkNode(searchNodes.get(i), regexPattern)) continue;
                this.breadCrumbs.add(i);
            } while (searchNodes.get(i++) != currentNode);
            return this.breadCrumbs.size();
        }

        private boolean checkSearchTarget(SearchTarget st, Pattern regexPattern) {
            List<String> msgs;
            List<String> menus;
            List<NamedKeyStroke> keys;
            List<String> props;
            List<String> exps;
            if ((this.searchParameters.isMatchExpressions() || this.searchParameters.isMatchFull()) && (exps = st.getExpressionList()) != null) {
                for (String s : exps) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, regexPattern)) continue;
                    return true;
                }
            }
            if ((this.searchParameters.isMatchProperties() || this.searchParameters.isMatchFull()) && (props = st.getPropertyList()) != null) {
                for (String s : props) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, regexPattern)) continue;
                    return true;
                }
            }
            if ((this.searchParameters.isMatchKeys() || this.searchParameters.isMatchFull()) && (keys = st.getNamedKeyStrokeList()) != null) {
                for (NamedKeyStroke k : keys) {
                    String s;
                    if (k == null || StringUtils.isEmpty((CharSequence)(s = k.isNamed() ? k.getName() : KeyNamer.getKeyString(k.getStroke()))) || !this.checkString(s, regexPattern)) continue;
                    return true;
                }
            }
            if ((this.searchParameters.isMatchMenus() || this.searchParameters.isMatchFull()) && (menus = st.getMenuTextList()) != null) {
                for (String s : menus) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, regexPattern)) continue;
                    return true;
                }
            }
            if ((this.searchParameters.isMatchMessages() || this.searchParameters.isMatchFull()) && (msgs = st.getFormattedStringList()) != null) {
                for (String s : msgs) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, regexPattern)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkNode(DefaultMutableTreeNode node, Pattern regexPattern) {
            boolean protoskip;
            GamePiece p;
            String className;
            String objectName;
            ExtensionTree xTree;
            boolean showTypes;
            Configurable c = (Configurable)node.getUserObject();
            boolean showName = this.searchParameters.isMatchNames() || !this.searchParameters.isMatchAdvanced();
            boolean bl = showTypes = this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced();
            if (this.configureTree instanceof ExtensionTree && !this.searchParameters.isMatchModule() && !(xTree = (ExtensionTree)this.configureTree).isEditable(node)) {
                return false;
            }
            if (showName) {
                String desc;
                objectName = c.getConfigureName();
                if (objectName != null && this.checkString(objectName, regexPattern)) {
                    return true;
                }
                if (c instanceof ComponentDescription && (desc = ((ComponentDescription)((Object)c)).getDescription()) != null && this.checkString(desc, regexPattern)) {
                    return true;
                }
            }
            if (showTypes && (className = ConfigureTree.getConfigureName(c.getClass())) != null && this.checkString(className, regexPattern)) {
                return true;
            }
            if (this.searchParameters.isMatchSimple()) {
                return false;
            }
            if (ConfigureTree.getConfigureName(c.getClass()).equals(ConfigureTree.CLASS_MODULE)) {
                if (this.searchParameters.isMatchFull() || this.searchParameters.isMatchMenus()) {
                    if (!showName && (objectName = c.getConfigureName()) != null && this.checkString(objectName, regexPattern)) {
                        return true;
                    }
                    String desc = c.getAttributeValueString("description");
                    if (desc != null && this.checkString(desc, regexPattern)) {
                        return true;
                    }
                    String moduleOther1 = c.getAttributeValueString("ModuleOther1");
                    if (moduleOther1 != null && this.checkString(moduleOther1, regexPattern)) {
                        return true;
                    }
                    String moduleOther2 = c.getAttributeValueString("ModuleOther2");
                    if (moduleOther2 != null) {
                        return this.checkString(moduleOther2, regexPattern);
                    }
                }
            } else {
                DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)node.getParent();
                Configurable p2 = (Configurable)pNode.getUserObject();
                if (ConfigureTree.getConfigureName(p2.getClass()).equals(ConfigureTree.CLASS_HELP_MENU)) {
                    if (!showName && (this.searchParameters.isMatchFull() || this.searchParameters.isMatchMenus())) {
                        return this.checkString(ConfigureTree.getConfigureName(c), regexPattern);
                    }
                    if (this.searchParameters.isMatchFull() || this.searchParameters.isMatchExpressions()) {
                        String startPage = c.getAttributeValueString("startingPage");
                        if (startPage != null) {
                            return this.checkString(startPage, regexPattern);
                        }
                        String pdfFile = c.getAttributeValueString("pdfFile");
                        if (pdfFile != null) {
                            return this.checkString(pdfFile, regexPattern);
                        }
                        String textFile = c.getAttributeValueString("textFile");
                        if (textFile != null) {
                            return this.checkString(textFile, regexPattern);
                        }
                    }
                }
            }
            if (!(c instanceof SearchTarget)) {
                return false;
            }
            if (c instanceof GamePiece) {
                p = (GamePiece)((Object)c);
                protoskip = false;
            } else if (c instanceof PieceSlot) {
                p = ((PieceSlot)c).getPiece();
                protoskip = false;
            } else if (c instanceof PrototypeDefinition) {
                p = ((PrototypeDefinition)c).getPiece();
                protoskip = true;
            } else {
                return this.checkSearchTarget((SearchTarget)((Object)c), regexPattern);
            }
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            pieces.add(p);
            while (p instanceof Decorator) {
                p = ((Decorator)p).getInner();
                pieces.add(p);
            }
            Collections.reverse(pieces);
            for (GamePiece piece : pieces) {
                if (!protoskip) {
                    String desc;
                    if (this.searchParameters.isMatchTraits() && piece instanceof EditablePiece && (desc = ((EditablePiece)piece).getDescription()) != null && this.checkString(desc, regexPattern)) {
                        return true;
                    }
                    if (piece instanceof SearchTarget && this.checkSearchTarget((SearchTarget)((Object)piece), regexPattern)) {
                        return true;
                    }
                }
                protoskip = false;
            }
            return false;
        }

        private void hitCheck(String s, Pattern regexPattern, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!StringUtils.isEmpty((CharSequence)s) && this.checkString(s, regexPattern)) {
                progress.checkShowTrait(matchString, regexPattern, item, desc);
                this.printFind(10, show, s, regexPattern);
            }
        }

        private void stringListHits(Boolean flag, List<String> strings, Pattern regexPattern, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!flag.booleanValue() || strings == null) {
                return;
            }
            for (String s : strings) {
                this.hitCheck(s, regexPattern, matchString, item, desc, show, progress);
            }
        }

        private void keyListHits(Boolean flag, List<NamedKeyStroke> keys, Pattern regexPattern, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!flag.booleanValue() || keys == null) {
                return;
            }
            for (NamedKeyStroke k : keys) {
                if (k == null) continue;
                String s = k.isNamed() ? k.getName() : KeyNamer.getKeyString(k.getStroke());
                this.hitCheck(s, regexPattern, matchString, item, desc, show, progress);
            }
        }

        @Deprecated(since="2023-10-21", forRemoval=true)
        private void showConfigurableHitList(DefaultMutableTreeNode node, Pattern regexPattern) {
            Configurable c = (Configurable)node.getUserObject();
            String item = ConfigureTree.getConfigureName(c.getClass());
            String name = StringUtils.defaultString((String)c.getConfigureName());
            String matchString = Resources.getString("Editor.search_matches", this.nodeListIndex) + "<b>" + ConfigureTree.noHTML(name + " [" + item + "]") + "</b>: ";
            TargetProgress progress = new TargetProgress();
            this.showConfigurableHitList(node, regexPattern, matchString, progress);
        }

        private void showConfigurableHitList(DefaultMutableTreeNode node, Pattern regexPattern, String matchString, TargetProgress progress) {
            boolean showName;
            Configurable c = (Configurable)node.getUserObject();
            String item = ConfigureTree.getConfigureName(c.getClass());
            boolean bl = showName = this.searchParameters.isMatchNames() || !this.searchParameters.isMatchAdvanced();
            if (ConfigureTree.getConfigureName(c.getClass()).equals(ConfigureTree.CLASS_MODULE)) {
                if (this.searchParameters.isMatchFull() || this.searchParameters.isMatchMenus()) {
                    if (!showName) {
                        this.stringListHits(true, Collections.singletonList(ConfigureTree.getConfigureName(c)), regexPattern, matchString, item, "", "ModuleName", progress);
                    }
                    String desc = c.getAttributeValueString("description");
                    String moduleOther1 = c.getAttributeValueString("ModuleOther1");
                    String moduleOther2 = c.getAttributeValueString("ModuleOther2");
                    this.stringListHits(true, Collections.singletonList(desc), regexPattern, matchString, item, "", "ModuleDescription", progress);
                    this.stringListHits(true, Collections.singletonList(moduleOther1), regexPattern, matchString, item, "", "ModuleOther1", progress);
                    this.stringListHits(true, Collections.singletonList(moduleOther2), regexPattern, matchString, item, "", "ModuleOther2", progress);
                }
            } else {
                DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)node.getParent();
                Configurable p = (Configurable)pNode.getUserObject();
                if (ConfigureTree.getConfigureName(p.getClass()).equals(ConfigureTree.CLASS_HELP_MENU)) {
                    if (!showName && (this.searchParameters.isMatchFull() || this.searchParameters.isMatchMenus())) {
                        this.stringListHits(true, Collections.singletonList(ConfigureTree.getConfigureName(c)), regexPattern, matchString, item, "", "UI Text", progress);
                    }
                    if (this.searchParameters.isMatchFull() || this.searchParameters.isMatchExpressions()) {
                        String startPage = c.getAttributeValueString("startingPage");
                        String pdfFile = c.getAttributeValueString("pdfFile");
                        String textFile = c.getAttributeValueString("textFile");
                        this.stringListHits(true, Collections.singletonList(startPage), regexPattern, matchString, item, "", "Starting page", progress);
                        this.stringListHits(true, Collections.singletonList(pdfFile), regexPattern, matchString, item, "", "PDF file", progress);
                        this.stringListHits(true, Collections.singletonList(textFile), regexPattern, matchString, item, "", "Text File", progress);
                    }
                }
            }
            if (!(c instanceof SearchTarget)) {
                return;
            }
            SearchTarget st = (SearchTarget)((Object)c);
            this.stringListHits(this.searchParameters.isMatchExpressions() || this.searchParameters.isMatchFull(), st.getExpressionList(), regexPattern, matchString, item, "", "Expression", progress);
            if (!item.equals(Resources.getString("Editor.GlobalProperty.component_type")) || !showName) {
                this.stringListHits(this.searchParameters.isMatchProperties() || this.searchParameters.isMatchFull(), st.getPropertyList(), regexPattern, matchString, item, "", "Property", progress);
            }
            this.stringListHits(this.searchParameters.isMatchMenus() || this.searchParameters.isMatchFull(), st.getMenuTextList(), regexPattern, matchString, item, "", "UI Text", progress);
            this.stringListHits(this.searchParameters.isMatchMessages() || this.searchParameters.isMatchFull(), st.getFormattedStringList(), regexPattern, matchString, item, "", "Message/Field", progress);
            this.keyListHits(this.searchParameters.isMatchKeys() || this.searchParameters.isMatchFull(), st.getNamedKeyStrokeList(), regexPattern, matchString, item, "", "KeyCommand", progress);
        }

        private void showHitList(DefaultMutableTreeNode node, Pattern regexPattern) {
            boolean protoskip;
            GamePiece p;
            Configurable c = (Configurable)node.getUserObject();
            String item = ConfigureTree.getConfigureName(c.getClass());
            String name = StringUtils.defaultString((String)ConfigureTree.getConfigureName(c));
            TargetProgress progress = new TargetProgress();
            boolean showName = this.searchParameters.isMatchNames() || !this.searchParameters.isMatchAdvanced();
            boolean showTypes = this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced();
            String matchString = Resources.getString("Editor.search_matches", this.nodeListIndex) + "<b>" + ConfigureTree.noHTML(name) + " [" + ConfigureTree.noHTML(item) + "]</b>: ";
            this.stringListHits(showName, Collections.singletonList(ConfigureTree.getConfigureName(c)), regexPattern, matchString, item, "", "Name", progress);
            this.stringListHits(showTypes, List.of(item), regexPattern, matchString, item, "", "Type", progress);
            if (c instanceof ComponentDescription) {
                this.stringListHits(showName, Collections.singletonList(((ComponentDescription)((Object)c)).getDescription()), regexPattern, matchString, item, "", "Description", progress);
            }
            if (this.searchParameters.isMatchSimple()) {
                return;
            }
            if (c instanceof GamePiece) {
                p = (GamePiece)((Object)c);
                protoskip = false;
            } else if (c instanceof PieceSlot) {
                p = ((PieceSlot)c).getPiece();
                protoskip = false;
            } else if (c instanceof PrototypeDefinition) {
                p = ((PrototypeDefinition)c).getPiece();
                protoskip = true;
            } else {
                this.showConfigurableHitList(node, regexPattern, matchString, progress);
                return;
            }
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            pieces.add(p);
            while (p instanceof Decorator) {
                p = ((Decorator)p).getInner();
                pieces.add(p);
            }
            Collections.reverse(pieces);
            this.traitIndex = 0;
            for (GamePiece piece : pieces) {
                if (!protoskip && piece instanceof EditablePiece) {
                    String desc = ((EditablePiece)piece).getDescription();
                    progress.startNewTrait();
                    ++this.traitIndex;
                    if ((this.searchParameters.isMatchTraits() || this.searchParameters.isMatchFull() && (piece instanceof Decorator || !this.searchParameters.isMatchNames() && this.searchParameters.isMatchAdvanced())) && desc != null && this.checkString(desc, regexPattern)) {
                        String[] traitType = piece.getType().split(";");
                        if ((traitType[0] + ";").equals("piece;")) {
                            String pieceInfo = "image: " + (traitType.length < 4 ? "" : traitType[3]) + "&nbsp;".repeat(3) + "gpid: " + String.valueOf(p.getProperty("PieceId"));
                            progress.checkShowTrait(matchString, regexPattern, "Trait", desc, pieceInfo);
                        } else {
                            progress.checkShowTrait(matchString, regexPattern, "Trait", desc);
                        }
                    }
                    if (piece instanceof Decorator) {
                        Decorator d = (Decorator)piece;
                        this.stringListHits(this.searchParameters.isMatchExpressions() || this.searchParameters.isMatchFull(), d.getExpressionList(), regexPattern, matchString, "Trait", desc, "Expression", progress);
                        this.stringListHits(this.searchParameters.isMatchProperties() || this.searchParameters.isMatchFull(), d.getPropertyList(), regexPattern, matchString, "Trait", desc, "Property", progress);
                        this.stringListHits(this.searchParameters.isMatchMenus() || this.searchParameters.isMatchFull(), d.getMenuTextList(), regexPattern, matchString, "Trait", desc, "UI Text", progress);
                        this.stringListHits(this.searchParameters.isMatchMessages() || this.searchParameters.isMatchFull(), d.getFormattedStringList(), regexPattern, matchString, "Trait", desc, "Message/Field", progress);
                        this.keyListHits(this.searchParameters.isMatchKeys() || this.searchParameters.isMatchFull(), d.getNamedKeyStrokeList(), regexPattern, matchString, "Trait", desc, "KeyCommand", progress);
                    }
                }
                protoskip = false;
            }
        }

        private boolean checkString(String target, Pattern regexPattern) {
            return regexPattern.matcher(target).find();
        }

        private void printFind(int padding, String id, String str, Pattern regexPattern) {
            String printStr;
            String string = printStr = StringUtils.isEmpty((CharSequence)str) ? "" : this.highlightFinds(str, regexPattern);
            ConfigureTree.chat((String)(id.equals("Trait") ? (this.traitIndex < 10 ? "&nbsp;&nbsp;<b>" : (this.traitIndex < 100 ? "&nbsp;<b>" : "<b>")) + this.traitIndex + "&gt</b>" + "&nbsp;".repeat(padding - 6) : "&nbsp;".repeat(padding)) + "{" + this.highlightFinds(id, regexPattern) + "} " + printStr);
        }

        private void printFind(int padding, String id, String str, Pattern regexPattern, String strSuffix) {
            String printStr;
            String string = printStr = StringUtils.isEmpty((CharSequence)str) ? "" : this.highlightFinds(str, regexPattern);
            ConfigureTree.chat((String)(id.equals("Trait") ? (this.traitIndex < 10 ? "&nbsp;&nbsp;<b>" : (this.traitIndex < 100 ? "&nbsp;<b>" : "<b>")) + this.traitIndex + "&gt</b>" + "&nbsp;".repeat(padding - 6) : "&nbsp;".repeat(padding)) + "{" + this.highlightFinds(id, regexPattern) + "} " + printStr + "&nbsp;".repeat(10) + "<i>" + strSuffix + "</i>");
        }

        private String highlightFinds(String rawStr, Pattern regexPattern) {
            String htmlHighlighter = "<font bgcolor=yellow>";
            StringBuilder fmtStr = new StringBuilder();
            int lastEnd = 0;
            Matcher match = regexPattern.matcher(rawStr);
            while (match.find()) {
                int start = match.start();
                int end = match.end();
                if (start > lastEnd) {
                    fmtStr.append(ConfigureTree.noHTML(rawStr.substring(lastEnd, start))).append("<font bgcolor=yellow>").append(ConfigureTree.noHTML(rawStr.substring(start, end))).append("</font>");
                } else {
                    if (fmtStr.length() > 12) {
                        fmtStr.replace(fmtStr.length() - 7, fmtStr.length() - 1, "");
                    } else {
                        fmtStr.append("<font bgcolor=yellow>");
                    }
                    fmtStr.append(ConfigureTree.noHTML(rawStr.substring(lastEnd, end))).append("</font>");
                }
                lastEnd = end;
            }
            if (rawStr.length() > lastEnd) {
                fmtStr.append(ConfigureTree.noHTML(rawStr.substring(lastEnd)));
            }
            return fmtStr.toString();
        }

        private Pattern setupRegexSearch(String searchString) {
            int flags;
            int n = flags = this.searchParameters.isMatchCase() ? 0 : 2;
            if (this.searchParameters.isOptNormal()) {
                return Pattern.compile(searchString, flags + 16);
            }
            if (this.searchParameters.isOptWord()) {
                try {
                    return Pattern.compile("\\b\\Q" + searchString + "\\E", flags);
                }
                catch (PatternSyntaxException e) {
                    logger.error(Resources.getString("Editor.search_badWord", ConfigureTree.noHTML(e.getMessage())));
                    return null;
                }
            }
            try {
                return Pattern.compile(searchString, flags);
            }
            catch (PatternSyntaxException e) {
                ConfigureTree.chat(Resources.getString("Editor.search_badRegex", ConfigureTree.noHTML(e.getMessage())));
                return null;
            }
        }

        private class TargetProgress {
            public boolean targetShown = false;
            public boolean traitShown = false;

            private TargetProgress() {
            }

            void startNewTrait() {
                this.traitShown = false;
            }

            void checkShowPiece(String matchString) {
                if (!this.targetShown) {
                    this.targetShown = true;
                    ConfigureTree.chat("<font color=blue>" + matchString + "</font>");
                }
            }

            void checkShowTrait(String matchString, Pattern regexPattern, String idString, String desc) {
                this.checkShowPiece(matchString);
                if (!this.traitShown) {
                    this.traitShown = true;
                    SearchAction.this.printFind(7, idString, desc, regexPattern);
                }
            }

            void checkShowTrait(String matchString, Pattern regexPattern, String idString, String desc, String suffix) {
                this.checkShowPiece(matchString);
                if (!this.traitShown) {
                    this.traitShown = true;
                    SearchAction.this.printFind(7, idString, desc, regexPattern, suffix);
                }
            }
        }
    }

    protected class ImportAction
    extends AddAction {
        private static final long serialVersionUID = 1L;

        public ImportAction(Configurable target, String name) {
            super(target, null, name, -1, null);
        }

        @Override
        protected Configurable getChild() {
            return ConfigureTree.this.importConfigurable();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Configurable child = this.getChild();
            try {
                this.doIt(child);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(child) + " to " + ConfigureTree.getConfigureName(this.target) + "\n" + ex.getMessage(), "Illegal configuration", 0);
            }
        }
    }

    protected static class AdditionalComponent {
        Class<? extends Buildable> parent;
        Class<? extends Buildable> child;

        public AdditionalComponent(Class<? extends Buildable> p, Class<? extends Buildable> c) {
            this.parent = p;
            this.child = c;
        }

        public Class<? extends Buildable> getParent() {
            return this.parent;
        }

        public Class<? extends Buildable> getChild() {
            return this.child;
        }
    }

    protected class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected final Configurable target;
        private final Class<? extends Buildable> newConfig;
        private final int index;
        private final Configurable duplicate;

        public AddAction(Configurable target, Class<? extends Buildable> newConfig, String name, int index, Configurable duplicate) {
            super(name);
            this.target = target;
            this.newConfig = newConfig;
            this.index = index;
            this.duplicate = duplicate;
        }

        protected Configurable getChild() {
            try {
                return (Configurable)this.newConfig.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, this.newConfig);
                return null;
            }
        }

        protected void doIt(final Configurable child) {
            int finalIndex;
            if (child == null) {
                return;
            }
            if (child instanceof AbstractBuildable) {
                ((AbstractBuildable)((Object)child)).setAncestor(this.target);
            }
            child.build(this.duplicate != null ? this.duplicate.getBuildElement(Builder.createNewDocument()) : null);
            if (child instanceof PieceSlot) {
                ((PieceSlot)child).updateGpId(GameModule.getGameModule());
            }
            int n = finalIndex = this.index < 0 ? ConfigureTree.this.getTreeNode(this.target).getChildCount() : ConfigureTree.this.checkMinimumIndex(ConfigureTree.this.getTreeNode(this.target), this.index);
            if (child.getConfigurer() != null) {
                if (ConfigureTree.this.insert(this.target, child, finalIndex)) {
                    if (this.duplicate != null) {
                        ConfigureTree.this.updateGpIds(child);
                    }
                    TreePath path = new TreePath(ConfigureTree.this.getTreeNode(child).getPath());
                    ConfigureTree.this.expandPath(path);
                    PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, child, ConfigureTree.this.helpWindow){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void cancel() {
                            DefaultMutableTreeNode currentParent = (DefaultMutableTreeNode)ConfigureTree.this.getTreeNode(child).getParent();
                            if (currentParent != null) {
                                ConfigureTree.this.delete(child);
                            }
                            this.dispose();
                        }

                        @Override
                        public void save() {
                            DefaultMutableTreeNode node;
                            ConfigureTree.this.notifyUpdate(child);
                            if (AddAction.this.duplicate != null && (node = ConfigureTree.this.getTreeNode(child)) != null) {
                                TreePath path = new TreePath(node.getPath());
                                ConfigureTree.this.setSelectionPath(path);
                                ConfigureTree.this.scrollPathToVisible(path);
                            }
                            super.save();
                        }
                    };
                    w.setVisible(true);
                }
            } else {
                ConfigureTree.this.insert(this.target, child, finalIndex);
                if (this.duplicate != null) {
                    ConfigureTree.this.updateGpIds(child);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.doIt(this.getChild());
        }
    }

    public static interface Mutable {
    }
}

