/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.Resources;
import java.awt.Component;
import javax.swing.JLabel;

public abstract class BasicPreference
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String TAB = "tab";
    public static final String DESC = "desc";
    public static final String DEFAULT = "default";
    protected String tabName;
    protected String variableName = "";
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);

    public BasicPreference() {
        this.tabName = GameModule.getGameModule().getConfigureName();
        this.setAttributeTranslatable(NAME, false);
        this.setAttributeTranslatable(DEFAULT, false);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"note", TAB, DESC, NAME, DEFAULT};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"", Resources.getString("Editor.BasicPreference.tab"), Resources.getString("Editor.BasicPreference.desc"), Resources.getString("Editor.BasicPreference.global"), Resources.getString("Editor.BasicPreference.default")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{NoteConfig.class, String.class, String.class, String.class, this.getDefaultClass()};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.variableName = (String)value;
            this.property.setPropertyName(this.variableName);
        } else if (TAB.equals(key)) {
            this.tabName = (String)value;
        } else if (DESC.equals(key)) {
            this.setConfigureName((String)value);
        } else if (DEFAULT.equals(key)) {
            this.setDefaultValue(value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getVariableName();
        }
        if (TAB.equals(key)) {
            return this.tabName;
        }
        if (DESC.equals(key)) {
            return this.getConfigureName();
        }
        if (DEFAULT.equals(key)) {
            return this.getDefaultValue();
        }
        return null;
    }

    public abstract Class<?> getDefaultClass();

    public abstract String getDefaultValue();

    public abstract void setDefaultValue(Object var1);

    public abstract Configurer getPreferenceConfigurer();

    @Override
    public void addTo(Buildable b) {
        GameModule g = GameModule.getGameModule();
        this.property.addTo(g);
        g.getPrefs().addOption(this.tabName == null || this.tabName.isEmpty() ? null : this.tabName, this.getPreferenceConfigurer());
    }

    protected void updateGlobalProperty(String newValue) {
        this.property.setPropertyValue(newValue);
    }

    @Override
    public void removeFrom(Buildable b) {
        this.property.removeFromContainer();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalOptions.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String getDescription() {
        return this.getConfigureName();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public static class NoteConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new Configurer(null, "note"){

                @Override
                public String getValueString() {
                    return null;
                }

                @Override
                public void setValue(String s) {
                }

                @Override
                public Component getControls() {
                    return new JLabel(Resources.getString("Editor.BasicPreference.note"));
                }
            };
        }
    }
}

