/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ButtonFactory;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class StrBuilder
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected StringConfigurer target;
    protected StringConfigurer entry;

    public StrBuilder(StringConfigurer c, JDialog parent) {
        super(parent, Resources.getString("Editor.StringBuilder.component_type"), true);
        this.target = c;
        this.build(Resources.getString("Editor.StringBuilder.object_type"));
    }

    public StrBuilder(JDialog parent, String string, boolean b) {
        super(parent, string, b);
    }

    protected void build(String type) {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        JPanel p = new JPanel();
        p.setLayout((LayoutManager)new MigLayout("fillx", "[grow 0]rel[grow 1]"));
        p.add((Component)new JLabel(type + ":"), "growx");
        this.entry = new StringConfigurer("", "");
        p.add(this.entry.getControls(), "wrap,growx");
        JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("", "[]rel[]rel[]"));
        JButton okButton = ButtonFactory.getOkButton();
        okButton.addActionListener(e -> this.save());
        buttonBox.add(okButton);
        JButton cancelButton = ButtonFactory.getCancelButton();
        cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add(cancelButton);
        p.add((Component)buttonBox, "span 2,align center");
        this.add((Component)p, "growx");
        SwingUtils.setDefaultButtons(this.getRootPane(), okButton, cancelButton);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                StrBuilder.this.cancel();
            }
        });
    }

    protected void save() {
        String result = this.entry.getValueString();
        if (result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        result = result.replace("\"", "\\\"");
        this.target.setValue("\"" + result + "\"");
        this.dispose();
    }

    protected void cancel() {
        this.dispose();
    }
}

