/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.DependencyWalker;
import VASSAL.tools.deprecation.Processor;
import VASSAL.tools.deprecation.Walker;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;

public class DependencyChecker {
    public static void main(String[] args) throws IOException {
        String infile;
        String compfile;
        String outfile;
        if (args.length != 2 && args.length != 4) {
            throw new IllegalArgumentException();
        }
        if ("-o".equals(args[0])) {
            outfile = args[1];
            compfile = args[2];
            infile = args[3];
        } else {
            outfile = null;
            compfile = args[0];
            infile = args[1];
        }
        HashSet comp = new HashSet();
        try (InputStream in = Files.newInputStream(Paths.get(compfile, new String[0]), new OpenOption[0]);){
            Processor.readCompSet(in, cols -> comp.add(cols[0]));
        }
        DependencyWalker walker = new DependencyWalker();
        HashSet deps = new HashSet();
        Consumer<String> collect = s -> {
            if (comp.contains(s)) {
                deps.add(s);
            }
        };
        walker.setClassCallback(collect);
        walker.setMethodCallback(collect);
        walker.setFieldCallback(collect);
        try (PrintStream ps = outfile == null ? System.out : new PrintStream(outfile, StandardCharsets.UTF_8);){
            walker.setThisClassEndCallback(s -> {
                if (!deps.isEmpty()) {
                    ps.println((String)s);
                    Object[] darr = deps.toArray(new String[0]);
                    Arrays.sort(darr);
                    for (Object dep : darr) {
                        ps.println("  " + (String)dep);
                    }
                    ps.println("");
                    deps.clear();
                }
            });
            Processor.process((Walker)walker, infile);
        }
    }
}

