/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.build.GameModule;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.LabelerDataArchiveHTMLEditorKit;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class DataArchiveTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;

    public DataArchiveTextPane(String text, String styleName, Color color, Font font) {
        if (styleName == null || styleName.isBlank()) {
            styleName = "label";
        }
        this.setContentType("text/html");
        LabelerDataArchiveHTMLEditorKit kit = new LabelerDataArchiveHTMLEditorKit(GameModule.getGameModule().getDataArchive());
        this.setEditorKit(kit);
        StyleSheet style = kit.getStyleSheet();
        style.addRule("." + styleName + " {color:" + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + "; font-family:" + font.getFamily() + "; font-size:" + font.getSize() + "pt; " + (font.isBold() ? "font-weight:bold" : "") + "; background-color: rgba(255, 0, 0, 0.5);}");
        style.addRule("." + styleName + "color {color:" + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + "; }");
        this.setOpaque(false);
        StyleConstants.setBackground(style.getStyle("." + styleName), new Color(0, 0, 0, 0));
        String fixed = text.replaceFirst("<html>", "").replaceFirst("</html>", "");
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        try {
            kit.insertHTML(doc, doc.getLength(), "<html><div class=\"" + styleName + "\">" + fixed + "</div></html>", 0, 0, null);
        }
        catch (IOException | BadLocationException ble) {
            ErrorDialog.bug(ble);
        }
        this.setSize(this.getPreferredSize());
    }
}

